/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.io.Serializable;
import jetbrains.exodus.database.exceptions.EntityFieldHandler;
import jetbrains.exodus.util.StringInterner;
import jetbrains.mps.webr.runtime.requestProcessor.FieldBindingManager;
import jetbrains.mps.webr.runtime.templateComponent.InputValue;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponentProvider;
import jetbrains.mps.webr.runtime.templateComponent.ValuePopulator;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import webr.framework.controller.ControllerOperations;
import webr.framework.textBuilder.PopulateParameters;

public class BoundValue<T>
extends InputValue<T>
implements Serializable {
    private String parameterName;
    private boolean commaSeparated = false;
    private ValuePopulator valuePopulator;

    public BoundValue(T value, ValuePopulator valuePopulator) {
        super(value);
        this.valuePopulator = valuePopulator;
    }

    public void populate(PopulateParameters populateParameters, TemplateComponentProvider componentProvider) {
        if (populateParameters.hasParameter(this.parameterName)) {
            this.valuePopulator.populate(this, componentProvider);
        }
    }

    public void setParameterName(String name) {
        this.parameterName = StringInterner.intern((String)name);
    }

    public void setCommaSeparated(boolean commaSeparated) {
        this.commaSeparated = commaSeparated;
    }

    public T getParameterValue(Class<T> parameterType) {
        return ControllerOperations.getLabeledInputValue(this.parameterName, parameterType);
    }

    public T getParameterValues(Class elementParameterType) {
        return (T)ControllerOperations.getLabeledInputValues(this.parameterName, elementParameterType, this.commaSeparated);
    }

    public void addFieldBinding(EntityFieldHandler handler) {
        if (handler != null) {
            ((FieldBindingManager)ServiceLocator.getBean((String)"fieldBindingManager")).addBinding(handler, this.parameterName);
        }
    }

    public static <T> BoundValue<T> create(T value, ValuePopulator valuePopulator) {
        return new BoundValue<T>(value, valuePopulator);
    }
}

