/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import jetbrains.exodus.database.exceptions.CantRemoveEntityException;
import jetbrains.exodus.database.exceptions.CardinalityViolationException;
import jetbrains.exodus.database.exceptions.ConstraintsValidationException;
import jetbrains.exodus.database.exceptions.DataIntegrityViolationException;
import jetbrains.exodus.database.exceptions.DatabaseStateIsReadonlyException;
import jetbrains.exodus.database.exceptions.NullPropertyException;
import jetbrains.exodus.database.exceptions.OrphanChildException;
import jetbrains.exodus.database.exceptions.SimplePropertyValidationException;
import jetbrains.exodus.database.exceptions.UniqueIndexViolationException;
import jetbrains.exodus.entitystore.EntityRemovedInDatabaseException;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.mps.webr.runtime.requestProcessor.FieldBindingManager;
import jetbrains.mps.webr.runtime.requestProcessor.JsResponseFactory;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import webr.framework.controller.BaseApplication;
import webr.framework.controller.ErrorMessageManager;
import webr.framework.controller.exception.LabeledInputException;
import webr.framework.function.HtmlStringUtil;
import webr.framework.runtime.response.CommandResponseAction;

public class ExceptionHandlingUtil {
    public static boolean handleException(Throwable e) {
        if (!ResponseFactory.isXMLHttpRequest()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        if (e instanceof ConstraintsValidationException) {
            ExceptionHandlingUtil.handleConstraintsValidationException((ConstraintsValidationException)e);
            return false;
        }
        if (e instanceof LabeledInputException) {
            ExceptionHandlingUtil.handleLabeledInputException((LabeledInputException)e);
            return false;
        }
        if (e instanceof SecurityException) {
            ExceptionHandlingUtil.handleSecurityException((SecurityException)e);
            return false;
        }
        if (e instanceof DatabaseStateIsReadonlyException) {
            ExceptionHandlingUtil.handleDatabaseStateIsReadonlyException((DatabaseStateIsReadonlyException)e);
            return false;
        }
        if (e instanceof LogicException) {
            ExceptionHandlingUtil.handleLogicException((LogicException)e);
            return false;
        }
        if (e instanceof EntityRemovedInDatabaseException) {
            ExceptionHandlingUtil.handleEntityRemovedInDatabaseException((EntityRemovedInDatabaseException)e);
            return false;
        }
        if (e instanceof ReadonlyTransactionException) {
            ExceptionHandlingUtil.handleReadonlyTransactionalException((ReadonlyTransactionException)e);
            return false;
        }
        return true;
    }

    protected static void handleSecurityException(SecurityException e) {
        JsResponseFactory factory = ResponseFactory.getJsResponseFactory();
        CommandResponseAction commandResponseAction = factory.getForbiddenResponse(e.getLocalizedMessage());
        BaseApplication.getCompositeCommand().addCommand(commandResponseAction);
    }

    public static void handleReadonlyTransactionalException(ReadonlyTransactionException e) {
        JsResponseFactory factory = ResponseFactory.getJsResponseFactory();
        String message = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.Application_is_in_readonly_state_operation_cannot_be_performed", new Object[0]);
        IListSequence messages = ListSequence.fromListAndArray(new ArrayList(), (Object[])new ErrorMessageManager.Message[]{new ErrorMessageManager.Message((Serializable)((Object)message), ErrorMessageManager.Severity.ERROR, null)});
        BaseApplication.getCompositeCommand().addCommand(factory.getShowErrorMessagesResponse((Iterable<ErrorMessageManager.Message>)messages));
    }

    protected static void handleLabeledInputException(LabeledInputException e) {
        IListSequence messages = ListSequence.fromListAndArray(new ArrayList(), (Object[])new ErrorMessageManager.Message[]{new ErrorMessageManager.Message((Serializable)((Object)e.getConvertException().getDisplayMessage()), ErrorMessageManager.Severity.ERROR, null)});
        JsResponseFactory factory = ResponseFactory.getJsResponseFactory();
        CommandResponseAction commandResponseAction = factory.getShowErrorMessagesResponse((Iterable<ErrorMessageManager.Message>)messages);
        BaseApplication.getCompositeCommand().addCommand(commandResponseAction);
    }

    protected static void handleLogicException(LogicException e) {
        JsResponseFactory factory = ResponseFactory.getJsResponseFactory();
        IListSequence messages = ListSequence.fromListAndArray(new ArrayList(), (Object[])new ErrorMessageManager.Message[]{new ErrorMessageManager.Message((Serializable)((Object)e.getLocalizedMessage()), ErrorMessageManager.Severity.ERROR, null)});
        BaseApplication.getCompositeCommand().addCommand(factory.getShowErrorMessagesResponse((Iterable<ErrorMessageManager.Message>)messages));
    }

    protected static void handleEntityRemovedInDatabaseException(EntityRemovedInDatabaseException e) {
        JsResponseFactory factory = ResponseFactory.getJsResponseFactory();
        String message = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.Database_entity_was_removed_Please_{reload}_the_page", new Object[]{"<a href=\"javascript:window.location.reload()\">" + ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.reload", new Object[0]) + "</a>"});
        IListSequence messages = ListSequence.fromListAndArray(new ArrayList(), (Object[])new ErrorMessageManager.Message[]{new ErrorMessageManager.Message((Serializable)((Object)message), ErrorMessageManager.Severity.INFO, null)});
        BaseApplication.getCompositeCommand().addCommand(factory.getShowErrorMessagesResponse((Iterable<ErrorMessageManager.Message>)messages));
    }

    protected static void handleDatabaseStateIsReadonlyException(DatabaseStateIsReadonlyException e) {
        JsResponseFactory factory = ResponseFactory.getJsResponseFactory();
        CommandResponseAction commandResponseAction = (CommandResponseAction)factory.getInternalServerErrorResponse(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.Maintenance_is_in_progress_Please_repeat_your_action_later", new Object[0]));
        BaseApplication.getCompositeCommand().addCommand(commandResponseAction);
    }

    protected static void handleConstraintsValidationException(ConstraintsValidationException e) {
        Set causes = e.getCauses();
        ISequence messages = Sequence.fromIterable((Iterable)causes).select((_FunctionTypes._return_P1_E0)new ISelector<DataIntegrityViolationException, ErrorMessageManager.Message>(){

            public ErrorMessageManager.Message select(DataIntegrityViolationException it) {
                return new ErrorMessageManager.Message((Serializable)((Object)ExceptionHandlingUtil.getLocalizedDisplayMessage(it)), ErrorMessageManager.Severity.ERROR, ((FieldBindingManager)ServiceLocator.getBean((String)"fieldBindingManager")).getInputName(it.getEntityFieldHandler()), it instanceof SimplePropertyValidationException ? ((SimplePropertyValidationException)it).getPropertyName() : null);
            }
        });
        JsResponseFactory factory = ResponseFactory.getJsResponseFactory();
        CommandResponseAction commandResponseAction = factory.getShowErrorMessagesResponse((Iterable<ErrorMessageManager.Message>)messages);
        BaseApplication.getCompositeCommand().addCommand(commandResponseAction);
    }

    private static String getLocalizedDisplayMessage(DataIntegrityViolationException e) {
        String msg;
        if (e instanceof NullPropertyException) {
            msg = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.Value_is_required_for_null_property_fix", new Object[0]);
        } else if (e instanceof UniqueIndexViolationException) {
            msg = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.Value_should_be_unique", new Object[0]);
        } else if (e instanceof CardinalityViolationException) {
            msg = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.Value_is_required_for_cardinality_error_fix", new Object[0]);
        } else if (e instanceof OrphanChildException) {
            msg = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.Missed_required_database_entity_associtaion", new Object[0]);
        } else if (e instanceof CantRemoveEntityException) {
            msg = ExceptionHandlingUtil.getHtmlFormattedMessage((CantRemoveEntityException)e);
        } else {
            return HtmlStringUtil.html(e.getDisplayMessage());
        }
        return msg;
    }

    private static String getHtmlFormattedMessage(CantRemoveEntityException exception) {
        boolean hasSingleCause;
        StringBuilder sb = new StringBuilder();
        sb.append("<div class=\"").append("entity-exception").append("\">");
        String header = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ExceptionHandlingUtil.Could_not_delete_{0}_because_it_is_referenced_as", new Object[]{HtmlStringUtil.html(exception.getEntityPresentation())});
        sb.append("<h4 class=\"").append("title").append("\">").append(header).append("</h4>");
        boolean bl = hasSingleCause = exception.getCauses().size() == 1;
        if (hasSingleCause) {
            sb.append("<div class=\"").append("single-cause").append("\">");
            for (String line : (Collection)exception.getCauses().iterator().next()) {
                sb.append(HtmlStringUtil.html(line)).append("</br>");
            }
            sb.append("</div></div>");
        } else {
            sb.append("<ol>");
            for (Collection cause : exception.getCauses()) {
                sb.append("<li>");
                for (String line : cause) {
                    sb.append(HtmlStringUtil.html(line)).append("</br>");
                }
                sb.append("</li>");
            }
            sb.append("</ol></div>");
        }
        return sb.toString();
    }
}

