/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.runtime.templateComponent;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.InnerTemplate;
import jetbrains.mps.webr.javascript.runtime.jsDependencies.JsDependencyManager;
import jetbrains.mps.webr.runtime.templateComponent.ITemplateFactory;
import jetbrains.mps.webr.runtime.templateComponent.TemplateComponent;
import jetbrains.mps.webr.runtime.templateComponent.TemplateDependency;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.jetbrains.annotations.Nullable;

public class TemplateDependencyManager {
    private Map<String, TemplateDependency> templateDependencies;
    private Map<String, String> templateNameToClass;
    private Map<String, ITemplateFactory> templateNameToFactory;
    private Map<String, String> templateClassToName;
    private Map<String, Set<String>> cachedTemplateJsDependencies = MapSequence.fromMap(new HashMap());
    private Map<String, Set<String>> cachedCssDependencies = MapSequence.fromMap(new HashMap());
    private Map<String, Set<String>> cachedDynamicTemplateJsDependencies = MapSequence.fromMap(new HashMap());

    public void setTemplateDependencies(List<TemplateDependency> templateDependencies) {
        this.templateDependencies = MapSequence.fromMap(new HashMap());
        this.templateNameToClass = MapSequence.fromMap(new HashMap());
        this.templateClassToName = MapSequence.fromMap(new HashMap());
        this.templateNameToFactory = new ConcurrentHashMap<String, ITemplateFactory>();
        ListSequence.fromList(templateDependencies).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<TemplateDependency>(){

            public void visit(TemplateDependency it) {
                MapSequence.fromMap((Map)TemplateDependencyManager.this.templateDependencies).put((Object)it.getClassName(), (Object)it);
                MapSequence.fromMap((Map)TemplateDependencyManager.this.templateNameToClass).put((Object)it.getName(), (Object)it.getClassName());
                MapSequence.fromMap((Map)TemplateDependencyManager.this.templateClassToName).put((Object)it.getClassName(), (Object)it.getName());
            }
        });
    }

    public TemplateDependency getTemplateJsDependency(String templateClassName) {
        return (TemplateDependency)MapSequence.fromMap(this.templateDependencies).get((Object)templateClassName);
    }

    public String getTemplateClassName(String templatName) {
        return (String)MapSequence.fromMap(this.templateNameToClass).get((Object)templatName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ITemplateFactory getTemplateFactory(String templateName) {
        ITemplateFactory f = this.templateNameToFactory.get(templateName);
        if (f == null) {
            TemplateDependencyManager templateDependencyManager = this;
            synchronized (templateDependencyManager) {
                String templateClass = (String)MapSequence.fromMap(this.templateNameToClass).get((Object)templateName);
                String factoryClassName = ((TemplateDependency)MapSequence.fromMap(this.templateDependencies).get((Object)templateClass)).getFactoryClassName();
                if (factoryClassName != null && factoryClassName.length() > 0) {
                    try {
                        Class<?> templateFactoryClazz = Thread.currentThread().getContextClassLoader().loadClass(factoryClassName);
                        f = (ITemplateFactory)templateFactoryClazz.newInstance();
                        this.templateNameToFactory.put(templateName, f);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return f;
    }

    public String getTemplateName(String templatClass) {
        return (String)MapSequence.fromMap(this.templateClassToName).get((Object)templatClass);
    }

    public String getTemplateName(TemplateComponent tc) {
        return (String)MapSequence.fromMap(this.templateClassToName).get((Object)tc.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> getCssDependencies(String layoutName, String rootTemplateName) {
        Set css;
        Map<String, Set<String>> map = this.cachedCssDependencies;
        synchronized (map) {
            css = (Set)MapSequence.fromMap(this.cachedCssDependencies).get((Object)rootTemplateName);
            if (css == null) {
                css = SetSequence.fromSet(new LinkedHashSet());
                ISetSequence visitedTemplates = SetSequence.fromSet(new HashSet());
                this.collectTemplateCssDependencies(layoutName, (Set<String>)visitedTemplates, css);
                this.collectTemplateCssDependencies(rootTemplateName, (Set<String>)visitedTemplates, css);
                MapSequence.fromMap(this.cachedCssDependencies).put((Object)rootTemplateName, (Object)css);
            }
        }
        return css;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getSortedDependencies(String layoutName, String rootTemplateName) {
        Set jsRoots;
        Map<String, Set<String>> map = this.cachedTemplateJsDependencies;
        synchronized (map) {
            jsRoots = (Set)MapSequence.fromMap(this.cachedTemplateJsDependencies).get((Object)rootTemplateName);
            if (jsRoots == null) {
                jsRoots = new jetbrains.exodus.core.dataStructures.hash.HashSet();
                jetbrains.exodus.core.dataStructures.hash.HashSet visitedTemplates = new jetbrains.exodus.core.dataStructures.hash.HashSet();
                this.collectTemplateDependencies(layoutName, (Set<String>)visitedTemplates, jsRoots);
                this.collectTemplateDependencies(rootTemplateName, (Set<String>)visitedTemplates, jsRoots);
                jsRoots = ((JsDependencyManager)ServiceLocator.getBean((String)"jsDependencyManager")).sortDependencies((Iterable)jsRoots, null);
                MapSequence.fromMap(this.cachedTemplateJsDependencies).put((Object)rootTemplateName, (Object)jsRoots);
            }
        }
        return jsRoots;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterable<String> getDynamicDependencies(String layoutName, String rootTemplateName, String dynamicTemplateName) {
        Set jsRoots;
        Map<String, Set<String>> map = this.cachedDynamicTemplateJsDependencies;
        synchronized (map) {
            jsRoots = (Set)MapSequence.fromMap(this.cachedDynamicTemplateJsDependencies).get((Object)(rootTemplateName + dynamicTemplateName));
            if (jsRoots == null) {
                jsRoots = SetSequence.fromSet(new HashSet());
                Set<String> exceptDependencies = this.getSortedDependencies(layoutName, rootTemplateName);
                ISetSequence visitedTemplates = SetSequence.fromSet(new HashSet());
                this.collectTemplateDependencies(dynamicTemplateName, (Set<String>)visitedTemplates, jsRoots);
                jsRoots = ((JsDependencyManager)ServiceLocator.getBean((String)"jsDependencyManager")).sortDependencies((Iterable)jsRoots, exceptDependencies);
                MapSequence.fromMap(this.cachedDynamicTemplateJsDependencies).put((Object)(rootTemplateName + dynamicTemplateName), (Object)jsRoots);
            }
        }
        return jsRoots;
    }

    private void collectTemplateCssDependencies(String dependencyName, Set<String> visitedTemplates, Set<String> css) {
        if (dependencyName != null && dependencyName.length() > 0 && !SetSequence.fromSet(visitedTemplates).contains((Object)dependencyName)) {
            SetSequence.fromSet(visitedTemplates).addElement((Object)dependencyName);
            TemplateDependency dependency = (TemplateDependency)MapSequence.fromMap(this.templateDependencies).get((Object)dependencyName);
            if (dependency != null) {
                SetSequence.fromSet(css).addSequence((ISequence)ListSequence.fromList(dependency.getCssDependencies()));
                for (InnerTemplate innerTemplateName : ListSequence.fromList(dependency.getInnerTemplates())) {
                    this.collectTemplateCssDependencies(innerTemplateName.getClassName(), visitedTemplates, css);
                }
            }
        }
    }

    private void collectTemplateDependencies(String dependencyName, Set<String> visitedTemplates, Set<String> jsRoots) {
        if (dependencyName != null && dependencyName.length() > 0 && !SetSequence.fromSet(visitedTemplates).contains((Object)dependencyName)) {
            SetSequence.fromSet(visitedTemplates).addElement((Object)dependencyName);
            TemplateDependency dependency = (TemplateDependency)MapSequence.fromMap(this.templateDependencies).get((Object)dependencyName);
            if (dependency != null) {
                SetSequence.fromSet(jsRoots).addSequence((ISequence)ListSequence.fromList(dependency.getDependencies()));
                for (InnerTemplate innerTemplateName : ListSequence.fromList(dependency.getInnerTemplates())) {
                    this.collectTemplateDependencies(innerTemplateName.getClassName(), visitedTemplates, jsRoots);
                }
            }
        }
    }
}

