/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller;

import java.util.Collection;
import java.util.Map;
import javax.servlet.ServletContext;
import jetbrains.exodus.core.dataStructures.hash.HashMap;
import jetbrains.exodus.core.execution.locks.Latch;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.ContainerHolder;

public class MultipleContainerHolder
implements ContainerHolder {
    private volatile Map<ServletContext, BeanContainer> containers = new HashMap();
    private final Latch writeLock = Latch.create();

    @Override
    public BeanContainer get(ServletContext context) {
        return this.containers.get(context);
    }

    @Override
    public BeanContainer putIfAbsent(ServletContext context, BeanContainer beanContainer) {
        BeanContainer container;
        try {
            this.writeLock.acquire();
            Map<ServletContext, BeanContainer> containers = this.containers;
            container = containers.get(context);
            if (container == null) {
                HashMap result = new HashMap(containers.size() + 1);
                for (ServletContext existing : containers.keySet()) {
                    result.put(existing, containers.get(existing));
                }
                container = beanContainer;
                result.put(context, container);
                this.containers = result;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.release();
        }
        return container;
    }

    @Override
    public void remove(BeanContainer container) {
        try {
            this.writeLock.acquire();
            ServletContext removed = container.getContext();
            Map<ServletContext, BeanContainer> containers = this.containers;
            HashMap result = new HashMap(containers.size() - 1);
            for (ServletContext context : containers.keySet()) {
                if (removed.equals(context)) continue;
                result.put(context, containers.get(context));
            }
            this.containers = result;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.release();
        }
    }

    @Override
    public boolean isEmpty() {
        return this.containers.isEmpty();
    }

    @Override
    public Collection<BeanContainer> values() {
        return this.containers.values();
    }

    @Override
    public void clear() {
        try {
            this.writeLock.acquire();
            this.containers = new HashMap();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.release();
        }
    }
}

