/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.controller;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.springframework.configuration.runtime.MyClassPathXmlApplicationContextCreator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import webr.framework.controller.BeanContainer;
import webr.framework.controller.WebClasspathXmlServiceLocator;
import webr.framework.controller.WebLocalScope;

public class WebLocalClasspathXmlServiceLocator
extends WebClasspathXmlServiceLocator {
    private static final Log log = LogFactory.getLog(WebLocalClasspathXmlServiceLocator.class);
    private static final Scope LOCAL = new WebLocalScope();
    public static final String DO_NOT_CLOSE_GLOBAL_ON_LAST_LOCAL_CLOSE_OPTION = "jetbrains.mps.webr.doNotCloseGlobalScopeOnLastLocalScopeClose";
    private static final boolean DO_NOT_CLOSE_GLOBAL_ON_LAST_LOCAL_CLOSE = Boolean.getBoolean("jetbrains.mps.webr.doNotCloseGlobalScopeOnLastLocalScopeClose");
    protected final ConcurrentMap<String, Object> globalBeans = new ConcurrentHashMap<String, Object>();

    public WebLocalClasspathXmlServiceLocator(String[] configs) {
        this(configs, WEB_CONTEXT_CREATOR);
    }

    public WebLocalClasspathXmlServiceLocator(String[] configs, boolean registerShutdownHooks) {
        this(configs, registerShutdownHooks, WEB_CONTEXT_CREATOR);
    }

    public WebLocalClasspathXmlServiceLocator(String[] configs, MyClassPathXmlApplicationContextCreator creator) {
        this(configs, true, creator);
    }

    public WebLocalClasspathXmlServiceLocator(String[] configs, boolean registerShutdownHooks, MyClassPathXmlApplicationContextCreator creator) {
        super(configs, registerShutdownHooks, creator);
        this.registerPostProcessor(new BeanFactoryPostProcessor(){

            public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
                beanFactory.registerScope("local", LOCAL);
            }
        });
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
    }

    public Object getBean(String id) {
        this.checkClosed(id);
        BeanContainer container = WebLocalScope.getNullableContainer();
        Object result = null;
        if (container != null) {
            result = container.getBean(id);
        }
        if (result == null && (result = this.globalBeans.get(id)) == null) {
            result = this.getBeanFactory().getBean(id);
            if (container == null || container.getBean(id) == null) {
                this.globalBeans.putIfAbsent(id, result);
            }
        }
        return result;
    }

    public Map getBeansOfType(Class type) {
        this.checkClosed(type.toString());
        return BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getBeanFactory(), (Class)type, (boolean)false, (boolean)true);
    }

    public Map getLocalBeansOfType(Class type) {
        this.checkClosed(type.toString());
        Map result = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.getBeanFactory(), (Class)type, (boolean)true, (boolean)true);
        Map exclude = this.getBeansOfType(type);
        for (Object key : exclude.keySet()) {
            result.remove(key);
        }
        return result;
    }

    public synchronized void close() {
        WebLocalScope.closeAll((ConfigurableBeanFactory)this.getBeanFactory());
        if (log.isInfoEnabled()) {
            log.info((Object)"Closing global web appplication's scope.");
        }
        super.close();
    }

    public void closeLocal() {
        if (!this.isClosed()) {
            if (log.isInfoEnabled()) {
                log.info((Object)"Closing local web appplication's scope.");
            }
            WebLocalScope.close((ConfigurableBeanFactory)this.getBeanFactory());
            if (WebLocalScope.isEmpty() && !DO_NOT_CLOSE_GLOBAL_ON_LAST_LOCAL_CLOSE) {
                this.close();
            }
        }
    }
}

