/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.textBuilder;

import java.util.Map;
import java.util.Stack;
import java.util.TreeMap;
import jetbrains.mps.gtext.runtime.TBaseBuilderContextListener;
import jetbrains.mps.gtext.runtime.TBuffer;
import jetbrains.mps.gtext.runtime.TContent;
import webr.framework.function.HtmlStringUtil;
import webr.framework.textBuilder.RecursiveBuffer;
import webr.framework.textBuilder.TextBuilder;
import webr.framework.textBuilder.WebrBuffer;
import webr.framework.textBuilder.WebrBuilderContext;
import webr.framework.textBuilder.WebrContent;

public class TBuilderContext
extends WebrBuilderContext {
    protected Map<String, WebrContent> contents;
    protected Stack<WebrContent> contentsStack;
    protected WebrBuffer buffer;
    protected static String TMP_PLACEHOLDER = "__TMP_PLACEHOLDER__";
    protected int tmp = 0;
    private long initTime = System.nanoTime();

    public TBuilderContext() {
        if (this.buffer == null) {
            this.initBuffer();
        }
    }

    public void render(TextBuilder textBuilder, Map<String, Object> rootMap) {
        textBuilder.generateText(rootMap, this);
    }

    public void initBuffer() {
        this.buffer = new RecursiveBuffer();
        WebrContent rootContent = new WebrContent(ROOT, this.buffer);
        this.getWebrContents().put(ROOT, rootContent);
        this.getWebrContentsStack().push(this.getWebrContents().get(ROOT));
    }

    public void initBuffer(TBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    public void flush() {
    }

    public void suspendRenderingUnless(boolean b) {
        throw new UnsupportedOperationException();
    }

    public void resumeRendering() {
        throw new UnsupportedOperationException();
    }

    protected int getCurrentPosition() {
        throw new UnsupportedOperationException();
    }

    public void addListener(TBaseBuilderContextListener tBaseBuilderContextListener) {
        throw new UnsupportedOperationException();
    }

    public void removeListener(TBaseBuilderContextListener tBaseBuilderContextListener) {
        throw new UnsupportedOperationException();
    }

    protected Map<String, TContent> getContents() {
        throw new UnsupportedOperationException();
    }

    protected Stack<TContent> getContentsStack() {
        throw new UnsupportedOperationException();
    }

    public TContent getCurrentContent() {
        throw new UnsupportedOperationException();
    }

    public void increaseIndent() {
        this.buffer.increaseIndent();
    }

    public void decreaseIndent() {
        this.buffer.decreaseIndent();
    }

    public void append(Object o) {
        if (o != null) {
            this.append(o.toString());
        }
    }

    public void append(int i) {
        this.append(Integer.toString(i));
    }

    public void append(String text) {
        this.buffer.append(text);
    }

    public void appendIndent() {
        this.buffer.appendIndent();
    }

    public void appendNewLine() {
        this.buffer.appendNewLine();
    }

    private WebrContent getWebrContent(String name) {
        WebrContent c = this.getWebrContents().get(name);
        if (c == null) {
            c = new WebrContent(name, new RecursiveBuffer());
            this.getWebrContents().put(name, c);
        }
        return c;
    }

    public void startContentBlock(String name) {
        WebrContent c = this.getWebrContent(name);
        this.getWebrContentsStack().push(c);
        this.buffer = c.getBuffer();
    }

    public void endContentBlock() {
        this.getWebrContentsStack().pop();
        this.buffer = this.getWebrContentsStack().peek().getBuffer();
    }

    public void addContentPlaceholder(String name) {
        WebrContent c = this.getWebrContent(name);
        try {
            ((RecursiveBuffer)this.buffer).append((RecursiveBuffer)c.getBuffer());
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Found cycle for content placeholder [" + name + "]"));
        }
    }

    public String getText() {
        return this.getWebrContent(ROOT).getBuffer().getString();
    }

    public CharSequence getCharSequence() {
        return this.getWebrContent(ROOT).getBuffer().getCharSequence();
    }

    @Override
    public void saveBuffer() {
        this.startContentBlock(TMP_PLACEHOLDER + this.tmp++);
    }

    @Override
    public void restoreBuffer(HtmlStringUtil.EscapeKind escapeKind) {
        String escapedText;
        WebrContent content = this.getWebrContentsStack().peek();
        String text = content.getBuffer().getString();
        switch (escapeKind) {
            case ESCAPE_HTML: {
                escapedText = HtmlStringUtil.html(text);
                break;
            }
            case ESCAPE_STRING_LITERAL: {
                escapedText = HtmlStringUtil.stringLiteral((Object)text);
                break;
            }
            case SINGLE_LINE: {
                escapedText = HtmlStringUtil.singleLine(text);
                break;
            }
            case DOUBLE_TO_SINGLE_QUOTES: {
                escapedText = HtmlStringUtil.doubleToSingleQuotes(text);
                break;
            }
            case SINGLE_LINE_AND_DOUBLE_TO_SINGLE_QUOTES: {
                escapedText = HtmlStringUtil.singleLineAnddoubleToSingleQuotes(text);
                break;
            }
            default: {
                escapedText = text;
            }
        }
        this.endContentBlock();
        this.getWebrContents().remove(content.getName());
        this.append(escapedText);
    }

    protected Map<String, WebrContent> getWebrContents() {
        if (this.contents == null) {
            this.contents = new TreeMap<String, WebrContent>();
        }
        return this.contents;
    }

    protected Stack<WebrContent> getWebrContentsStack() {
        if (this.contentsStack == null) {
            this.contentsStack = new Stack();
        }
        return this.contentsStack;
    }

    public WebrContent getCurrentWebrContent() {
        return this.getWebrContentsStack().peek();
    }

    public long getInitTime() {
        return this.initTime;
    }
}

