/*
 * Decompiled with CFR 0.152.
 */
package webr.framework.url;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.webr.runtime.builderContext.BuilderThreadContext;
import jetbrains.mps.webr.runtime.debug.DebugFileUtil;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.webr.runtime.uri.hash.HashFileNameUtil;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.files.PersistentFileImpl;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.springframework.util.Assert;
import webr.framework.controller.BaseApplication;
import webr.framework.textBuilder.TBuilderContext;
import webr.framework.url.DeferredUrl;
import webr.framework.url.HostToBaseUrlConfiguration;

public final class UrlUtil {
    private static final PathElementVerifier PATH_ELEMENT_VERIFIER = new PathElementVerifier();

    private UrlUtil() {
    }

    public static String getActionUrl(String controllerName, QueryParameter ... queryParameters) {
        return UrlUtil.getActionUrl(controllerName, null, false, null, queryParameters);
    }

    public static String getDispatchActionUrl(String controllerName, String idParameterName, QueryParameter ... queryParameters) {
        return UrlUtil.getActionUrl(controllerName, null, false, idParameterName, queryParameters);
    }

    public static String getActionUrl(String controllerName, String actionName) {
        return UrlUtil.getActionUrl(controllerName, actionName, false, new QueryParameter[0]);
    }

    public static String getXmlActionUrl(String controllerName, String actionName) {
        return UrlUtil.getActionUrl(controllerName, actionName, true, new QueryParameter[0]);
    }

    private static String getActionUrl(String controllerName, String actionName, boolean isXml, QueryParameter ... queryParameters) {
        return UrlUtil.getActionUrl(controllerName, actionName, isXml, true, queryParameters);
    }

    public static String getActionUrl(String controllerName, String actionName, boolean isXml, boolean skipWindowId, QueryParameter ... queryParameters) {
        return UrlUtil.getActionUrl(controllerName, actionName, isXml, null, queryParameters);
    }

    private static String getActionUrl(String controllerName, String actionName, boolean isXml, String idParameterName, QueryParameter ... queryParameters) {
        Url url = new Url();
        url.setIsLocal();
        url.addPathElements(StringUtils.uncapitalize((String)controllerName), actionName);
        if (isXml) {
            url.addPathElements("/xml".substring(1));
        }
        if (StringUtils.isNotEmpty((String)idParameterName)) {
            for (QueryParameter queryParameter : queryParameters) {
                String name = queryParameter.getName();
                if (name.equals(idParameterName)) {
                    url.addPathElements(queryParameter.getValue().toString());
                    continue;
                }
                url.addQueryParameters(queryParameter);
            }
        } else {
            url.addQueryParameters(queryParameters);
        }
        return url.toString();
    }

    public static String getRssTemplateUri(String rssTemplateName, QueryParameter ... queryParameters) {
        Url url = new Url();
        url.setUrlPrefix(UrlPrefix.BASE_URL);
        url.addPathElements("_rss", StringUtils.uncapitalize((String)rssTemplateName));
        url.addQueryParameters(queryParameters);
        return url.toString();
    }

    public static boolean verifyIdParameter(String value) {
        return PATH_ELEMENT_VERIFIER.verify(value);
    }

    public static String getHtmlTemplateUri(String htmlTemplateName, String idParameterName, QueryParameter ... queryParameters) {
        Url url = new Url();
        url.setIsLocal();
        url.setInRootServlet(true);
        url.addPathElements(StringUtils.uncapitalize((String)htmlTemplateName));
        if (StringUtils.isNotEmpty((String)idParameterName)) {
            for (QueryParameter queryParameter : queryParameters) {
                String name = queryParameter.getName();
                if (name.equals(idParameterName)) {
                    Object value = queryParameter.getValue();
                    if (value == null) continue;
                    String stringValue = value.toString();
                    if (PATH_ELEMENT_VERIFIER.verify(stringValue)) {
                        url.addPathElement(stringValue);
                        continue;
                    }
                    url.addQueryParameters(queryParameter);
                    continue;
                }
                url.addQueryParameters(queryParameter);
            }
        } else {
            url.addQueryParameters(queryParameters);
        }
        return url.toString();
    }

    public static Url getRestUri(Url restPathUrl, QueryParameter ... queryParameters) {
        restPathUrl.addQueryParameters(queryParameters);
        return restPathUrl;
    }

    public static Url getRestPathUri(String ... pathElements) {
        Url url = new Url();
        url.setUrlPrefix(UrlPrefix.BASE_URL);
        url.addPathElements("rest");
        url.addPathElements(pathElements);
        return url;
    }

    public static String getResourceUri(String resourcePath) {
        Url url = new Url();
        url.setIsLocal();
        url.addPathElements("_resources", HashFileNameUtil.getHashPath(resourcePath, resourcePath.endsWith(".css")));
        return url.toString();
    }

    public static DeferredUrl getDeferredResourceUri(final String resourcePath) {
        return new DeferredUrl(){

            public String getResourcePath() {
                return resourcePath;
            }

            public String getUrl() {
                return UrlUtil.getResourceUri(resourcePath);
            }

            public boolean isNeedPreprocessing() {
                return true;
            }

            public String toString() {
                return resourcePath;
            }
        };
    }

    public static String getClasspathResourceUri(String resourcePath) {
        return UrlUtil.getClasspathResourceUri(resourcePath, true);
    }

    public static String getClasspathResourceUri(String resourcePath, boolean hashedName) {
        Url url = new Url();
        url.setIsLocal();
        url.addPathElements("_classpath", hashedName ? DebugFileUtil.getDebugFile(resourcePath) : resourcePath);
        return url.toString();
    }

    public static DeferredUrl getDeferredClasspathResourceUri(final String resourcePath) {
        return new DeferredUrl(){

            public String getResourcePath() {
                return resourcePath;
            }

            public String getUrl() {
                return UrlUtil.getClasspathResourceUri(resourcePath);
            }

            public boolean isNeedPreprocessing() {
                return false;
            }

            public String toString() {
                return resourcePath;
            }
        };
    }

    public static String getPersistentFileUrl(Entity persistentFile, Integer width, Integer height, Boolean crop) {
        return UrlUtil.getPersistentFileUrl(persistentFile, width, height, crop, true);
    }

    public static String getPersistentFileUrl(Entity persistentFile, Integer width, Integer height, Boolean crop, boolean isLocal) {
        Url url = new Url();
        if (isLocal) {
            url.setIsLocal();
        } else {
            url.setUrlPrefix(UrlPrefix.BASE_URL);
        }
        url.addPathElements("_persistent");
        String fileName = ((PersistentFileImpl)DnqUtils.getPersistentClassInstance((Entity)persistentFile, (String)"PersistentFile")).getName(persistentFile);
        if (StringUtils.isNotEmpty((String)fileName)) {
            url.addPathElements(fileName);
        }
        url.addQueryParameter("file", BaseApplication.getCentralManager().toIdString(persistentFile));
        if (width != null) {
            url.addQueryParameter("w", width);
        }
        if (height != null) {
            url.addQueryParameter("h", height);
        }
        if (crop != null) {
            url.addQueryParameter("c", crop);
        }
        return url.toString();
    }

    public static String getRootURI() {
        String res = BaseApplication.getFullContextPath();
        return res.endsWith("/") ? res : res + "/";
    }

    public static String getHandlerUrl(TBuilderContext builderContext) {
        Url url = new Url();
        url.setIsLocal();
        url.addPathElements("_events");
        url.addQueryParameter("window_id", builderContext.getWindowId());
        return url.toString();
    }

    public static String getGlobalBaseUrl() {
        HostToBaseUrlConfiguration c = (HostToBaseUrlConfiguration)ServiceLocator.getBean((String)"hostToBaseUrlConfiguration");
        return c.getBaseUrl();
    }

    public static String tryPrependBaseUrl(String url) {
        try {
            new URL(url);
            return null;
        }
        catch (MalformedURLException e) {
            String base = UrlUtil.getGlobalBaseUrl();
            if (StringUtils.isEmpty((String)base)) {
                return null;
            }
            try {
                URL baseUrl = new URL(base);
                URL longUrl = new URL(baseUrl.getProtocol(), baseUrl.getHost(), baseUrl.getPort(), url);
                return longUrl.toString();
            }
            catch (MalformedURLException e2) {
                return null;
            }
        }
    }

    public static String decode(String source, String encoding) throws UnsupportedEncodingException {
        Assert.notNull((Object)source, (String)"'source' must not be null");
        Assert.hasLength((String)encoding, (String)"'encoding' must not be empty");
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            bos.write(ch);
        }
        return changed ? new String(bos.toByteArray(), encoding) : source;
    }

    public static void main(String[] args) {
    }

    private static class PathElementVerifier {
        private static final char SLASH = '/';
        private static final String DOT_SEGMENT = "/./";
        private static final String DOUBLE_DOT_SEGMENT = "/../";

        private PathElementVerifier() {
        }

        boolean verify(String pathElement) {
            String fakePathElememt = '/' + pathElement + '/';
            return !fakePathElememt.contains(DOT_SEGMENT) && !fakePathElememt.contains(DOUBLE_DOT_SEGMENT);
        }
    }

    public static enum UrlPrefix {
        BASE_URL,
        CONTEXT_PATH,
        NO_PREFIX;

    }

    public static final class Url {
        private UrlPrefix myUrlPrefix = UrlPrefix.NO_PREFIX;
        private boolean inRootServlet = false;
        private List<String> myPathElements = null;
        private List<QueryParameter> myQueryParameters = null;
        private static UrlReplacement[] URL_REPLACEMENTS = null;

        public UrlPrefix getUrlPrefix() {
            return this.myUrlPrefix;
        }

        public void setUrlPrefix(UrlPrefix urlPrefix) {
            this.myUrlPrefix = urlPrefix;
        }

        public void setIsLocal() {
            boolean hasHostPrefix = false;
            BuilderThreadContext builderThreadContext = BuilderThreadContext.getBuilderThreadContext();
            if (builderThreadContext != null) {
                hasHostPrefix = !builderThreadContext.hasLocalLinks();
            }
            this.myUrlPrefix = hasHostPrefix ? UrlPrefix.BASE_URL : UrlPrefix.CONTEXT_PATH;
        }

        public void setInRootServlet(boolean inRootServlet) {
            this.inRootServlet = inRootServlet;
        }

        public Url addPathElements(String ... pathElements) {
            for (String pathElement : pathElements) {
                String[] strings;
                if (pathElement == null) continue;
                if (this.myPathElements == null) {
                    this.myPathElements = new ArrayList<String>();
                }
                for (String s : strings = pathElement.split("/")) {
                    this.addPathElement(s);
                }
            }
            return this;
        }

        public Url addPathElementsEncoded(String ... pathElements) {
            for (String pathElement : pathElements) {
                if (pathElement == null) continue;
                if (this.myPathElements == null) {
                    this.myPathElements = new ArrayList<String>();
                }
                this.myPathElements.add(pathElement);
            }
            return this;
        }

        public Url addPathElement(String pathElement) {
            if (pathElement != null && pathElement.length() > 0) {
                this.myPathElements.add(pathElement);
            }
            return this;
        }

        public Url addQueryParameter(String name, Object value) {
            this.addQueryParameters(new QueryParameter(name, value));
            return this;
        }

        public Url addQueryParameters(QueryParameter ... queryParameters) {
            for (QueryParameter queryParameter : queryParameters) {
                if (queryParameter == null) continue;
                if (this.myQueryParameters == null) {
                    this.myQueryParameters = new ArrayList<QueryParameter>();
                }
                this.myQueryParameters.add(queryParameter);
            }
            return this;
        }

        public String toString() {
            return this.toString(true);
        }

        public String toString(boolean ignoreEmptyParams) {
            StringBuilder builder = new StringBuilder();
            HttpServletRequest request = BaseApplication.getRequest();
            switch (this.myUrlPrefix) {
                case CONTEXT_PATH: {
                    if (request == null) break;
                    builder.append(request.getContextPath());
                    break;
                }
                case BASE_URL: {
                    builder.append(UrlUtil.getGlobalBaseUrl());
                }
            }
            if (request != null && !this.inRootServlet) {
                builder.append(request.getServletPath());
            }
            try {
                if (this.myPathElements != null) {
                    for (String pathElement : this.myPathElements) {
                        builder.append("/");
                        builder.append(Url.encodeURIComponent(pathElement));
                    }
                }
                if (this.myQueryParameters != null) {
                    boolean firstParameter = true;
                    for (QueryParameter queryParameter : this.myQueryParameters) {
                        String stringValue = null;
                        if (queryParameter.getValue() != null) {
                            stringValue = queryParameter.getValue().toString();
                        }
                        if (stringValue == null || ignoreEmptyParams && stringValue.isEmpty()) continue;
                        if (firstParameter) {
                            if (this.myUrlPrefix != UrlPrefix.NO_PREFIX || this.myPathElements != null) {
                                builder.append('?');
                            }
                            firstParameter = false;
                        } else {
                            builder.append('&');
                        }
                        builder.append(queryParameter.getName());
                        builder.append('=');
                        if (queryParameter.isEncoded()) {
                            stringValue = URLEncoder.encode(stringValue, "UTF-8");
                        }
                        builder.append(stringValue);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
            return builder.toString();
        }

        private static UrlReplacement[] getUrlReplacements() {
            UrlReplacement[] result = URL_REPLACEMENTS;
            if (result == null) {
                ArrayList<UrlReplacement> replacementsList = new ArrayList<UrlReplacement>();
                replacementsList.add(new UrlReplacement("\\+", "%20"));
                replacementsList.add(new UrlReplacement("\\%21", "!"));
                replacementsList.add(new UrlReplacement("\\%27", "'"));
                replacementsList.add(new UrlReplacement("\\%28", "("));
                replacementsList.add(new UrlReplacement("\\%29", ")"));
                replacementsList.add(new UrlReplacement("\\%7E", "~"));
                replacementsList.add(new UrlReplacement(";", "%3B"));
                URL_REPLACEMENTS = replacementsList.toArray(new UrlReplacement[replacementsList.size()]);
                result = URL_REPLACEMENTS;
            }
            return result;
        }

        public static String encodeURIComponent(String s) {
            String result;
            try {
                result = URLEncoder.encode(s, "UTF-8");
                for (UrlReplacement ur : Url.getUrlReplacements()) {
                    result = ur.pattern.matcher(result).replaceAll(ur.replacement);
                }
            }
            catch (UnsupportedEncodingException e) {
                result = s;
            }
            return result;
        }

        public URI toURI() {
            try {
                return new URI(this.toString());
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private static class UrlReplacement {
            @NotNull
            private final Pattern pattern;
            @NotNull
            private final String replacement;

            public UrlReplacement(@NotNull String pattern, @NotNull String replacement) {
                this.pattern = Pattern.compile(pattern);
                this.replacement = replacement;
            }
        }
    }
}

