Webr.event.InputCollector = function (rootElement) {
  this.rootElement = rootElement || document.body;
};
Webr.event.InputCollector.prototype.collect = function (paramBuilder) {
  this.paramBuilder = paramBuilder;
  this.collectSelects();
  this.collectInputs();
  this.collectTextAreas();
};
Webr.event.InputCollector.prototype.collectSelects = function () {
  var selects = $(this.rootElement).find("select[name]:not([disabled])");
  for (var i = 0; i < selects.length; ++i) {
    var select = selects.get(i);
    var name = select.name;
    var selectedOptions = $(select).find("option:selected");
    for (var j = 0; j < selectedOptions.length; ++j) {
      var selectedOption = selectedOptions.get(j);
      var value;
      if ($(selectedOption).is("[value]")) {
        value = selectedOption.value;
      } else {
        value = selectedOption.text;
      }

      this.appendParameter(name, value);
    }

  }

};
Webr.event.InputCollector.prototype.collectInputs = function () {
  var collector = this;
  var inputs = $(this.rootElement).find("input[name]:not([disabled])").each(function () {
    var input = this;
    if (input.type === "radio") {
      //Get full component name with parameters
      var cn = cr.getComponentName(input);
      if (cn !== undefined) {
        collector.appendParameter(cn, input.checked);
      } else {
        collector.appendParameter(input.name, input.checked);
      }

    } else if (input.type === "checkbox") {
      collector.appendParameter(input.name, input.checked);
    } else if (input.type === "password") {
      if (input.value != "Password is defined") {
        collector.appendParameter(input.name, input.value);
      }

    } else if (input.type === "text" || input.type === "password" || input.type === "hidden") {
      var valueId = $(input).attr("valueId");
      if (valueId !== undefined) {
        collector.appendParameter(input.name, valueId);
      } else {
        collector.appendParameter(input.name, input.value);
      }

    }

  });
};
Webr.event.InputCollector.prototype.collectTextAreas = function () {
  var textAreas = $(this.rootElement).find("textarea[name]:not([disabled])");
  for (var i = 0; i < textAreas.length; ++i) {
    var textArea = textAreas.get(i);
    this.appendParameter(textArea.name, textArea.value);
  }

};
Webr.event.InputCollector.prototype.appendParameter = function (name, value) {
  if (name.length && name.length >= 1 && name.charAt(0) != "-") {
    this.paramBuilder.addParamPair(name, value);
  }

};
Webr.event.InputCollector.isIE = navigator.userAgent.toLowerCase().indexOf("msie") > -1;
