/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.userManagement.runtime;

import javax.servlet.http.HttpSession;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.userManagement.runtime.PrincipalManager;
import jetbrains.mps.webr.userManagement.runtime.RedirectAction;
import jetbrains.mps.webr.userManagement.runtime.SecurityNavigator;
import jetbrains.mps.webr.userManagement.runtime.TemplateRedirectAction;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.url.UrlUtil;

public class SecurityNavigatorImpl
implements SecurityNavigator {
    protected static Log log = LogFactory.getLog(SecurityNavigatorImpl.class);
    private String loginRedirectUrlParameterName = SecurityNavigatorImpl.class.getName() + "__LOGIN_REDIRECT_URL__";
    private String logoutRedirectUrlParameterName = SecurityNavigatorImpl.class.getName() + "__LOGOUT_REDIRECT_URL__";
    private RedirectAction redirectAction;
    private Runnable onLoginAction;

    @Override
    public ResponseAction getRedirectToLoginAction() {
        return this.redirectAction.doRedirect(this);
    }

    @Override
    public ResponseAction getLoginResponseAction(Object principal, boolean remember) {
        this.login(principal, remember);
        String url = this.getAfterLoginUrl();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response: redirect after login to " + url));
        }
        return ResponseFactory.getInstance().getRedirectResponse(url);
    }

    @Override
    public ResponseAction getLogoutResponseAction() {
        return ResponseFactory.getInstance().getRedirectResponse(this.getAfterLogoutUrl());
    }

    @Override
    public boolean doOnLoginAction() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Do on login");
        }
        if (this.onLoginAction != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Execute on login action");
            }
            try {
                this.onLoginAction.run();
            }
            catch (Throwable t) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"On login action failed, unsetting server principal", t);
                }
                ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetServerPrincipal();
                return false;
            }
        }
        return true;
    }

    @Override
    public void saveRequestedUrl(String url) {
        BaseApplication.setSessionField((String)this.loginRedirectUrlParameterName, (Object)url);
    }

    @Override
    public void saveRedirectUrl(String url) {
        BaseApplication.setSessionField((String)this.logoutRedirectUrlParameterName, (Object)url);
    }

    @Override
    public String getAfterLoginUrl() {
        String requestedUrl = (String)BaseApplication.getSessionField((String)this.loginRedirectUrlParameterName);
        if (requestedUrl != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found previously requested login URL");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Not found previously requested logout URL, go to default URL");
            }
            requestedUrl = UrlUtil.getRootURI();
        }
        return requestedUrl;
    }

    @Override
    public String getAfterLogoutUrl() {
        String requestedUrl = (String)BaseApplication.getSessionField((String)this.logoutRedirectUrlParameterName);
        if (requestedUrl != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Found previously requested logout URL");
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Not found previously requested logout URL, go to default URL");
            }
            requestedUrl = UrlUtil.getRootURI();
        }
        return requestedUrl;
    }

    @Override
    public void login(Object principal, boolean remember) {
        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setServerPrincipal(principal);
        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setClientPrincipal(remember ? principal : null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Logged in using explicit principal");
        }
        this.doOnLoginAction();
    }

    @Override
    @Deprecated
    public void logout(String url) {
        this.logout(url, null);
    }

    @Override
    public void logout(String url, String redirect) {
        HttpSession session = BaseApplication.getRequest().getSession();
        if (session != null) {
            session.invalidate();
        }
        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).unsetServerPrincipal();
        ((PrincipalManager)ServiceLocator.getBean((String)"principalManager")).setClientPrincipal(null);
        this.saveRequestedUrl(url);
        this.saveRedirectUrl(redirect);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Saved requested url: " + url));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Logged out");
        }
    }

    public void setOnLoginAction(Runnable onLoginAction) {
        this.onLoginAction = onLoginAction;
    }

    public void setRedirectAction(RedirectAction action) {
        this.redirectAction = action;
    }

    @Override
    public String getLoginTemplate() {
        String template = null;
        if (this.redirectAction instanceof TemplateRedirectAction) {
            template = ((TemplateRedirectAction)this.redirectAction).getLoginTemplate();
        }
        return template;
    }

    @Deprecated
    public void setRequestedUrlParameterName(String requestedUrlParameterName) {
        this.loginRedirectUrlParameterName = requestedUrlParameterName;
    }
}

