/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import jetbrains.mps.gtext.runtime.TBaseBuilderContext;
import webr.framework.function.HtmlStringUtil;

public final class LinkAppender {
    private static final String OPENING_TAG_START = "<a href=\"";
    private static final String OPENING_TAG_START_MOBILE = "<a rel=\"external\" href=\"";
    private static final String TAG_END = ">";
    private static final String QUOTE = "\"";
    private static final String MAIL_TO = "mailto:";
    private static final String CLOSING_TAG = "</a>";
    private static final String URL_PROTOCOL_END = "://";
    private TBaseBuilderContext builder = null;
    private boolean mobile = false;
    private String baseUrl = "";

    public void init(TBaseBuilderContext builder, boolean mobile, String baseUrl) {
        if (this.isInitialized()) {
            throw new IllegalStateException("LinkAppender already has been initilized");
        }
        this.builder = builder;
        this.mobile = mobile;
        this.baseUrl = LinkAppender.normalizeBaseUrl(baseUrl);
    }

    public boolean isInitialized() {
        return this.builder != null;
    }

    public void appendLink(String url, String text, boolean noJs) {
        LinkAppender.appendHrefForMobile(this.builder, this.mobile);
        this.builder.append(HtmlStringUtil.html((Object)url));
        this.builder.append(QUOTE);
        if (LinkAppender.isExternalLink(this.baseUrl, url)) {
            if (noJs) {
                this.builder.append(" target=\"_blank\" rel=\"noopener noreferrer\"");
            } else {
                this.builder.append(" onclick=\"");
                this.builder.append(LinkAppender.getNullOpenerOnClickExpression(url));
                this.builder.append(QUOTE);
            }
        }
        this.builder.append(TAG_END);
        this.builder.append(text);
        this.builder.append(CLOSING_TAG);
    }

    public void appendMailToLink(String url) {
        url = HtmlStringUtil.html((Object)url);
        LinkAppender.appendHrefForMobile(this.builder, this.mobile);
        this.builder.append(MAIL_TO);
        this.builder.append(url);
        this.builder.append(QUOTE);
        this.builder.append(TAG_END);
        this.builder.append(url);
        this.builder.append(CLOSING_TAG);
    }

    private static String normalizeBaseUrl(String inputBaseUrl) {
        int start = inputBaseUrl.indexOf(URL_PROTOCOL_END);
        if (start == -1) {
            return inputBaseUrl.toLowerCase();
        }
        return inputBaseUrl.substring(start + URL_PROTOCOL_END.length()).toLowerCase();
    }

    public static void appendHrefForMobile(TBaseBuilderContext builderContext, boolean mobile) {
        if (mobile) {
            builderContext.append(OPENING_TAG_START_MOBILE);
        } else {
            builderContext.append(OPENING_TAG_START);
        }
    }

    public static boolean isExternalLink(String baseUrl, String currentLinkUrl) {
        if (baseUrl != null && baseUrl.length() > 0 && currentLinkUrl != null && currentLinkUrl.length() > 0) {
            int startLinkBody = (currentLinkUrl = currentLinkUrl.toLowerCase()).indexOf(URL_PROTOCOL_END);
            if (startLinkBody == -1) {
                startLinkBody = 0 - URL_PROTOCOL_END.length();
            }
            return !currentLinkUrl.startsWith(baseUrl, startLinkBody + URL_PROTOCOL_END.length());
        }
        return false;
    }

    public static String getNullOpenerOnClickExpression(String url) {
        StringBuilder sb = new StringBuilder();
        sb.append("window.open(");
        try {
            url = URLEncoder.encode(url, "UTF-8");
            sb.append("window.decodeURIComponent('");
            sb.append(url);
            sb.append("')");
        }
        catch (UnsupportedEncodingException ex) {
            url = HtmlStringUtil.html((Object)url);
            sb.append("'");
            sb.append(url);
            sb.append("'");
        }
        sb.append(", '_blank').opener=null; return false;");
        return sb.toString();
    }
}

