/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.wiki.processor.runtime;

import java.io.IOException;
import java.io.StringReader;

public class TrailingCharStringReader
extends StringReader {
    private char chr;
    private boolean notReturned = true;

    public TrailingCharStringReader(String s, char trailingChar) {
        super(s);
        this.chr = trailingChar;
    }

    @Override
    public int read() throws IOException {
        int result = super.read();
        if (result == -1 && this.notReturned) {
            this.notReturned = false;
            return this.chr;
        }
        return result;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int result = super.read(cbuf, off, len);
        if (this.notReturned) {
            if (result == -1) {
                cbuf[off] = this.chr;
                this.notReturned = false;
                return 1;
            }
            int position = result + off;
            if (position < len) {
                int letter = super.read();
                if (letter == -1) {
                    cbuf[position] = this.chr;
                    this.notReturned = false;
                } else {
                    cbuf[position] = (char)letter;
                }
                ++result;
            }
        }
        return result;
    }
}

