/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.wiki.runtime.higlighter.java;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import webr.framework.function.HtmlStringUtil;

public abstract class LanguageHighlighter {
    public static final String KEYWORD = "keyword";
    public static final String STRING = "string";
    public static final String NUMBER = "number";
    public static final String COMMENT = "comment";
    private Map<Pattern, String> patterns = new LinkedHashMap<Pattern, String>();

    public abstract String getLanguage();

    public void highlight(StringBuilder result, String text) {
        int position = 0;
        while (position < text.length()) {
            int start = -1;
            int length = 0;
            Matcher bestMatcher = null;
            for (Pattern pattern : MapSequence.fromMap(this.patterns).keySet()) {
                Matcher matcher = pattern.matcher(text.substring(position));
                if (!matcher.find()) continue;
                int newStart = matcher.start();
                int newLength = matcher.group().length();
                if (start != -1 && newStart >= start && (newStart != start || newLength <= length)) continue;
                start = newStart;
                length = newLength;
                bestMatcher = matcher;
            }
            if (bestMatcher != null) {
                if (bestMatcher.start() > 0) {
                    result.append(HtmlStringUtil.html((Object)text.substring(position, position + bestMatcher.start())));
                }
                LanguageHighlighter.append(result, bestMatcher.group(), (String)MapSequence.fromMap(this.patterns).get((Object)bestMatcher.pattern()));
                position += bestMatcher.end();
                continue;
            }
            result.append(HtmlStringUtil.html((Object)text.substring(position)));
            position = text.length();
        }
    }

    public String process(String text, boolean removeMarkup) {
        if (!removeMarkup) {
            StringBuilder builder = new StringBuilder();
            builder.append("<pre class=\"wiki code " + this.getLanguage().toLowerCase() + "\">");
            this.highlight(builder, text);
            builder.append("</pre>");
            return builder.toString();
        }
        return HtmlStringUtil.html((Object)text);
    }

    public Pattern getStart() {
        return Pattern.compile("\\{code\\s+lang=" + this.getLanguage() + "\\}");
    }

    public Pattern getEnd() {
        return Pattern.compile("\\{code\\}");
    }

    public String getHelpText() {
        return "Highlighted " + this.getLanguage() + " code block";
    }

    public String getSample() {
        return "{code lang=" + this.getLanguage() + "}\n" + this.getSampleCode() + "{code}";
    }

    protected abstract String getSampleCode();

    public void add(Pattern pattern, String clazz) {
        MapSequence.fromMap(this.patterns).put((Object)pattern, (Object)clazz);
    }

    public void addKeyWord(String keyword) {
        this.add(Pattern.compile("\\b" + keyword + "\\b"), KEYWORD);
    }

    private static void append(StringBuilder builder, String text, String clazz) {
        builder.append("<span class=\"").append(clazz).append("\">").append(HtmlStringUtil.html((Object)text)).append("</span>");
    }

    private static void appendHex(StringBuilder builder, int i) {
        String res = Integer.toHexString(i);
        if (res.length() < 2) {
            builder.append("0");
        }
        builder.append(res);
    }
}

