/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.servlet;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jetbrains.ring.servlet.LookupResult;
import jetbrains.ring.servlet.util.IndexFileHolder;
import jetbrains.ring.servlet.util.ServletUtil;

public class StaticServlet
extends HttpServlet {
    public static final String WELCOME_PAGE_PARAM = "welcomePage";
    public static final String REPLACE_PATTERN_PARAM = "replacePattern";
    public static final String CONTEXT_TAG_PARAM = "contextTag";
    public static final String CACHE_CONTROL_PARAM = "cacheControl";
    public static final String CACHE_WELCOME_PAGE_PARAM = "cacheWelcome";
    public static final String WELCOME_CACHE_CONTROL_PARAM = "welcomeCacheControl";
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private String cacheControl = null;
    private IndexFileHolder indexIndexFileHolder;

    public void init(ServletConfig config) throws ServletException {
        URL welcomePage;
        super.init(config);
        String welcomePagePath = this.getInitParam(WELCOME_PAGE_PARAM, true);
        String replacePattern = this.getInitParam(REPLACE_PATTERN_PARAM, null);
        String contextTag = this.getInitParam(CONTEXT_TAG_PARAM, false, "context");
        Boolean cacheIndexPage = Boolean.valueOf(this.getInitParam(CACHE_WELCOME_PAGE_PARAM, false));
        this.cacheControl = this.getInitParam(CACHE_CONTROL_PARAM, false, "31536000");
        String welcomeCacheControl = this.getInitParam(WELCOME_CACHE_CONTROL_PARAM, false, "no-cache, no-store, no-transform, must-revalidate");
        if (welcomeCacheControl != null) {
            cacheIndexPage = true;
        }
        if ((welcomePage = this.getWelcomePageUrl(welcomePagePath)) == null) {
            throw new ServletException("Welcome page is not found in path: " + welcomePagePath);
        }
        this.indexIndexFileHolder = this.createIndexFileHolder(welcomePage, replacePattern, contextTag, cacheIndexPage.booleanValue() ? (welcomeCacheControl == null ? this.cacheControl : welcomeCacheControl) : null);
    }

    protected IndexFileHolder createIndexFileHolder(URL welcomePage, String replacePattern, String contextTag, String cacheControl) {
        return new IndexFileHolder(welcomePage, replacePattern, contextTag, cacheControl);
    }

    protected URL getWelcomePageUrl(String welcomePagePath) throws ServletException {
        URL welcomePage;
        try {
            welcomePage = this.getServletContext().getResource(welcomePagePath);
        }
        catch (MalformedURLException e) {
            throw new ServletException((Throwable)e);
        }
        return welcomePage;
    }

    private String getInitParam(String paramName, boolean required, String defaultValue) throws ServletException {
        String parameter = this.getServletConfig().getInitParameter(paramName);
        if (parameter == null) {
            if (required) {
                throw new ServletException("Servlet init parameter '" + paramName + "' is required");
            }
            return defaultValue;
        }
        return parameter;
    }

    private String getInitParam(String paramName, boolean required) throws ServletException {
        return this.getInitParam(paramName, required, null);
    }

    private String getInitParam(String paramName, String defaultValue) throws ServletException {
        return this.getInitParam(paramName, false, defaultValue);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.lookup(req).service(req, resp);
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.doGet(req, resp);
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        this.lookup(req).service(req, resp);
    }

    protected long getLastModified(HttpServletRequest req) {
        return this.lookup(req).getLastModified();
    }

    protected LookupResult lookup(HttpServletRequest req) {
        LookupResult r = (LookupResult)req.getAttribute("lookupResult");
        if (r == null) {
            r = this.lookupNoCache(req);
            req.setAttribute("lookupResult", (Object)r);
        }
        return r;
    }

    protected LookupResult lookupNoCache(HttpServletRequest req) {
        URL url;
        String path = ServletUtil.getPath(req);
        if (ServletUtil.isForbidden(path)) {
            return LookupResult.FORBIDDEN;
        }
        if (path.endsWith("/") || !this.isFile(path) || this.getFile(path) == null || !this.getFile(path).exists()) {
            try {
                return this.indexIndexFileHolder.getIndexResource(req);
            }
            catch (Exception e) {
                return LookupResult.INTERNAL_SERVER_ERROR;
            }
        }
        try {
            url = this.getServletContext().getResource(path);
            if (url == null) {
                return LookupResult.NOT_FOUND;
            }
        }
        catch (MalformedURLException e) {
            return LookupResult.BAD_REQUEST;
        }
        File file = this.getFile(path);
        if (file != null && file.isFile()) {
            return new LookupResult.FileResource(url, file, this.getMimeType(path), this.cacheControl);
        }
        return LookupResult.NOT_FOUND;
    }

    private boolean isFile(String path) {
        int dotIndex = path.lastIndexOf(".");
        if (dotIndex <= 0) {
            return false;
        }
        int p = path.lastIndexOf("/");
        return dotIndex > p;
    }

    private File getFile(String path) {
        String realpath = this.getServletContext().getRealPath(path);
        return realpath != null ? new File(realpath) : null;
    }

    protected String getMimeType(String path) {
        String mimeType = this.getServletContext().getMimeType(path);
        return mimeType == null ? DEFAULT_MIME_TYPE : mimeType;
    }
}

