/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.ring.servlet.util;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.AsyncContext;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;

public class AsyncStreamWriteListener
implements WriteListener {
    private final AsyncContext async;
    private final ServletOutputStream out;
    private final InputStream stream;

    public AsyncStreamWriteListener(AsyncContext async, ServletOutputStream out, InputStream stream) {
        this.async = async;
        this.out = out;
        this.stream = stream;
    }

    public void onWritePossible() throws IOException {
        byte[] buffer = new byte[4096];
        while (this.out.isReady()) {
            int length;
            try {
                length = this.stream.read(buffer);
            }
            catch (IOException ioe) {
                this.async.complete();
                this.close();
                return;
            }
            if (length < 0) {
                this.async.complete();
                this.close();
                return;
            }
            this.out.write(buffer, 0, length);
        }
    }

    public void onError(Throwable t) {
        this.async.complete();
        this.close();
    }

    private void close() {
        try {
            this.out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

