/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.files;

import eu.medsea.mimeutil.MimeUtil;
import eu.medsea.mimeutil.MimeUtil2;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MimeTypeConverter {
    private static Set<String> knownMimeCategories = new HashSet<String>();
    protected static Log log = LogFactory.getLog(MimeTypeConverter.class);

    public static String calculateMimeType(DiskFileItem diskFileItem) {
        String ct = diskFileItem.getContentType();
        if (ct == null || !knownMimeCategories.contains(ct.split("/")[0])) {
            block4: {
                try {
                    ct = MimeUtil.getMostSpecificMimeType((Collection)MimeUtil.getMimeTypes((InputStream)new BufferedInputStream(diskFileItem.getInputStream()))).toString();
                }
                catch (IOException ioe) {
                    if (!log.isWarnEnabled()) break block4;
                    log.warn((Object)"Can't sniff mime type", (Throwable)ioe);
                }
            }
            if (ct == null) {
                return MimeUtil2.UNKNOWN_MIME_TYPE.toString();
            }
        }
        return ct;
    }

    static {
        knownMimeCategories.add("text");
        knownMimeCategories.add("image");
        knownMimeCategories.add("audio");
        knownMimeCategories.add("video");
        knownMimeCategories.add("application");
        knownMimeCategories.add("chemical");
        knownMimeCategories.add("model");
        knownMimeCategories.add("font");
        knownMimeCategories.add("message");
        knownMimeCategories.add("mutipart");
    }
}

