/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.teamsys.dnq.runtime.files;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.PropertyConstraint;
import com.mortennobel.imagescaling.MultiStepRescaleOp;
import com.mortennobel.imagescaling.ThumpnailRescaleOp;
import eu.medsea.mimeutil.MimeUtil2;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.constraints.containsNone;
import jetbrains.exodus.util.LightByteArrayOutputStream;
import jetbrains.teamsys.dnq.runtime.files.FileMeta;
import jetbrains.teamsys.dnq.runtime.files.MimeTypeConverter;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PersistentFileImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "PersistentFile";
    protected static Log log = LogFactory.getLog(PersistentFileImpl.class);

    public PersistentFileImpl() {
        containsNone constraint = new containsNone();
        constraint.setChars("/\\");
        this.addPropertyConstraint("name", (PropertyConstraint)constraint);
    }

    public void run() {
        DnqUtils.setPersistentClassInstance(__ENTITY_TYPE__, this);
    }

    protected Entity _constructor(File file, String name, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (File)file);
        this.setName(name, entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"size", (Comparable)Long.valueOf(file.length()), Long.class);
        return entity;
    }

    protected Entity _constructor(InputStream content, String name, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)content);
        this.setName(name, entity);
        return entity;
    }

    protected Entity _constructor(InputStream content, String name, String charset, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)content);
        this.setName(name, entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"charset", (Comparable)((Object)charset), String.class);
        return entity;
    }

    protected Entity _constructor(InputStream content, String name, String charset, String mimeType, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)content);
        this.setName(name, entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"charset", (Comparable)((Object)charset), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"mimeType", (Comparable)((Object)(mimeType != null ? mimeType.toLowerCase() : mimeType)), String.class);
        return entity;
    }

    protected Entity _constructor(File content, String name, String mimeType, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (File)content);
        this.setName(name, entity);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"mimeType", (Comparable)((Object)(mimeType != null ? mimeType.toLowerCase() : mimeType)), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"size", (Comparable)Long.valueOf(content.length()), Long.class);
        return entity;
    }

    protected Entity _constructor(DiskFileItem diskFileItem, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        this.setContent(diskFileItem, entity);
        return entity;
    }

    protected Entity _constructor(Entity persistentFile, String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)PrimitiveAssociationSemantics.getBlob((Entity)persistentFile, (String)"content"));
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)persistentFile, (String)"name", String.class, null)), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"extension", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)persistentFile, (String)"extension", String.class, null)), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"size", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)persistentFile, (String)"size", Long.class, null)), Long.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"charset", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)persistentFile, (String)"charset", String.class, null)), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"mimeType", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)persistentFile, (String)"mimeType", String.class, null)), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"trusted", (Comparable)((Comparable)PrimitiveAssociationSemantics.get((Entity)entity, (String)"trusted", Boolean.class, null)), Boolean.class);
        return entity;
    }

    public String getName(Entity entity) {
        String result = FilenameUtils.getName((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)));
        return result == null || result.length() == 0 ? (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null) : result;
    }

    public String getBaseName(Entity entity) {
        return FilenameUtils.getBaseName((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)));
    }

    public void setBaseName(String baseName, Entity entity) {
        if (PrimitiveAssociationSemantics.get((Entity)entity, (String)"extension", String.class, null) == null) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"extension", (Comparable)((Object)FilenameUtils.getExtension((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)))), String.class);
        }
        if (PersistentFileImpl.isNotEmpty_2o2v9l_a0b0k((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"extension", String.class, null))) {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)(baseName + "." + (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"extension", String.class, null))), String.class);
        } else {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)baseName), String.class);
        }
    }

    public void setName(String name, Entity entity) {
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)FilenameUtils.getName((String)name)), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"extension", (Comparable)((Object)FilenameUtils.getExtension((String)((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"name", String.class, null)))), String.class);
    }

    public void setContent(DiskFileItem diskFileItem, Entity entity) {
        try {
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"mimeType", (Comparable)((Object)MimeTypeConverter.calculateMimeType(diskFileItem)), String.class);
            this.setName(diskFileItem.getName(), entity);
            PrimitiveAssociationSemantics.set((Entity)entity, (String)"size", (Comparable)Long.valueOf(diskFileItem.getSize()), Long.class);
            if (diskFileItem.isInMemory()) {
                PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)diskFileItem.getInputStream());
            } else {
                PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (File)diskFileItem.getStoreLocation());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getStringContent(Entity entity) {
        try {
            String charset_ = (String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"charset", String.class, null);
            InputStreamReader reader = charset_ == null ? new InputStreamReader(PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)"content")) : new InputStreamReader(PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)"content"), charset_);
            StringBuilder contentBuilder = new StringBuilder();
            int ch = reader.read();
            while (ch >= 0) {
                contentBuilder.append((char)ch);
                ch = reader.read();
            }
            return contentBuilder.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isImage(Entity entity) {
        return FileMeta.mimeTypeIsImage(this.getMimeType(entity));
    }

    public String getMimeType(Entity entity) {
        return PersistentFileImpl.isNotEmpty_2o2v9l_a0a0a51(PersistentFileImpl.trim_2o2v9l_a0a0a0p((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"mimeType", String.class, null))) ? ((String)PrimitiveAssociationSemantics.get((Entity)entity, (String)"mimeType", String.class, null)).toLowerCase() : MimeUtil2.UNKNOWN_MIME_TYPE.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getThumbnail(int maxWidth, int maxHeight, boolean cropped, FileMeta fileMeta, Entity entity) {
        block38: {
            InputStream content = PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)"content");
            if (content != null) {
                ByteArrayInputStream byteArrayInputStream;
                try {
                    BufferedImage image = ImageIO.read(content);
                    if (image == null) break block38;
                    int width = image.getWidth();
                    int height = image.getHeight();
                    if (width <= maxWidth && height <= maxHeight) {
                        InputStream inputStream = PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)"content");
                        return inputStream;
                    }
                    if (fileMeta == null) {
                        fileMeta = new FileMeta(entity);
                    }
                    fileMeta.usePngAsDefault();
                    BufferedImage thumbImage = this.scaleImage(image, maxWidth, maxHeight, cropped, width, height, entity);
                    LightByteArrayOutputStream out = new LightByteArrayOutputStream();
                    ImageIO.write((RenderedImage)thumbImage, fileMeta.getFormat(), (OutputStream)out);
                    byte[] byteArray = out.toByteArray();
                    fileMeta.setSize(byteArray.length);
                    byteArrayInputStream = new ByteArrayInputStream(byteArray);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Failed to create thumbnail for image. Will return original image. " + e.getClass().getName() + " " + e.getMessage()));
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"", (Throwable)e);
                    }
                    break block38;
                }
                catch (IllegalArgumentException e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Failed to create thumbnail for image. Will return original image. " + e.getClass().getName() + " " + e.getMessage()));
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"", (Throwable)e);
                    }
                    break block38;
                }
                catch (IIOException e) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Failed to create thumbnail for image. Will return original image. " + e.getClass().getName() + " " + e.getMessage()));
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"", (Throwable)e);
                    }
                    break block38;
                }
                catch (Throwable t) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Error while creating thumbnail. Will return original image.", t);
                    }
                    break block38;
                }
                finally {
                    try {
                        content.close();
                    }
                    catch (IOException e) {}
                }
                return byteArrayInputStream;
            }
        }
        return PrimitiveAssociationSemantics.getBlob((Entity)entity, (String)"content");
    }

    public void resize(int maxWidth, int maxHeight, Entity entity) {
        this.resample(maxWidth, maxHeight, false, entity);
    }

    public void resize(int maxWidth, int maxHeight, boolean crop, Entity entity) {
        this.resample(maxWidth, maxHeight, crop, entity);
    }

    public void resample(int width, int height, boolean crop, Entity entity) {
        FileMeta fileMeta = new FileMeta(entity);
        PrimitiveAssociationSemantics.setBlob((Entity)entity, (String)"content", (InputStream)this.getThumbnail(width, height, crop, fileMeta, entity));
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"size", (Comparable)Long.valueOf(fileMeta.getSize()), Long.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"mimeType", (Comparable)((Object)fileMeta.getMimeType()), String.class);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"name", (Comparable)((Object)fileMeta.getName()), String.class);
    }

    private BufferedImage scaleImage(BufferedImage image, int maxWidth, int maxHeight, boolean cropped, int width, int height, Entity entity) {
        double xRatio = (double)maxWidth / (double)width;
        double yRatio = (double)maxHeight / (double)height;
        double ratio = Math.min(1.0, cropped ? Math.max(xRatio, yRatio) : Math.min(xRatio, yRatio));
        boolean thumbnail = ratio < FileMeta.MAX_RESAMPLING_RATIO;
        int thumbWidth = (int)((double)width * ratio);
        int thumbHeight = (int)((double)height * ratio);
        int canvasWidth = thumbWidth > maxWidth ? maxWidth : thumbWidth;
        int canvasHeight = thumbHeight > maxHeight ? maxHeight : thumbHeight;
        ColorModel cm = image.getColorModel();
        WritableRaster rs = cm.createCompatibleWritableRaster(thumbWidth, thumbHeight);
        BufferedImage dstImage = new BufferedImage(cm, rs, cm.isAlphaPremultiplied(), null);
        Object op = thumbnail ? new ThumpnailRescaleOp(thumbWidth, thumbHeight) : new MultiStepRescaleOp(thumbWidth, thumbHeight);
        op.filter(image, dstImage);
        return cropped ? dstImage.getSubimage(0, 0, canvasWidth, canvasHeight) : dstImage;
    }

    public static Entity constructor(File file, String name) {
        return ((PersistentFileImpl)DnqUtils.getPersistentClassInstance(null, __ENTITY_TYPE__))._constructor(file, name, __ENTITY_TYPE__);
    }

    public static Entity constructor(InputStream content, String name) {
        return ((PersistentFileImpl)DnqUtils.getPersistentClassInstance(null, __ENTITY_TYPE__))._constructor(content, name, __ENTITY_TYPE__);
    }

    public static Entity constructor(InputStream content, String name, String charset) {
        return ((PersistentFileImpl)DnqUtils.getPersistentClassInstance(null, __ENTITY_TYPE__))._constructor(content, name, charset, __ENTITY_TYPE__);
    }

    public static Entity constructor(InputStream content, String name, String charset, String mimeType) {
        return ((PersistentFileImpl)DnqUtils.getPersistentClassInstance(null, __ENTITY_TYPE__))._constructor(content, name, charset, mimeType, __ENTITY_TYPE__);
    }

    public static Entity constructor(File content, String name, String mimeType) {
        return ((PersistentFileImpl)DnqUtils.getPersistentClassInstance(null, __ENTITY_TYPE__))._constructor(content, name, mimeType, __ENTITY_TYPE__);
    }

    public static Entity constructor(DiskFileItem diskFileItem) {
        return ((PersistentFileImpl)DnqUtils.getPersistentClassInstance(null, __ENTITY_TYPE__))._constructor(diskFileItem, __ENTITY_TYPE__);
    }

    protected static Entity constructor(Entity persistentFile) {
        return ((PersistentFileImpl)DnqUtils.getPersistentClassInstance(null, __ENTITY_TYPE__))._constructor(persistentFile, __ENTITY_TYPE__);
    }

    public static boolean isNotEmpty_2o2v9l_a0b0k(String str) {
        return str != null && str.length() > 0;
    }

    public static boolean isNotEmpty_2o2v9l_a0a0a51(String str) {
        return str != null && str.length() > 0;
    }

    public static String trim_2o2v9l_a0a0a0p(String str) {
        return str == null ? null : str.trim();
    }
}

