/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.coroutines.internal;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.DebugKt;
import kotlinx.coroutines.InternalCoroutinesApi;
import kotlinx.coroutines.internal.ThreadSafeHeapNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0018\b\u0017\u0018\u0000*\u0012\b\u0000\u0010\u0003*\u00020\u0001*\b\u0012\u0004\u0012\u00028\u00000\u00022\u00060\u0004j\u0002`\u0005B\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000H\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\t2\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\f\u0010\u000bJ.\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00028\u00002\u0014\u0010\u000f\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\t\u00a2\u0006\u0004\b\u0012\u0010\u0007J\u0011\u0010\u0013\u001a\u0004\u0018\u00018\u0000H\u0001\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\u0015\u0010\u0014J\u0017\u0010\u0017\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u0016H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0015\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001d\u001a\u00028\u00002\u0006\u0010\u001c\u001a\u00020\u001bH\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001eJ&\u0010 \u001a\u0004\u0018\u00018\u00002\u0012\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u000e0\rH\u0086\b\u00a2\u0006\u0004\b \u0010!J\u000f\u0010\"\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0004\b\"\u0010\u0014J\u0018\u0010$\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u001bH\u0082\u0010\u00a2\u0006\u0004\b$\u0010%J\u0018\u0010&\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u001bH\u0082\u0010\u00a2\u0006\u0004\b&\u0010%J\u001f\u0010(\u001a\u00020\t2\u0006\u0010#\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020\u001bH\u0002\u00a2\u0006\u0004\b(\u0010)R \u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00018\u0000\u0018\u00010\u00168\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0013\u0010,\u001a\u00020\u000e8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R$\u00102\u001a\u00020\u001b2\u0006\u0010.\u001a\u00020\u001b8F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u0010%\u00a8\u00063"}, d2={"Lkotlinx/coroutines/internal/ThreadSafeHeap;", "Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "", "T", "", "Lkotlinx/coroutines/internal/SynchronizedObject;", "<init>", "()V", "node", "", "addImpl", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;)V", "addLast", "Lkotlin/Function1;", "", "cond", "addLastIf", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;Lkotlin/jvm/functions/Function1;)Z", "clear", "firstImpl", "()Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "peek", "", "realloc", "()[Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "remove", "(Lkotlinx/coroutines/internal/ThreadSafeHeapNode;)Z", "", "index", "removeAtImpl", "(I)Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "predicate", "removeFirstIf", "(Lkotlin/jvm/functions/Function1;)Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "removeFirstOrNull", "i", "siftDownFrom", "(I)V", "siftUpFrom", "j", "swap", "(II)V", "a", "[Lkotlinx/coroutines/internal/ThreadSafeHeapNode;", "isEmpty", "()Z", "value", "getSize", "()I", "setSize", "size", "kotlinx-coroutines-core"})
@InternalCoroutinesApi
public class ThreadSafeHeap<T extends ThreadSafeHeapNode & Comparable<? super T>> {
    private T[] a;
    private volatile int _size = 0;

    public final int getSize() {
        return this._size;
    }

    private final void setSize(int value) {
        this._size = value;
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ThreadSafeHeap lock$iv = this;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            boolean bl3 = false;
            if (this.a != null) {
                ArraysKt.fill$default((Object[])this.a, null, (int)0, (int)0, (int)6, null);
            }
            this._size = 0;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T peek() {
        T t;
        ThreadSafeHeap lock$iv = this;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            boolean bl3 = false;
            t = this.firstImpl();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final T removeFirstOrNull() {
        T t;
        ThreadSafeHeap lock$iv = this;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            boolean bl3 = false;
            t = this.getSize() > 0 ? (T)this.removeAtImpl(0) : null;
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Nullable
    public final T removeFirstIf(@NotNull Function1<? super T, Boolean> predicate) {
        block5: {
            int $i$f$removeFirstIf = 0;
            Intrinsics.checkParameterIsNotNull(predicate, (String)"predicate");
            ThreadSafeHeap lock$iv = this;
            boolean $i$f$synchronized = false;
            boolean bl = false;
            boolean bl2 = false;
            // MONITORENTER : lock$iv
            boolean bl3 = false;
            if (this.firstImpl() != null) break block5;
            T t = null;
            InlineMarker.finallyStart((int)2);
            // MONITOREXIT : lock$iv
            InlineMarker.finallyEnd((int)2);
            return t;
        }
        try {
            T t;
            T first2 = t;
            T t2 = ((Boolean)predicate.invoke(first2)).booleanValue() ? (T)this.removeAtImpl(0) : null;
            return t2;
        }
        finally {
            InlineMarker.finallyStart((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addLast(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        ThreadSafeHeap lock$iv = this;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            boolean bl3 = false;
            this.addImpl(node);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean addLastIf(@NotNull T node, @NotNull Function1<? super T, Boolean> cond) {
        int $i$f$addLastIf = 0;
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        Intrinsics.checkParameterIsNotNull(cond, (String)"cond");
        ThreadSafeHeap lock$iv = this;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            try {
                boolean bl3;
                boolean bl4 = false;
                if (((Boolean)cond.invoke(this.firstImpl())).booleanValue()) {
                    this.addImpl(node);
                    bl3 = true;
                } else {
                    bl3 = false;
                }
                bl2 = bl3;
            }
            finally {
                InlineMarker.finallyStart((int)1);
                // MONITOREXIT @DISABLED, blocks:[1, 3] lbl21 : MonitorExitStatement: MONITOREXIT : lock$iv
                InlineMarker.finallyEnd((int)1);
            }
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        ThreadSafeHeap lock$iv = this;
        boolean $i$f$synchronized = false;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (lock$iv) {
            boolean bl3;
            boolean bl4 = false;
            if (node.getHeap() == null) {
                bl3 = false;
            } else {
                int index = node.getIndex();
                boolean bl5 = false;
                if (DebugKt.getASSERTIONS_ENABLED()) {
                    boolean bl6 = false;
                    if (!(index >= 0)) {
                        throw (Throwable)((Object)new AssertionError());
                    }
                }
                this.removeAtImpl(index);
                bl3 = true;
            }
            boolean bl7 = bl3;
            return bl7;
        }
    }

    @PublishedApi
    @Nullable
    public final T firstImpl() {
        return (T)(this.a != null ? this.a[0] : null);
    }

    /*
     * Unable to fully structure code
     */
    @PublishedApi
    @NotNull
    public final T removeAtImpl(int index) {
        block10: {
            var2_2 = false;
            if (DebugKt.getASSERTIONS_ENABLED()) {
                $i$a$-assert-ThreadSafeHeap$removeAtImpl$1 = 0;
                if (!(this.getSize() > 0)) {
                    throw (Throwable)new AssertionError();
                }
            }
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            a = this.a;
            v0 = this;
            $i$a$-assert-ThreadSafeHeap$removeAtImpl$1 = v0.getSize();
            v0.setSize($i$a$-assert-ThreadSafeHeap$removeAtImpl$1 + -1);
            if (index >= this.getSize()) break block10;
            this.swap(index, this.getSize());
            j = (index - 1) / 2;
            if (index <= 0) ** GOTO lbl-1000
            v1 = a[index];
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            v2 = (Comparable)v1;
            v3 = a[j];
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            if (v2.compareTo(v3) < 0) {
                this.swap(index, j);
                this.siftUpFrom(j);
            } else lbl-1000:
            // 2 sources

            {
                this.siftDownFrom(index);
            }
        }
        v4 = a[this.getSize()];
        if (v4 == null) {
            Intrinsics.throwNpe();
        }
        result = v4;
        var4_6 = false;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            $i$a$-assert-ThreadSafeHeap$removeAtImpl$2 = false;
            if (!(result.getHeap() == this)) {
                throw (Throwable)new AssertionError();
            }
        }
        result.setHeap(null);
        result.setIndex(-1);
        a[this.getSize()] = null;
        return result;
    }

    @PublishedApi
    public final void addImpl(@NotNull T node) {
        Intrinsics.checkParameterIsNotNull(node, (String)"node");
        boolean bl = false;
        if (DebugKt.getASSERTIONS_ENABLED()) {
            boolean bl2 = false;
            if (!(node.getHeap() == null)) {
                throw (Throwable)((Object)new AssertionError());
            }
        }
        node.setHeap(this);
        ThreadSafeHeapNode[] a = this.realloc();
        ThreadSafeHeap threadSafeHeap = this;
        int n = threadSafeHeap.getSize();
        threadSafeHeap.setSize(n + 1);
        int i = n;
        a[i] = node;
        node.setIndex(i);
        this.siftUpFrom(i);
    }

    private final void siftUpFrom(int i) {
        while (i > 0) {
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            T[] a = this.a;
            int j = (i - 1) / 2;
            T t = a[j];
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Comparable comparable = (Comparable)t;
            T t2 = a[i];
            if (t2 == null) {
                Intrinsics.throwNpe();
            }
            if (comparable.compareTo(t2) <= 0) {
                return;
            }
            this.swap(i, j);
            i = j;
        }
        return;
    }

    private final void siftDownFrom(int i) {
        int j;
        while ((j = 2 * i + 1) < this.getSize()) {
            if (this.a == null) {
                Intrinsics.throwNpe();
            }
            T[] a = this.a;
            if (j + 1 < this.getSize()) {
                T t = a[j + 1];
                if (t == null) {
                    Intrinsics.throwNpe();
                }
                Comparable comparable = (Comparable)t;
                T t2 = a[j];
                if (t2 == null) {
                    Intrinsics.throwNpe();
                }
                if (comparable.compareTo(t2) < 0) {
                    ++j;
                }
            }
            T t = a[i];
            if (t == null) {
                Intrinsics.throwNpe();
            }
            Comparable comparable = (Comparable)t;
            T t3 = a[j];
            if (t3 == null) {
                Intrinsics.throwNpe();
            }
            if (comparable.compareTo(t3) <= 0) {
                return;
            }
            this.swap(i, j);
            i = j;
        }
        return;
    }

    private final T[] realloc() {
        Object[] objectArray;
        T[] a = this.a;
        if (a == null) {
            ThreadSafeHeapNode[] threadSafeHeapNodeArray = new ThreadSafeHeapNode[4];
            boolean bl = false;
            boolean bl2 = false;
            ThreadSafeHeapNode[] it = threadSafeHeapNodeArray;
            boolean bl3 = false;
            this.a = it;
            objectArray = threadSafeHeapNodeArray;
        } else if (this.getSize() >= a.length) {
            T[] TArray = a;
            int n = this.getSize() * 2;
            boolean bl = false;
            T[] TArray2 = Arrays.copyOf(TArray, n);
            Intrinsics.checkExpressionValueIsNotNull(TArray2, (String)"java.util.Arrays.copyOf(this, newSize)");
            TArray = TArray2;
            n = 0;
            bl = false;
            ThreadSafeHeapNode[] it = (ThreadSafeHeapNode[])TArray;
            boolean bl4 = false;
            this.a = it;
            objectArray = (ThreadSafeHeapNode[])TArray;
        } else {
            objectArray = a;
        }
        return objectArray;
    }

    private final void swap(int i, int j) {
        if (this.a == null) {
            Intrinsics.throwNpe();
        }
        T[] a = this.a;
        T t = a[j];
        if (t == null) {
            Intrinsics.throwNpe();
        }
        T ni = t;
        T t2 = a[i];
        if (t2 == null) {
            Intrinsics.throwNpe();
        }
        T nj = t2;
        a[i] = ni;
        a[j] = nj;
        ni.setIndex(i);
        nj.setIndex(j);
    }
}

