/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.core;

import java.io.EOFException;
import java.nio.ByteBuffer;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.core.AbstractInput;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.ByteReadPacketBase;
import kotlinx.io.core.IoBuffer;
import kotlinx.io.internal.jvm.ErrorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0001\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004H\u0001\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0004H\u0001\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0004H\u0001\u001a\u0016\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0001\u001a\u001d\u0010\f\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u0004H\u0082\u0010\u001a\u0012\u0010\u000f\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n\u001a)\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0013H\u0086\b\u001a)\u0010\u0011\u001a\u00020\u0001*\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0013H\u0086\b\u001a)\u0010\u0011\u001a\u00020\u0001*\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0013H\u0087\b\u001a\u0012\u0010\u0014\u001a\u00020\u0004*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\n\u001a)\u0010\u0015\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00042\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0013H\u0086\b\u001a\u0014\u0010\u0016\u001a\u00020\u0001*\u00020\u00052\u0006\u0010\u0017\u001a\u00020\nH\u0007\u00a8\u0006\u0018"}, d2={"afterNioBufferUsed", "", "Lkotlinx/io/core/AbstractInput;", "read", "", "Lkotlinx/io/core/BytePacketBuilder;", "written", "Lkotlinx/io/core/ByteReadPacket;", "Lkotlinx/io/core/ByteReadPacketBase;", "nioBuffer", "Ljava/nio/ByteBuffer;", "size", "readAsMuchAsPossible", "bb", "copied", "readAvailable", "dst", "readDirect", "block", "Lkotlin/Function1;", "readFully", "writeDirect", "writeFully", "src", "kotlinx-io"})
public final class ByteBuffersKt {
    public static final int readAvailable(@NotNull ByteReadPacket $this$readAvailable, @NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readAvailable, (String)"$this$readAvailable");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        return ByteBuffersKt.readAsMuchAsPossible($this$readAvailable, dst, 0);
    }

    public static final int readFully(@NotNull ByteReadPacket $this$readFully, @NotNull ByteBuffer dst) {
        Intrinsics.checkParameterIsNotNull((Object)$this$readFully, (String)"$this$readFully");
        Intrinsics.checkParameterIsNotNull((Object)dst, (String)"dst");
        int rc = ByteBuffersKt.readAsMuchAsPossible($this$readFully, dst, 0);
        if (dst.hasRemaining()) {
            throw (Throwable)new EOFException("Not enough data in packet to fill buffer: " + dst.remaining() + " more bytes required");
        }
        return rc;
    }

    /*
     * WARNING - void declaration
     */
    private static final int readAsMuchAsPossible(@NotNull ByteReadPacket $this$readAsMuchAsPossible, ByteBuffer bb, int copied) {
        IoBuffer current;
        int destinationCapacity;
        while (true) {
            void this_$iv;
            if (!bb.hasRemaining()) {
                return copied;
            }
            ByteReadPacket byteReadPacket = $this$readAsMuchAsPossible;
            int minSize$iv = 1;
            boolean $i$f$prepareRead$kotlinx_io = false;
            if (this_$iv.prepareRead(minSize$iv, this_$iv.getHead()) == null) {
                return copied;
            }
            destinationCapacity = bb.remaining();
            int available = current.getReadRemaining();
            if (destinationCapacity < available) break;
            current.readFully(bb, available);
            $this$readAsMuchAsPossible.releaseHead$kotlinx_io(current);
            copied += available;
        }
        current.readFully(bb, destinationCapacity);
        $this$readAsMuchAsPossible.updateHeadRemaining(current.getReadRemaining());
        return copied + destinationCapacity;
    }

    public static final void writeDirect(@NotNull BytePacketBuilder $this$writeDirect, int size, @NotNull Function1<? super ByteBuffer, Unit> block) {
        int $i$f$writeDirect = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$writeDirect, (String)"$this$writeDirect");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ByteBuffer buffer = ByteBuffersKt.nioBuffer($this$writeDirect, size);
        int positionBefore = buffer.position();
        block.invoke((Object)buffer);
        int delta = buffer.position() - positionBefore;
        ByteBuffersKt.afterNioBufferUsed($this$writeDirect, delta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readDirect(@NotNull ByteReadPacket $this$readDirect, int size, @NotNull Function1<? super ByteBuffer, Unit> block) {
        int $i$f$readDirect = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$readDirect, (String)"$this$readDirect");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ByteBuffer byteBuffer = ByteBuffersKt.nioBuffer($this$readDirect, size);
        if (byteBuffer == null) {
            return;
        }
        ByteBuffer buffer = byteBuffer;
        int positionBefore = buffer.position();
        try {
            block.invoke((Object)buffer);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            int delta = buffer.position() - positionBefore;
            ByteBuffersKt.afterNioBufferUsed($this$readDirect, delta);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readDirect(@NotNull AbstractInput $this$readDirect, int size, @NotNull Function1<? super ByteBuffer, Unit> block) {
        int $i$f$readDirect = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$readDirect, (String)"$this$readDirect");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ByteBuffer byteBuffer = ByteBuffersKt.nioBuffer($this$readDirect, size);
        if (byteBuffer == null) {
            return;
        }
        ByteBuffer buffer = byteBuffer;
        int positionBefore = buffer.position();
        try {
            block.invoke((Object)buffer);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            int delta = buffer.position() - positionBefore;
            ByteBuffersKt.afterNioBufferUsed($this$readDirect, delta);
            InlineMarker.finallyEnd((int)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(message="Removed", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ void readDirect(@NotNull ByteReadPacketBase $this$readDirect, int size, @NotNull Function1<? super ByteBuffer, Unit> block) {
        int $i$f$readDirect = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$readDirect, (String)"$this$readDirect");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        ByteBuffer byteBuffer = ByteBuffersKt.nioBuffer($this$readDirect, size);
        if (byteBuffer == null) {
            return;
        }
        ByteBuffer buffer = byteBuffer;
        int positionBefore = buffer.position();
        try {
            block.invoke((Object)buffer);
        }
        finally {
            InlineMarker.finallyStart((int)1);
            int delta = buffer.position() - positionBefore;
            ByteBuffersKt.afterNioBufferUsed($this$readDirect, delta);
            InlineMarker.finallyEnd((int)1);
        }
    }

    @Deprecated(message="Should be resolved to member function instead", level=DeprecationLevel.HIDDEN)
    public static final /* synthetic */ void writeFully(@NotNull BytePacketBuilder $this$writeFully, @NotNull ByteBuffer src) {
        Intrinsics.checkParameterIsNotNull((Object)$this$writeFully, (String)"$this$writeFully");
        Intrinsics.checkParameterIsNotNull((Object)src, (String)"src");
        $this$writeFully.writeFully(src);
    }

    @PublishedApi
    @NotNull
    public static final ByteBuffer nioBuffer(@NotNull BytePacketBuilder $this$nioBuffer, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$nioBuffer, (String)"$this$nioBuffer");
        return $this$nioBuffer.prepareWriteHead((int)size).writeBuffer;
    }

    /*
     * WARNING - void declaration
     */
    @PublishedApi
    public static final void afterNioBufferUsed(@NotNull BytePacketBuilder $this$afterNioBufferUsed, int written) {
        void this_$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$afterNioBufferUsed, (String)"$this$afterNioBufferUsed");
        IoBuffer head = $this$afterNioBufferUsed.getHead();
        if (written < 0 || written > head.getWriteRemaining()) {
            Void void_ = ErrorsKt.wrongBufferPositionChangeError(written, $this$afterNioBufferUsed.getSize());
            throw null;
        }
        IoBuffer this_$iv = head;
        boolean $i$f$afterWrite = false;
        IoBuffer ioBuffer = this_$iv;
        ByteBuffer byteBuffer = this_$iv.readBuffer;
        boolean $i$f$getWritePosition = false;
        int n = this_$iv$iv.writeBuffer.position();
        byteBuffer.limit(n);
        $this$afterNioBufferUsed.addSize(written);
    }

    @PublishedApi
    @Nullable
    public static final ByteBuffer nioBuffer(@NotNull ByteReadPacket $this$nioBuffer, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$nioBuffer, (String)"$this$nioBuffer");
        ByteReadPacket this_$iv = $this$nioBuffer;
        boolean $i$f$prepareRead$kotlinx_io = false;
        IoBuffer ioBuffer = this_$iv.prepareRead(size, this_$iv.getHead());
        return ioBuffer != null ? ioBuffer.writeBuffer : null;
    }

    @PublishedApi
    @Nullable
    public static final ByteBuffer nioBuffer(@NotNull AbstractInput $this$nioBuffer, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$nioBuffer, (String)"$this$nioBuffer");
        AbstractInput this_$iv = $this$nioBuffer;
        boolean $i$f$prepareRead$kotlinx_io = false;
        IoBuffer ioBuffer = this_$iv.prepareRead(size, this_$iv.getHead());
        return ioBuffer != null ? ioBuffer.writeBuffer : null;
    }

    @PublishedApi
    @Nullable
    public static final ByteBuffer nioBuffer(@NotNull ByteReadPacketBase $this$nioBuffer, int size) {
        Intrinsics.checkParameterIsNotNull((Object)$this$nioBuffer, (String)"$this$nioBuffer");
        ByteReadPacketBase this_$iv = $this$nioBuffer;
        boolean $i$f$prepareRead$kotlinx_io = false;
        IoBuffer ioBuffer = this_$iv.prepareRead(size, this_$iv.getHead());
        return ioBuffer != null ? ioBuffer.writeBuffer : null;
    }

    @PublishedApi
    public static final void afterNioBufferUsed(@NotNull ByteReadPacket $this$afterNioBufferUsed, int read) {
        Intrinsics.checkParameterIsNotNull((Object)$this$afterNioBufferUsed, (String)"$this$afterNioBufferUsed");
        ByteBuffersKt.afterNioBufferUsed((ByteReadPacketBase)$this$afterNioBufferUsed, read);
    }

    @PublishedApi
    public static final void afterNioBufferUsed(@NotNull AbstractInput $this$afterNioBufferUsed, int read) {
        Intrinsics.checkParameterIsNotNull((Object)$this$afterNioBufferUsed, (String)"$this$afterNioBufferUsed");
        ByteBuffersKt.afterNioBufferUsed((ByteReadPacketBase)$this$afterNioBufferUsed, read);
    }

    @PublishedApi
    public static final void afterNioBufferUsed(@NotNull ByteReadPacketBase $this$afterNioBufferUsed, int read) {
        int headRemaining;
        Intrinsics.checkParameterIsNotNull((Object)$this$afterNioBufferUsed, (String)"$this$afterNioBufferUsed");
        int n = read;
        n = 0 <= n && (headRemaining = $this$afterNioBufferUsed.getHeadRemaining()) >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "read count shouldn't be negative: " + read;
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        $this$afterNioBufferUsed.setHeadRemaining(headRemaining - read);
    }
}

