/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.io.pool;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.io.pool.ObjectPool;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\u0005J\u0017\u0010\u000b\u001a\u00020\b2\u0006\u0010\n\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\u000b\u0010\fJ\u000f\u0010\r\u001a\u00028\u0000H$\u00a2\u0006\u0004\b\r\u0010\u0007J\u0015\u0010\u000e\u001a\u00020\b2\u0006\u0010\n\u001a\u00028\u0000\u00a2\u0006\u0004\b\u000e\u0010\fR\u0013\u0010\u0012\u001a\u00020\u000f8F@\u0006\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0018\u0010\n\u001a\u0004\u0018\u00018\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lkotlinx/io/pool/SingleInstancePool;", "", "T", "Lkotlinx/io/pool/ObjectPool;", "<init>", "()V", "borrow", "()Ljava/lang/Object;", "", "dispose", "instance", "disposeInstance", "(Ljava/lang/Object;)V", "produceInstance", "recycle", "", "getCapacity", "()I", "capacity", "Ljava/lang/Object;", "kotlinx-io"})
public abstract class SingleInstancePool<T>
implements ObjectPool<T> {
    private volatile int borrowed = 0;
    private static final AtomicIntegerFieldUpdater borrowed$FU = AtomicIntegerFieldUpdater.newUpdater(SingleInstancePool.class, "borrowed");
    private volatile int disposed = 0;
    private static final AtomicIntegerFieldUpdater disposed$FU = AtomicIntegerFieldUpdater.newUpdater(SingleInstancePool.class, "disposed");
    private volatile T instance;

    @NotNull
    protected abstract T produceInstance();

    protected abstract void disposeInstance(@NotNull T var1);

    @Override
    public final int getCapacity() {
        return 1;
    }

    @Override
    @NotNull
    public final T borrow() {
        int upd$iv;
        int cur$iv;
        SingleInstancePool $this$update$iv = this;
        boolean $i$f$update = false;
        do {
            int it = cur$iv = $this$update$iv.borrowed;
            boolean bl = false;
            if (it == 0) continue;
            throw (Throwable)new IllegalStateException("Instance is already consumed");
        } while (!borrowed$FU.compareAndSet($this$update$iv, cur$iv, upd$iv = 1));
        T instance = this.produceInstance();
        this.instance = instance;
        return instance;
    }

    @Override
    public final void recycle(@NotNull T instance) {
        Intrinsics.checkParameterIsNotNull(instance, (String)"instance");
        if (this.instance != instance) {
            if (this.instance == null && this.borrowed != 0) {
                throw (Throwable)new IllegalStateException("Already recycled or an irrelevant instance tried to be recycled");
            }
            throw (Throwable)new IllegalStateException("Unable to recycle irrelevant instance");
        }
        this.instance = null;
        if (!disposed$FU.compareAndSet(this, 0, 1)) {
            throw (Throwable)new IllegalStateException("An instance is already disposed");
        }
        this.disposeInstance(instance);
    }

    @Override
    public final void dispose() {
        if (disposed$FU.compareAndSet(this, 0, 1)) {
            T t = this.instance;
            if (t == null) {
                return;
            }
            T instance = t;
            this.instance = null;
            this.disposeInstance(instance);
        }
    }

    @Override
    public void close() {
        ObjectPool.DefaultImpls.close(this);
    }
}

