/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http.cio.websocket;

import io.ktor.http.cio.websocket.CloseReason;
import io.ktor.http.cio.websocket.Frame$Companion$WhenMappings;
import io.ktor.http.cio.websocket.FrameType;
import io.ktor.http.cio.websocket.NonDisposableHandle;
import io.ktor.util.NIOKt;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.io.charsets.CharsetJVMKt;
import kotlinx.io.core.BytePacketBuilder;
import kotlinx.io.core.ByteReadPacket;
import kotlinx.io.core.PacketJVMKt;
import kotlinx.io.core.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u0000 \u001c2\u00020\u0001:\u0006\u001a\u001b\u001c\u001d\u001e\u001fB)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u0017\u001a\u00020\u0000J\b\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u0082\u0001\u0005 !\"#$\u00a8\u0006%"}, d2={"Lio/ktor/http/cio/websocket/Frame;", "", "fin", "", "frameType", "Lio/ktor/http/cio/websocket/FrameType;", "data", "", "disposableHandle", "Lkotlinx/coroutines/DisposableHandle;", "(ZLio/ktor/http/cio/websocket/FrameType;[BLkotlinx/coroutines/DisposableHandle;)V", "buffer", "Ljava/nio/ByteBuffer;", "getBuffer", "()Ljava/nio/ByteBuffer;", "getData", "()[B", "getDisposableHandle", "()Lkotlinx/coroutines/DisposableHandle;", "getFin", "()Z", "getFrameType", "()Lio/ktor/http/cio/websocket/FrameType;", "copy", "toString", "", "Binary", "Close", "Companion", "Ping", "Pong", "Text", "Lio/ktor/http/cio/websocket/Frame$Binary;", "Lio/ktor/http/cio/websocket/Frame$Text;", "Lio/ktor/http/cio/websocket/Frame$Close;", "Lio/ktor/http/cio/websocket/Frame$Ping;", "Lio/ktor/http/cio/websocket/Frame$Pong;", "ktor-http-cio"})
public abstract class Frame {
    @NotNull
    private final ByteBuffer buffer;
    private final boolean fin;
    @NotNull
    private final FrameType frameType;
    @NotNull
    private final byte[] data;
    @NotNull
    private final DisposableHandle disposableHandle;
    private static final byte[] Empty;
    public static final Companion Companion;

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public String toString() {
        return "Frame " + (Object)((Object)this.frameType) + " (fin=" + this.fin + ", buffer len = " + this.data.length + ')';
    }

    @NotNull
    public final Frame copy() {
        byte[] byArray = this.data;
        FrameType frameType = this.frameType;
        boolean bl = this.fin;
        Companion companion = Companion;
        boolean bl2 = false;
        byte[] byArray2 = Arrays.copyOf(byArray, byArray.length);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"java.util.Arrays.copyOf(this, size)");
        byte[] byArray3 = byArray2;
        return companion.byType(bl, frameType, byArray3);
    }

    public final boolean getFin() {
        return this.fin;
    }

    @NotNull
    public final FrameType getFrameType() {
        return this.frameType;
    }

    @NotNull
    public final byte[] getData() {
        return this.data;
    }

    @NotNull
    public final DisposableHandle getDisposableHandle() {
        return this.disposableHandle;
    }

    private Frame(boolean fin, FrameType frameType, byte[] data, DisposableHandle disposableHandle) {
        this.fin = fin;
        this.frameType = frameType;
        this.data = data;
        this.disposableHandle = disposableHandle;
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byteBuffer, (String)"ByteBuffer.wrap(data)");
        this.buffer = byteBuffer;
    }

    /* synthetic */ Frame(boolean bl, FrameType frameType, byte[] byArray, DisposableHandle disposableHandle, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            disposableHandle = NonDisposableHandle.INSTANCE;
        }
        this(bl, frameType, byArray, disposableHandle);
    }

    static {
        Companion = new Companion(null);
        Empty = new byte[0];
    }

    public /* synthetic */ Frame(boolean fin, FrameType frameType, byte[] data, DisposableHandle disposableHandle, DefaultConstructorMarker $constructor_marker) {
        this(fin, frameType, data, disposableHandle);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lio/ktor/http/cio/websocket/Frame$Binary;", "Lio/ktor/http/cio/websocket/Frame;", "fin", "", "buffer", "Ljava/nio/ByteBuffer;", "(ZLjava/nio/ByteBuffer;)V", "packet", "Lkotlinx/io/core/ByteReadPacket;", "(ZLkotlinx/io/core/ByteReadPacket;)V", "data", "", "(Z[B)V", "ktor-http-cio"})
    public static final class Binary
    extends Frame {
        public Binary(boolean fin, @NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            super(fin, FrameType.BINARY, data, null, 8, null);
        }

        public Binary(boolean fin, @NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            this(fin, NIOKt.moveToByteArray((ByteBuffer)buffer));
        }

        public Binary(boolean fin, @NotNull ByteReadPacket packet) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            this(fin, StringsKt.readBytes$default((ByteReadPacket)packet, (int)0, (int)1, null));
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lio/ktor/http/cio/websocket/Frame$Text;", "Lio/ktor/http/cio/websocket/Frame;", "text", "", "(Ljava/lang/String;)V", "fin", "", "packet", "Lkotlinx/io/core/ByteReadPacket;", "(ZLkotlinx/io/core/ByteReadPacket;)V", "buffer", "Ljava/nio/ByteBuffer;", "(ZLjava/nio/ByteBuffer;)V", "data", "", "(Z[B)V", "ktor-http-cio"})
    public static final class Text
    extends Frame {
        public Text(boolean fin, @NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            super(fin, FrameType.TEXT, data, null, 8, null);
        }

        /*
         * WARNING - void declaration
         */
        public Text(@NotNull String text) {
            void $this$toByteArray$iv;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            String string = text;
            boolean bl = true;
            Text text2 = this;
            Charset charset$iv = Charsets.UTF_8;
            boolean $i$f$toByteArray = false;
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkExpressionValueIsNotNull((Object)charsetEncoder, (String)"charset.newEncoder()");
            byte[] byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)((CharSequence)$this$toByteArray$iv), (int)0, (int)$this$toByteArray$iv.length());
            text2(bl, byArray);
        }

        public Text(boolean fin, @NotNull ByteReadPacket packet) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            this(fin, StringsKt.readBytes$default((ByteReadPacket)packet, (int)0, (int)1, null));
        }

        public Text(boolean fin, @NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            this(fin, NIOKt.moveToByteArray((ByteBuffer)buffer));
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0007\b\u0016\u00a2\u0006\u0002\u0010\bB\u000f\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\r\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lio/ktor/http/cio/websocket/Frame$Close;", "Lio/ktor/http/cio/websocket/Frame;", "reason", "Lio/ktor/http/cio/websocket/CloseReason;", "(Lio/ktor/http/cio/websocket/CloseReason;)V", "packet", "Lkotlinx/io/core/ByteReadPacket;", "(Lkotlinx/io/core/ByteReadPacket;)V", "()V", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "data", "", "([B)V", "ktor-http-cio"})
    public static final class Close
    extends Frame {
        public Close(@NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            super(true, FrameType.CLOSE, data, null, 8, null);
        }

        public Close(@NotNull CloseReason reason) {
            ByteReadPacket byteReadPacket;
            Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
            Close close2 = this;
            int headerSizeHint$iv = 0;
            boolean $i$f$buildPacket = false;
            BytePacketBuilder builder$iv = PacketJVMKt.BytePacketBuilder((int)headerSizeHint$iv);
            try {
                BytePacketBuilder $this$buildPacket = builder$iv;
                boolean bl = false;
                $this$buildPacket.writeShort(reason.getCode());
                $this$buildPacket.writeStringUtf8(reason.getMessage());
                byteReadPacket = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket2 = byteReadPacket;
            close2(byteReadPacket2);
        }

        public Close(@NotNull ByteReadPacket packet) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            this(StringsKt.readBytes$default((ByteReadPacket)packet, (int)0, (int)1, null));
        }

        public Close() {
            this(Empty);
        }

        public Close(@NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            this(NIOKt.moveToByteArray((ByteBuffer)buffer));
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\r\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lio/ktor/http/cio/websocket/Frame$Ping;", "Lio/ktor/http/cio/websocket/Frame;", "packet", "Lkotlinx/io/core/ByteReadPacket;", "(Lkotlinx/io/core/ByteReadPacket;)V", "buffer", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;)V", "data", "", "([B)V", "ktor-http-cio"})
    public static final class Ping
    extends Frame {
        public Ping(@NotNull byte[] data) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            super(true, FrameType.PING, data, null, 8, null);
        }

        public Ping(@NotNull ByteReadPacket packet) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            this(StringsKt.readBytes$default((ByteReadPacket)packet, (int)0, (int)1, null));
        }

        public Ping(@NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            this(NIOKt.moveToByteArray((ByteBuffer)buffer));
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0019\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\nB\u0017\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lio/ktor/http/cio/websocket/Frame$Pong;", "Lio/ktor/http/cio/websocket/Frame;", "packet", "Lkotlinx/io/core/ByteReadPacket;", "(Lkotlinx/io/core/ByteReadPacket;)V", "buffer", "Ljava/nio/ByteBuffer;", "disposableHandle", "Lkotlinx/coroutines/DisposableHandle;", "(Ljava/nio/ByteBuffer;Lkotlinx/coroutines/DisposableHandle;)V", "(Ljava/nio/ByteBuffer;)V", "data", "", "([BLkotlinx/coroutines/DisposableHandle;)V", "ktor-http-cio"})
    public static final class Pong
    extends Frame {
        public Pong(@NotNull byte[] data, @NotNull DisposableHandle disposableHandle) {
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            Intrinsics.checkParameterIsNotNull((Object)disposableHandle, (String)"disposableHandle");
            super(true, FrameType.PONG, data, disposableHandle, null);
        }

        public /* synthetic */ Pong(byte[] byArray, DisposableHandle disposableHandle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                disposableHandle = NonDisposableHandle.INSTANCE;
            }
            this(byArray, disposableHandle);
        }

        public Pong(@NotNull ByteReadPacket packet) {
            Intrinsics.checkParameterIsNotNull((Object)packet, (String)"packet");
            this(StringsKt.readBytes$default((ByteReadPacket)packet, (int)0, (int)1, null), null, 2, null);
        }

        public Pong(@NotNull ByteBuffer buffer, @NotNull DisposableHandle disposableHandle) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            Intrinsics.checkParameterIsNotNull((Object)disposableHandle, (String)"disposableHandle");
            this(NIOKt.moveToByteArray((ByteBuffer)buffer), disposableHandle);
        }

        public /* synthetic */ Pong(ByteBuffer byteBuffer, DisposableHandle disposableHandle, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                disposableHandle = NonDisposableHandle.INSTANCE;
            }
            this(byteBuffer, disposableHandle);
        }

        public Pong(@NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            this(NIOKt.moveToByteArray((ByteBuffer)buffer), (DisposableHandle)NonDisposableHandle.INSTANCE);
        }
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lio/ktor/http/cio/websocket/Frame$Companion;", "", "()V", "Empty", "", "byType", "Lio/ktor/http/cio/websocket/Frame;", "fin", "", "frameType", "Lio/ktor/http/cio/websocket/FrameType;", "buffer", "Ljava/nio/ByteBuffer;", "data", "ktor-http-cio"})
    public static final class Companion {
        @NotNull
        public final Frame byType(boolean fin, @NotNull FrameType frameType, @NotNull byte[] data) {
            Frame frame;
            Intrinsics.checkParameterIsNotNull((Object)((Object)frameType), (String)"frameType");
            Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
            switch (Frame$Companion$WhenMappings.$EnumSwitchMapping$0[frameType.ordinal()]) {
                case 1: {
                    frame = new Binary(fin, data);
                    break;
                }
                case 2: {
                    frame = new Text(fin, data);
                    break;
                }
                case 3: {
                    frame = new Close(data);
                    break;
                }
                case 4: {
                    frame = new Ping(data);
                    break;
                }
                case 5: {
                    frame = new Pong(data, null, 2, null);
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return frame;
        }

        @NotNull
        public final Frame byType(boolean fin, @NotNull FrameType frameType, @NotNull ByteBuffer buffer) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)frameType), (String)"frameType");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            return this.byType(fin, frameType, NIOKt.moveToByteArray((ByteBuffer)buffer));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

