/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.sessions.CurrentSession;
import io.ktor.sessions.SessionProviderData;
import io.ktor.sessions.Sessions;
import io.ktor.sessions.TooLateSessionSetException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\r\u0010\u0012\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b\u0013J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0003J)\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005H\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u00d6\u0003J\u0014\u0010\u001a\u001a\u00020\u00062\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0016J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\u001a\u0010 \u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010!\u001a\u0004\u0018\u00010\u0019H\u0016J\t\u0010\"\u001a\u00020\u0006H\u00d6\u0001R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006#"}, d2={"Lio/ktor/sessions/SessionData;", "Lio/ktor/sessions/CurrentSession;", "sessions", "Lio/ktor/sessions/Sessions;", "providerData", "", "", "Lio/ktor/sessions/SessionProviderData;", "(Lio/ktor/sessions/Sessions;Ljava/util/Map;)V", "committed", "", "getProviderData", "()Ljava/util/Map;", "getSessions", "()Lio/ktor/sessions/Sessions;", "clear", "", "name", "commit", "commit$ktor_server_core", "component1", "component2", "copy", "equals", "other", "", "findName", "type", "Lkotlin/reflect/KClass;", "get", "hashCode", "", "set", "value", "toString", "ktor-server-core"})
final class SessionData
implements CurrentSession {
    private boolean committed;
    @NotNull
    private final Sessions sessions;
    @NotNull
    private final Map<String, SessionProviderData> providerData;

    public final void commit$ktor_server_core() {
        this.committed = true;
    }

    @Override
    @NotNull
    public String findName(@NotNull KClass<?> type) {
        Object v0;
        block2: {
            Intrinsics.checkParameterIsNotNull(type, (String)"type");
            Iterable $this$firstOrNull$iv = this.providerData.entrySet();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Map.Entry it = (Map.Entry)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(((SessionProviderData)it.getValue()).getProvider().getType(), type)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        if (entry == null) {
            throw (Throwable)new IllegalArgumentException("Session data for type `" + type + "` was not registered");
        }
        Map.Entry entry2 = entry;
        return ((SessionProviderData)entry2.getValue()).getProvider().getName();
    }

    @Override
    public void set(@NotNull String name, @Nullable Object value) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        if (this.committed) {
            throw (Throwable)new TooLateSessionSetException();
        }
        SessionProviderData sessionProviderData = this.providerData.get(name);
        if (sessionProviderData == null) {
            throw (Throwable)new IllegalStateException("Session data for `" + name + "` was not registered");
        }
        SessionProviderData providerData = sessionProviderData;
        if (value != null) {
            providerData.getProvider().getTracker().validate(value);
        }
        providerData.setValue(value);
    }

    @Override
    @Nullable
    public Object get(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        SessionProviderData sessionProviderData = this.providerData.get(name);
        if (sessionProviderData == null) {
            throw (Throwable)new IllegalStateException("Session data for `" + name + "` was not registered");
        }
        SessionProviderData providerData = sessionProviderData;
        return providerData.getValue();
    }

    @Override
    public void clear(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        SessionProviderData sessionProviderData = this.providerData.get(name);
        if (sessionProviderData == null) {
            throw (Throwable)new IllegalStateException("Session data for `" + name + "` was not registered");
        }
        SessionProviderData providerData = sessionProviderData;
        providerData.setValue(null);
    }

    @NotNull
    public final Sessions getSessions() {
        return this.sessions;
    }

    @NotNull
    public final Map<String, SessionProviderData> getProviderData() {
        return this.providerData;
    }

    public SessionData(@NotNull Sessions sessions, @NotNull Map<String, SessionProviderData> providerData) {
        Intrinsics.checkParameterIsNotNull((Object)sessions, (String)"sessions");
        Intrinsics.checkParameterIsNotNull(providerData, (String)"providerData");
        this.sessions = sessions;
        this.providerData = providerData;
    }

    @NotNull
    public final Sessions component1() {
        return this.sessions;
    }

    @NotNull
    public final Map<String, SessionProviderData> component2() {
        return this.providerData;
    }

    @NotNull
    public final SessionData copy(@NotNull Sessions sessions, @NotNull Map<String, SessionProviderData> providerData) {
        Intrinsics.checkParameterIsNotNull((Object)sessions, (String)"sessions");
        Intrinsics.checkParameterIsNotNull(providerData, (String)"providerData");
        return new SessionData(sessions, providerData);
    }

    public static /* synthetic */ SessionData copy$default(SessionData sessionData, Sessions sessions, Map map, int n, Object object) {
        if ((n & 1) != 0) {
            sessions = sessionData.sessions;
        }
        if ((n & 2) != 0) {
            map = sessionData.providerData;
        }
        return sessionData.copy(sessions, map);
    }

    @NotNull
    public String toString() {
        return "SessionData(sessions=" + this.sessions + ", providerData=" + this.providerData + ")";
    }

    public int hashCode() {
        Sessions sessions = this.sessions;
        Map<String, SessionProviderData> map = this.providerData;
        return (sessions != null ? sessions.hashCode() : 0) * 31 + (map != null ? ((Object)map).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SessionData)) break block3;
                SessionData sessionData = (SessionData)object;
                if (!Intrinsics.areEqual((Object)this.sessions, (Object)sessionData.sessions) || !Intrinsics.areEqual(this.providerData, sessionData.providerData)) break block3;
            }
            return true;
        }
        return false;
    }
}

