/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.sessions;

import io.ktor.application.ApplicationCall;
import io.ktor.http.Cookie;
import io.ktor.request.RequestCookies;
import io.ktor.sessions.CookieConfiguration;
import io.ktor.sessions.SessionTransport;
import io.ktor.sessions.SessionTransportTransformer;
import io.ktor.sessions.SessionTransportTransformerKt;
import io.ktor.util.date.DateJvmKt;
import io.ktor.util.date.DateKt;
import io.ktor.util.date.GMTDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lio/ktor/sessions/SessionTransportCookie;", "Lio/ktor/sessions/SessionTransport;", "name", "", "configuration", "Lio/ktor/sessions/CookieConfiguration;", "transformers", "", "Lio/ktor/sessions/SessionTransportTransformer;", "(Ljava/lang/String;Lio/ktor/sessions/CookieConfiguration;Ljava/util/List;)V", "getConfiguration", "()Lio/ktor/sessions/CookieConfiguration;", "getName", "()Ljava/lang/String;", "getTransformers", "()Ljava/util/List;", "clear", "", "call", "Lio/ktor/application/ApplicationCall;", "receive", "send", "value", "toString", "ktor-server-core"})
public final class SessionTransportCookie
implements SessionTransport {
    @NotNull
    private final String name;
    @NotNull
    private final CookieConfiguration configuration;
    @NotNull
    private final List<SessionTransportTransformer> transformers;

    @Override
    @Nullable
    public String receive(@NotNull ApplicationCall call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        return SessionTransportTransformerKt.transformRead(this.transformers, RequestCookies.get$default(call.getRequest().getCookies(), this.name, null, 2, null));
    }

    @Override
    public void send(@NotNull ApplicationCall call, @NotNull String value) {
        GMTDate gMTDate;
        Long maxAge;
        Long l;
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        GMTDate now = DateJvmKt.GMTDate$default(null, (int)1, null);
        TemporalAmount temporalAmount = this.configuration.getDuration();
        if (temporalAmount != null) {
            TemporalAmount temporalAmount2 = temporalAmount;
            boolean bl2 = false;
            bl = false;
            TemporalAmount it = temporalAmount2;
            boolean bl3 = false;
            l = RangesKt.coerceAtMost((long)it.get(ChronoUnit.SECONDS), (long)Integer.MAX_VALUE);
        } else {
            l = null;
        }
        Long l2 = maxAge = l;
        if (l2 != null) {
            Long l3 = l2;
            bl = false;
            boolean bl4 = false;
            long it = ((Number)l3).longValue();
            boolean bl5 = false;
            gMTDate = DateKt.plus((GMTDate)now, (long)TimeUnit.SECONDS.toMillis(maxAge));
        } else {
            gMTDate = null;
        }
        GMTDate expires = gMTDate;
        Long l4 = maxAge;
        Cookie cookie = new Cookie(this.name, SessionTransportTransformerKt.transformWrite(this.transformers, value), this.configuration.getEncoding(), l4 != null ? (int)l4.longValue() : 0, expires, this.configuration.getDomain(), this.configuration.getPath(), this.configuration.getSecure(), this.configuration.getHttpOnly(), this.configuration.getExtensions());
        call.getResponse().getCookies().append(cookie);
    }

    @Override
    public void clear(@NotNull ApplicationCall call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        call.getResponse().getCookies().appendExpired(this.name, this.configuration.getDomain(), this.configuration.getPath());
    }

    @NotNull
    public String toString() {
        return "SessionTransportCookie: " + this.name;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final CookieConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final List<SessionTransportTransformer> getTransformers() {
        return this.transformers;
    }

    public SessionTransportCookie(@NotNull String name, @NotNull CookieConfiguration configuration, @NotNull List<? extends SessionTransportTransformer> transformers) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(transformers, (String)"transformers");
        this.name = name;
        this.configuration = configuration;
        this.transformers = transformers;
    }
}

