/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsserverlookup;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.minidns.dnsserverlookup.AbstractDnsServerLookupMechanism;
import org.minidns.dnsserverlookup.DnsServerLookupMechanism;
import org.minidns.util.PlatformDetection;

public class AndroidUsingExec
extends AbstractDnsServerLookupMechanism {
    public static final DnsServerLookupMechanism INSTANCE = new AndroidUsingExec();
    public static final int PRIORITY = 999;
    private static final String PROP_DELIM = "]: [";

    private AndroidUsingExec() {
        super(AndroidUsingExec.class.getSimpleName(), 999);
    }

    @Override
    public List<String> getDnsServerAddresses() {
        try {
            Process process = Runtime.getRuntime().exec("getprop");
            InputStream inputStream = process.getInputStream();
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader(inputStream));
            Set<String> server = AndroidUsingExec.parseProps(lnr, true);
            if (server.size() > 0) {
                ArrayList<String> res = new ArrayList<String>(server.size());
                res.addAll(server);
                return res;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Exception in findDNSByExec", e);
        }
        return null;
    }

    @Override
    public boolean isAvailable() {
        return PlatformDetection.isAndroid();
    }

    protected static Set<String> parseProps(BufferedReader lnr, boolean logWarning) throws UnknownHostException, IOException {
        String line = null;
        HashSet<String> server = new HashSet<String>(6);
        while ((line = lnr.readLine()) != null) {
            InetAddress ip;
            int split = line.indexOf(PROP_DELIM);
            if (split == -1) continue;
            String property = line.substring(1, split);
            int valueStart = split + PROP_DELIM.length();
            int valueEnd = line.length() - 1;
            if (valueEnd < valueStart) {
                if (!logWarning) continue;
                LOGGER.warning("Malformed property detected: \"" + line + '\"');
                continue;
            }
            String value = line.substring(valueStart, valueEnd);
            if (value.isEmpty() || !property.endsWith(".dns") && !property.endsWith(".dns1") && !property.endsWith(".dns2") && !property.endsWith(".dns3") && !property.endsWith(".dns4") || (ip = InetAddress.getByName(value)) == null || (value = ip.getHostAddress()) == null || value.length() == 0) continue;
            server.add(value);
        }
        return server;
    }
}

