/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.minidns.dnsmessage.Question;
import org.minidns.dnsname.DnsName;
import org.minidns.dnssec.DigestCalculator;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.SignatureVerifier;
import org.minidns.dnssec.UnverifiedReason;
import org.minidns.dnssec.algorithms.AlgorithmMap;
import org.minidns.record.DNSKEY;
import org.minidns.record.Data;
import org.minidns.record.DelegatingDnssecRR;
import org.minidns.record.NSEC;
import org.minidns.record.NSEC3;
import org.minidns.record.RRSIG;
import org.minidns.record.Record;
import org.minidns.util.Base32;

class Verifier {
    private AlgorithmMap algorithmMap = AlgorithmMap.INSTANCE;

    Verifier() {
    }

    public UnverifiedReason verify(Record<DNSKEY> dnskeyRecord, DelegatingDnssecRR ds) {
        byte[] digest;
        DNSKEY dnskey = (DNSKEY)dnskeyRecord.payloadData;
        DigestCalculator digestCalculator = this.algorithmMap.getDsDigestCalculator(ds.digestType);
        if (digestCalculator == null) {
            return new UnverifiedReason.AlgorithmNotSupportedReason(ds.digestTypeByte, ds.getType(), dnskeyRecord);
        }
        byte[] dnskeyData = dnskey.toByteArray();
        byte[] dnskeyOwner = dnskeyRecord.name.getBytes();
        byte[] combined = new byte[dnskeyOwner.length + dnskeyData.length];
        System.arraycopy(dnskeyOwner, 0, combined, 0, dnskeyOwner.length);
        System.arraycopy(dnskeyData, 0, combined, dnskeyOwner.length, dnskeyData.length);
        try {
            digest = digestCalculator.digest(combined);
        }
        catch (Exception e) {
            return new UnverifiedReason.AlgorithmExceptionThrownReason(ds.digestType, "DS", dnskeyRecord, e);
        }
        if (!ds.digestEquals(digest)) {
            throw new DnssecValidationFailedException(dnskeyRecord, "SEP is not properly signed by parent DS!");
        }
        return null;
    }

    public UnverifiedReason verify(List<Record<? extends Data>> records, RRSIG rrsig, DNSKEY key) {
        SignatureVerifier signatureVerifier = this.algorithmMap.getSignatureVerifier(rrsig.algorithm);
        if (signatureVerifier == null) {
            return new UnverifiedReason.AlgorithmNotSupportedReason(rrsig.algorithmByte, rrsig.getType(), records.get(0));
        }
        byte[] combine = Verifier.combine(rrsig, records);
        if (signatureVerifier.verify(combine, rrsig.signature, key.getKey())) {
            return null;
        }
        throw new DnssecValidationFailedException(records, "Signature is invalid.");
    }

    public UnverifiedReason verifyNsec(Record<? extends Data> nsecRecord, Question q) {
        NSEC nsec = (NSEC)nsecRecord.payloadData;
        if (nsecRecord.name.equals((Object)q.name) && !Arrays.asList(nsec.types).contains(q.type)) {
            return null;
        }
        if (Verifier.nsecMatches(q.name, nsecRecord.name, nsec.next)) {
            return null;
        }
        return new UnverifiedReason.NSECDoesNotMatchReason(q, nsecRecord);
    }

    public UnverifiedReason verifyNsec3(CharSequence zone, Record<? extends Data> nsec3Record, Question q) {
        return this.verifyNsec3(DnsName.from((CharSequence)zone), nsec3Record, q);
    }

    public UnverifiedReason verifyNsec3(DnsName zone, Record<? extends Data> nsec3record, Question q) {
        NSEC3 nsec3 = (NSEC3)nsec3record.payloadData;
        DigestCalculator digestCalculator = this.algorithmMap.getNsecDigestCalculator(nsec3.hashAlgorithm);
        if (digestCalculator == null) {
            return new UnverifiedReason.AlgorithmNotSupportedReason(nsec3.hashAlgorithmByte, nsec3.getType(), nsec3record);
        }
        byte[] bytes = Verifier.nsec3hash(digestCalculator, nsec3.salt, q.name.getBytes(), nsec3.iterations);
        String s = Base32.encodeToString((byte[])bytes);
        DnsName computedNsec3Record = DnsName.from((String)(s + "." + zone));
        if (nsec3record.name.equals((Object)computedNsec3Record)) {
            for (Record.TYPE type : nsec3.types) {
                if (!type.equals((Object)q.type)) continue;
                return new UnverifiedReason.NSECDoesNotMatchReason(q, nsec3record);
            }
            return null;
        }
        if (Verifier.nsecMatches(s, nsec3record.name.getHostpart(), Base32.encodeToString((byte[])nsec3.nextHashed))) {
            return null;
        }
        return new UnverifiedReason.NSECDoesNotMatchReason(q, nsec3record);
    }

    static byte[] combine(RRSIG rrsig, List<Record<? extends Data>> records) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            rrsig.writePartialSignature(dos);
            DnsName sigName = records.get((int)0).name;
            if (!sigName.isRootLabel()) {
                if (sigName.getLabelCount() < rrsig.labels) {
                    throw new DnssecValidationFailedException("Invalid RRsig record");
                }
                if (sigName.getLabelCount() > rrsig.labels) {
                    sigName = DnsName.from((String)("*." + sigName.stripToLabels((int)rrsig.labels)));
                }
            }
            ArrayList<byte[]> recordBytes = new ArrayList<byte[]>();
            for (Record<? extends Data> record : records) {
                Record ref = new Record(sigName, record.type, record.clazzValue, rrsig.originalTtl, record.payloadData);
                recordBytes.add(ref.toByteArray());
            }
            final int offset = sigName.size() + 10;
            Collections.sort(recordBytes, new Comparator<byte[]>(){

                @Override
                public int compare(byte[] b1, byte[] b2) {
                    for (int i = offset; i < b1.length && i < b2.length; ++i) {
                        if (b1[i] == b2[i]) continue;
                        return (b1[i] & 0xFF) - (b2[i] & 0xFF);
                    }
                    return b1.length - b2.length;
                }
            });
            for (byte[] recordByte : recordBytes) {
                dos.write(recordByte);
            }
            dos.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return bos.toByteArray();
    }

    static boolean nsecMatches(String test, String lowerBound, String upperBound) {
        return Verifier.nsecMatches(DnsName.from((String)test), DnsName.from((String)lowerBound), DnsName.from((String)upperBound));
    }

    static boolean nsecMatches(DnsName test, DnsName lowerBound, DnsName upperBound) {
        int lowerParts = lowerBound.getLabelCount();
        int upperParts = upperBound.getLabelCount();
        int testParts = test.getLabelCount();
        if (testParts > lowerParts && !test.isChildOf(lowerBound) && test.stripToLabels(lowerParts).compareTo(lowerBound) < 0) {
            return false;
        }
        if (testParts <= lowerParts && test.compareTo(lowerBound.stripToLabels(testParts)) < 0) {
            return false;
        }
        if (testParts > upperParts && !test.isChildOf(upperBound) && test.stripToLabels(upperParts).compareTo(upperBound) > 0) {
            return false;
        }
        return testParts > upperParts || test.compareTo(upperBound.stripToLabels(testParts)) < 0;
    }

    static String stripToParts(String s, int parts) {
        if (s.isEmpty() && parts == 0) {
            return s;
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException();
        }
        String[] split = s.split("\\.");
        if (split.length == parts) {
            return s;
        }
        if (split.length < parts) {
            throw new IllegalArgumentException();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = split.length - parts; i < split.length; ++i) {
            sb.append(split[i]);
            if (i == split.length - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }

    static byte[] nsec3hash(DigestCalculator digestCalculator, byte[] salt, byte[] data, int iterations) {
        while (iterations-- >= 0) {
            byte[] combined = new byte[data.length + salt.length];
            System.arraycopy(data, 0, combined, 0, data.length);
            System.arraycopy(salt, 0, combined, data.length, salt.length);
            data = digestCalculator.digest(combined);
        }
        return data;
    }
}

