/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.SignatureVerifier;

public abstract class JavaSecSignatureVerifier
implements SignatureVerifier {
    private final KeyFactory keyFactory;
    private final String signatureAlgorithm;

    public JavaSecSignatureVerifier(String keyAlgorithm, String signatureAlgorithm) throws NoSuchAlgorithmException {
        this.keyFactory = KeyFactory.getInstance(keyAlgorithm);
        this.signatureAlgorithm = signatureAlgorithm;
        Signature.getInstance(signatureAlgorithm);
    }

    public KeyFactory getKeyFactory() {
        return this.keyFactory;
    }

    @Override
    public boolean verify(byte[] content, byte[] rrsigData, byte[] key) {
        try {
            PublicKey publicKey = this.getPublicKey(key);
            Signature signature = Signature.getInstance(this.signatureAlgorithm);
            signature.initVerify(publicKey);
            signature.update(content);
            return signature.verify(this.getSignature(rrsigData));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException();
        }
        catch (ArithmeticException | InvalidKeyException | SignatureException e) {
            throw new DnssecValidationFailedException("Validating signature failed", e);
        }
    }

    protected abstract byte[] getSignature(byte[] var1);

    protected abstract PublicKey getPublicKey(byte[] var1);
}

