/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnssec.algorithms;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import org.minidns.dnssec.DnssecValidationFailedException;
import org.minidns.dnssec.algorithms.JavaSecSignatureVerifier;

class RsaSignatureVerifier
extends JavaSecSignatureVerifier {
    public RsaSignatureVerifier(String algorithm) throws NoSuchAlgorithmException {
        super("RSA", algorithm);
    }

    @Override
    protected PublicKey getPublicKey(byte[] key) {
        DataInputStream dis = new DataInputStream(new ByteArrayInputStream(key));
        try {
            int exponentLength = dis.readUnsignedByte();
            int bytesRead = 1;
            if (exponentLength == 0) {
                bytesRead += 2;
                exponentLength = dis.readUnsignedShort();
            }
            byte[] exponentBytes = new byte[exponentLength];
            dis.readFully(exponentBytes);
            BigInteger exponent = new BigInteger(1, exponentBytes);
            byte[] modulusBytes = new byte[key.length - (bytesRead += exponentLength)];
            dis.readFully(modulusBytes);
            BigInteger modulus = new BigInteger(1, modulusBytes);
            return this.getKeyFactory().generatePublic(new RSAPublicKeySpec(modulus, exponent));
        }
        catch (IOException | InvalidKeySpecException e) {
            throw new DnssecValidationFailedException("Invalid public key!", e);
        }
    }

    @Override
    protected byte[] getSignature(byte[] rrsigData) {
        return rrsigData;
    }
}

