/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jetbrains.mps.internal.collections.runtime.ArrayUtils;
import jetbrains.mps.internal.collections.runtime.CollectionSequence;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.IMapping;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.impl.NullMapSequence;

public class MapSequence<U, V>
extends Sequence<IMapping<U, V>>
implements IMapSequence<U, V>,
Map<U, V>,
Serializable {
    private static final long serialVersionUID = 4362668497945620393L;
    private Map<U, V> map;

    protected MapSequence(Map<U, V> map) {
        this.map = map;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public Set<Map.Entry<U, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.map).equals(o);
    }

    @Override
    public V get(Object key) {
        return this.map.get(key);
    }

    @Override
    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<U> keySet() {
        return this.map.keySet();
    }

    @Override
    public V put(U key, V value) {
        return this.map.put(key, value);
    }

    @Override
    public void putAll(Map<? extends U, ? extends V> m) {
        this.map.putAll(m);
    }

    @Override
    public V remove(Object key) {
        return this.map.remove(key);
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public boolean contains(IMapping<U, V> t) {
        V v = this.map.get(t.key());
        return this.eq(v, t.value());
    }

    @Override
    public int count() {
        return this.map.size();
    }

    @Override
    public ISequence<IMapping<U, V>> distinct() {
        return this;
    }

    @Override
    public boolean isNotEmpty() {
        return !this.map.isEmpty();
    }

    @Override
    public Iterator<IMapping<U, V>> iterator() {
        return new MappingIterator();
    }

    @Override
    public IMapSequence<U, V> putAll(IMapSequence<? extends U, ? extends V> map) {
        this.getMap().putAll(map);
        return this;
    }

    @Override
    public V removeKey(U u) {
        return this.getMap().remove(u);
    }

    @Override
    public V putValue(U key, V value) {
        this.getMap().put(key, value);
        return value;
    }

    @Override
    public Map<U, V> toMap() {
        return this;
    }

    @Override
    public ISetSequence<IMapping<U, V>> mappingsSet() {
        return new MappingsSetSequence();
    }

    protected Map<U, V> getMap() {
        return this.map;
    }

    private boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }

    public static <P, Q> MapSequenceInitializer<P, Q> fromKeysArray(P ... keys) {
        HashMap map = new HashMap();
        return new MapSequenceInitializer(new MapSequence(map), keys);
    }

    public static <P, Q> MapSequenceInitializer<P, Q> fromMapAndKeysArray(Map<P, Q> map, P ... keys) {
        return new MapSequenceInitializer<P, Q>(new MapSequence<P, Q>(map), keys);
    }

    public static <P, Q> IMapSequence<P, Q> fromArray(IMapping<P, Q> ... mappings) {
        HashMap<P, Q> map = new HashMap<P, Q>();
        for (IMapping<P, Q> mp : mappings) {
            map.put(mp.key(), mp.value());
        }
        return new MapSequence(map);
    }

    public static <P, Q> IMapSequence<P, Q> fromIterable(Iterable<IMapping<P, Q>> iterable) {
        if (iterable instanceof IMapSequence) {
            return (IMapSequence)iterable;
        }
        HashMap<P, Q> map = new HashMap<P, Q>();
        for (IMapping<P, Q> mpng : iterable) {
            map.put(mpng.key(), mpng.value());
        }
        return new MapSequence(map);
    }

    public static <P, Q> IMapSequence<P, Q> fromMap(Map<P, Q> map) {
        if (map == null) {
            return NullMapSequence.instance();
        }
        if (map instanceof IMapSequence) {
            return (IMapSequence)map;
        }
        return new MapSequence<P, Q>(map);
    }

    private class MappingsSetSequence
    extends CollectionSequence
    implements ISetSequence,
    Set {
        private MappingsSetSequence() {
        }

        @Override
        public Object addElement(Object t) {
            throw new UnsupportedOperationException();
        }

        public ISetSequence addSequence(ISequence seq) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object removeElement(Object t) {
            if (MapSequence.this.map.entrySet().remove(((IMapping)t).toEntry())) {
                return t;
            }
            return null;
        }

        public ISetSequence removeSequence(ISequence seq) {
            if (seq == null) {
                return this;
            }
            for (Object t : seq.toIterable()) {
                MapSequence.this.map.entrySet().remove(((IMapping)t).toEntry());
            }
            return this;
        }

        @Override
        public boolean contains(Object t) {
            return MapSequence.this.map.entrySet().contains(((IMapping)t).toEntry());
        }

        @Override
        public Object[] toGenericArray() {
            Object[] result = new Object[this.size()];
            Iterator it = MapSequence.this.iterator();
            int i = 0;
            while (it.hasNext()) {
                result[i] = it.next();
                ++i;
            }
            return result;
        }

        @Override
        public Object[] toGenericArray(Class runtimeClass) {
            Object[] arr = (Object[])ArrayUtils.newArrayInstance(runtimeClass, this.size());
            return this.toArray(arr);
        }

        public Set toSet() {
            return this;
        }

        @Override
        public Iterator iterator() {
            return MapSequence.this.iterator();
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            MapSequence.this.map.entrySet().clear();
        }

        @Override
        public boolean containsAll(Collection c) {
            Iterator it = c.iterator();
            while (it.hasNext()) {
                if (MapSequence.this.map.entrySet().contains((IMapping)it.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean remove(Object o) {
            return MapSequence.this.map.entrySet().remove((IMapping)o);
        }

        @Override
        public boolean removeAll(Collection c) {
            boolean modified = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (!c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public boolean retainAll(Collection c) {
            boolean modified = false;
            Iterator it = this.iterator();
            while (it.hasNext()) {
                if (c.contains(it.next())) continue;
                it.remove();
                modified = true;
            }
            return modified;
        }

        @Override
        public int size() {
            return MapSequence.this.map.entrySet().size();
        }

        @Override
        public Object[] toArray() {
            return this.toGenericArray();
        }

        @Override
        public Object[] toArray(Object[] arr) {
            int size = this.size();
            if (arr.length < size) {
                arr = (Object[])ArrayUtils.newArrayInstance(arr.getClass().getComponentType(), size);
            }
            Iterator it = this.iterator();
            for (int i = 0; i < size; ++i) {
                arr[i] = it.next();
            }
            if (arr.length > size) {
                arr[size] = null;
            }
            return arr;
        }

        @Override
        public ISetSequence<Object> asUnmodifiable() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ISetSequence<Object> asSynchronized() {
            throw new UnsupportedOperationException();
        }

        protected Collection getCollection() {
            return MapSequence.this.map.entrySet();
        }
    }

    private static class EntryMapping<F, S>
    implements IMapping<F, S> {
        private final Map.Entry<F, S> entry;

        public EntryMapping(Map.Entry<F, S> entry) {
            this.entry = entry;
        }

        @Override
        public F key() {
            return this.entry.getKey();
        }

        @Override
        public S value() {
            return this.entry.getValue();
        }

        @Override
        public S value(S newValue) {
            return this.entry.setValue(newValue);
        }

        @Override
        public Map.Entry<F, S> toEntry() {
            return this.entry;
        }

        public int hashCode() {
            return ((Object)this.entry).hashCode();
        }

        public boolean equals(Object that) {
            if (that == null) {
                return false;
            }
            if (this.getClass() == that.getClass()) {
                return ((Object)this.entry).equals(((EntryMapping)that).entry);
            }
            if (that instanceof IMapping) {
                return this.eq(this.key(), ((IMapping)that).key()) && this.eq(this.value(), ((IMapping)that).value());
            }
            return false;
        }

        public String toString() {
            return this.key() + "=" + this.value();
        }

        private boolean eq(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }
    }

    private class MappingIterator
    implements Iterator<IMapping<U, V>> {
        private Iterator<Map.Entry<U, V>> entriesIt;

        public MappingIterator() {
            this.entriesIt = MapSequence.this.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entriesIt.hasNext();
        }

        @Override
        public IMapping<U, V> next() {
            return new EntryMapping(this.entriesIt.next());
        }

        @Override
        public void remove() {
            this.entriesIt.remove();
        }
    }

    public static class MapSequenceInitializer<P, Q> {
        private final P[] keys;
        private final IMapSequence<P, Q> mapSeq;

        protected MapSequenceInitializer(IMapSequence<P, Q> mapSeq, P ... keys) {
            this.mapSeq = mapSeq;
            this.keys = keys;
        }

        public IMapSequence<P, Q> withValues(Q ... values) {
            for (int i = 0; i < this.keys.length && i < values.length; ++i) {
                this.mapSeq.put(this.keys[i], values[i]);
            }
            return this.mapSeq;
        }
    }
}

