/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import jetbrains.mps.internal.collections.runtime.CollectionUtils;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISetSequence;
import jetbrains.mps.internal.collections.runtime.ISortedSetSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internal.collections.runtime.impl.NullSortedSetSequence;

public class SortedSetSequence<T>
extends SetSequence<T>
implements ISortedSetSequence<T>,
SortedSet<T>,
Serializable {
    private static final long serialVersionUID = -1048576263715753714L;

    protected SortedSetSequence(SortedSet<T> set) {
        super(set);
    }

    @Override
    public T first() {
        return (T)this.getSet().first();
    }

    @Override
    public T last() {
        return (T)this.getSet().last();
    }

    @Override
    public ISortedSetSequence<T> headSet(T toElement) {
        return SortedSetSequence.fromSet(this.getSet().headSet(toElement));
    }

    @Override
    public ISortedSetSequence<T> subSet(T fromElement, T toElement) {
        return SortedSetSequence.fromSet(this.getSet().subSet(fromElement, toElement));
    }

    @Override
    public ISortedSetSequence<T> tailSet(T fromElement) {
        return SortedSetSequence.fromSet(this.getSet().tailSet(fromElement));
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.getSet().comparator();
    }

    @Override
    public ISortedSetSequence<T> addSequence(ISequence<? extends T> seq) {
        return (ISortedSetSequence)super.addSequence((ISequence)seq);
    }

    @Override
    public ISortedSetSequence<T> removeSequence(ISequence<? extends T> seq) {
        return (ISortedSetSequence)super.removeSequence((ISequence)seq);
    }

    @Override
    public ISortedSetSequence<T> asUnmodifiable() {
        return new SortedSetSequence(Collections.unmodifiableSortedSet(this.getSet()));
    }

    @Override
    public ISortedSetSequence<T> asSynchronized() {
        return new SortedSetSequence<T>(CollectionUtils.synchronizedSortedSet(this.getSet()));
    }

    @Override
    protected SortedSet<T> getSet() {
        return (SortedSet)super.getSet();
    }

    public static <U> ISortedSetSequence<U> fromArray(U ... array) {
        if (array == null) {
            return NullSortedSetSequence.instance();
        }
        return SortedSetSequence.fromSetAndArray(new TreeSet(), array);
    }

    public static <U> ISortedSetSequence<U> fromSet(SortedSet<U> set) {
        if (set == null) {
            return NullSortedSetSequence.instance();
        }
        if (set instanceof ISortedSetSequence) {
            return (ISortedSetSequence)set;
        }
        return new SortedSetSequence<U>(set);
    }

    public static <U> ISortedSetSequence<U> fromSetAndArray(SortedSet<U> set, U ... array) {
        if (array == null) {
            array = Sequence.nullSingletonArray();
        }
        if (set == null && array == null) {
            return NullSortedSetSequence.instance();
        }
        if (set == null) {
            set = new TreeSet<U>();
        } else if (array == null) {
            if (set instanceof ISortedSetSequence) {
                return (ISortedSetSequence)set;
            }
            return new SortedSetSequence<U>(set);
        }
        List<U> input = Arrays.asList(array);
        set.addAll(input);
        if (set instanceof ISortedSetSequence) {
            return (ISortedSetSequence)set;
        }
        return new SortedSetSequence<U>(set);
    }

    public static <U> ISortedSetSequence<U> fromIterable(Iterable<U> it) {
        if (it == null) {
            return NullSortedSetSequence.instance();
        }
        if (it instanceof ISetSequence) {
            return (ISortedSetSequence)it;
        }
        TreeSet<U> set = new TreeSet<U>();
        if (it instanceof Collection) {
            set.addAll((Collection)it);
        } else {
            for (U u : it) {
                set.add(u);
            }
        }
        for (U u : it) {
            set.add(u);
        }
        return new SortedSetSequence(set);
    }

    public static <U> ISortedSetSequence<U> fromSetWithValues(SortedSet<U> set, Iterable<U> it) {
        SortedSet<U> tmp = set;
        if (set == null && it == null) {
            return NullSortedSetSequence.instance();
        }
        if (set == null) {
            tmp = new TreeSet<U>();
        } else if (it == null) {
            return SortedSetSequence.fromSet(set);
        }
        if (it instanceof Collection) {
            tmp.addAll((Collection)it);
        } else {
            for (U u : it) {
                tmp.add(u);
            }
        }
        if (tmp instanceof ISortedSetSequence) {
            return (ISortedSetSequence)tmp;
        }
        return new SortedSetSequence<U>(tmp);
    }
}

