/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.nio.netty.internal.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import java.net.SocketAddress;
import java.util.function.Consumer;
import java.util.function.Supplier;
import software.amazon.awssdk.annotations.SdkInternalApi;

@ChannelHandler.Sharable
@SdkInternalApi
public final class LoggingHandler
extends ChannelDuplexHandler {
    private final Consumer<Supplier<String>> logger;

    public LoggingHandler(Consumer<Supplier<String>> logger) {
        this.logger = logger;
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        this.log(() -> this.format(ctx, "CHANNEL_REGISTERED"));
        ctx.fireChannelRegistered();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.log(() -> this.format(ctx, "CHANNEL_UNREGISTERED"));
        ctx.fireChannelUnregistered();
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.log(() -> this.format(ctx, "CHANNEL_ACTIVE"));
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        this.log(() -> this.format(ctx, "CHANNEL_INACTIVE"));
        ctx.fireChannelInactive();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        this.log(() -> this.format(ctx, "(inbound) RECEIVED", msg));
        ctx.fireChannelRead(msg);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.log(() -> this.format(ctx, "(inbound) READ_COMPLETE"));
        ctx.fireChannelReadComplete();
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        this.log(() -> this.format(ctx, "USER_EVENT_TRIGGERED", evt));
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        this.log(() -> this.format(ctx, "CHANNEL_WRITABILITY_CHANGED"));
        ctx.fireChannelWritabilityChanged();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.log(() -> this.format(ctx, "EXCEPTION", cause));
        ctx.fireExceptionCaught(cause);
    }

    public void bind(ChannelHandlerContext ctx, SocketAddress localAddress, ChannelPromise promise) {
        this.log(() -> this.format(ctx, "BIND", localAddress));
        ctx.bind(localAddress, promise);
    }

    public void connect(ChannelHandlerContext ctx, SocketAddress remote, SocketAddress local, ChannelPromise promise) {
        this.log(() -> this.format(ctx, "CONNECT", remote, local));
        ctx.connect(remote, local, promise);
    }

    public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.log(() -> this.format(ctx, "DISCONNECT"));
        ctx.disconnect(promise);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.log(() -> this.format(ctx, "CLOSE"));
        ctx.close(promise);
    }

    public void deregister(ChannelHandlerContext ctx, ChannelPromise promise) {
        this.log(() -> this.format(ctx, "DEREGISTER"));
        ctx.deregister(promise);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        this.log(() -> this.format(ctx, "(outbound) WRITE", msg));
        ctx.write(msg, promise);
    }

    public void flush(ChannelHandlerContext ctx) {
        this.log(() -> this.format(ctx, "(outbound) FLUSH"));
        ctx.flush();
    }

    private String format(ChannelHandlerContext ctx, String event) {
        return ctx.channel() + " " + event;
    }

    private String format(ChannelHandlerContext ctx, String event, Object obj) {
        StringBuilder sb = new StringBuilder(ctx.channel().toString()).append(" ").append(event);
        if (obj instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)obj;
            sb.append(" ").append(buf.readableBytes()).append(" bytes\n").append(ByteBufUtil.prettyHexDump((ByteBuf)buf));
        } else if (obj instanceof ByteBufHolder) {
            ByteBufHolder holder = (ByteBufHolder)obj;
            sb.append(" ").append(holder.content().readableBytes()).append(" bytes\n").append(String.valueOf(obj)).append("\n").append(ByteBufUtil.prettyHexDump((ByteBuf)holder.content()));
        } else {
            sb.append("\n").append(String.valueOf(obj));
        }
        return sb.toString();
    }

    private String format(ChannelHandlerContext ctx, String event, Object first, Object second) {
        if (second == null) {
            return this.format(ctx, event, first);
        }
        return ctx.channel().toString() + " " + event + ":" + String.valueOf(first) + "," + String.valueOf(second);
    }

    private void log(Supplier<String> msg) {
        this.logger.accept(msg);
    }
}

