/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.regions.internal;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.regions.internal.model.CredentialScope;
import software.amazon.awssdk.regions.internal.model.Endpoint;
import software.amazon.awssdk.regions.internal.model.Partition;
import software.amazon.awssdk.regions.internal.model.Service;

@SdkInternalApi
public final class PartitionServiceMetadata
implements ServiceMetadata {
    private static final String SERVICE = "{service}";
    private static final String REGION = "{region}";
    private static final String DNS_SUFFIX = "{dnsSuffix}";
    private final String service;
    private final Map<String, Partition> servicePartitionData;

    public PartitionServiceMetadata(String service, Map<String, Partition> servicePartitionData) {
        this.service = service;
        this.servicePartitionData = servicePartitionData;
    }

    @Override
    public URI endpointFor(Region region) {
        RegionMetadata regionMetadata = RegionMetadata.of(region);
        Endpoint endpoint = this.computeEndpoint(this.service, region);
        return URI.create(endpoint.getHostname().replace(SERVICE, this.service).replace(REGION, region.id()).replace(DNS_SUFFIX, regionMetadata.domain()));
    }

    @Override
    public Region signingRegion(Region region) {
        CredentialScope credentialScope = this.computeEndpoint(this.service, region).getCredentialScope();
        return Region.of(credentialScope != null && credentialScope.getRegion() != null ? credentialScope.getRegion() : region.id());
    }

    private Endpoint computeEndpoint(String serviceName, Region region) {
        RegionMetadata regionMetadata = RegionMetadata.of(region);
        Partition partitionData = this.servicePartitionData.get(regionMetadata.partition());
        Service service = partitionData.getServices().get(serviceName);
        return partitionData.getDefaults().merge(service != null ? service.getDefaults() : null).merge(service != null && service.getEndpoints() != null ? service.getEndpoints().get(region.id()) : null);
    }

    @Override
    public List<Region> regions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        this.servicePartitionData.forEach((key, value) -> {
            Service serviceData = value.getServices().get(this.service);
            if (serviceData != null) {
                serviceData.getEndpoints().keySet().forEach(r -> regions.add(Region.of(r)));
            }
        });
        return regions;
    }
}

