/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.GetBucketInventoryConfigurationRequest;

public class GetBucketInventoryConfigurationRequestMarshaller
implements Marshaller<Request<GetBucketInventoryConfigurationRequest>, GetBucketInventoryConfigurationRequest> {
    public Request<GetBucketInventoryConfigurationRequest> marshall(GetBucketInventoryConfigurationRequest getBucketInventoryConfigurationRequest) {
        if (getBucketInventoryConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getBucketInventoryConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/{Bucket}?inventory";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", getBucketInventoryConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        if (getBucketInventoryConfigurationRequest.id() != null) {
            request.addParameter("id", StringConversion.fromString((String)getBucketInventoryConfigurationRequest.id()));
        }
        return request;
    }
}

