/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.services.s3.model.GetObjectAclRequest;

public class GetObjectAclRequestMarshaller
implements Marshaller<Request<GetObjectAclRequest>, GetObjectAclRequest> {
    public Request<GetObjectAclRequest> marshall(GetObjectAclRequest getObjectAclRequest) {
        if (getObjectAclRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)getObjectAclRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.GET);
        if (getObjectAclRequest.requestPayerAsString() != null) {
            request.addHeader("x-amz-request-payer", StringConversion.fromString((String)getObjectAclRequest.requestPayerAsString()));
        }
        String uriResourcePath = "/{Bucket}/{Key+}?acl";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", getObjectAclRequest.bucket());
        uriResourcePath = PathMarshaller.GREEDY.marshall(uriResourcePath, "Key", getObjectAclRequest.key());
        request.setResourcePath(uriResourcePath);
        if (getObjectAclRequest.versionId() != null) {
            request.addParameter("versionId", StringConversion.fromString((String)getObjectAclRequest.versionId()));
        }
        return request;
    }
}

