/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.transform;

import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.PathMarshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.UriResourcePathUtils;
import software.amazon.awssdk.core.util.xml.XmlWriter;
import software.amazon.awssdk.services.s3.model.AbortIncompleteMultipartUpload;
import software.amazon.awssdk.services.s3.model.BucketLifecycleConfiguration;
import software.amazon.awssdk.services.s3.model.LifecycleExpiration;
import software.amazon.awssdk.services.s3.model.LifecycleRule;
import software.amazon.awssdk.services.s3.model.LifecycleRuleAndOperator;
import software.amazon.awssdk.services.s3.model.LifecycleRuleFilter;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionExpiration;
import software.amazon.awssdk.services.s3.model.NoncurrentVersionTransition;
import software.amazon.awssdk.services.s3.model.PutBucketLifecycleConfigurationRequest;
import software.amazon.awssdk.services.s3.model.Tag;
import software.amazon.awssdk.services.s3.model.Transition;
import software.amazon.awssdk.utils.Md5Utils;
import software.amazon.awssdk.utils.StringInputStream;

public class PutBucketLifecycleConfigurationRequestMarshaller
implements Marshaller<Request<PutBucketLifecycleConfigurationRequest>, PutBucketLifecycleConfigurationRequest> {
    public Request<PutBucketLifecycleConfigurationRequest> marshall(PutBucketLifecycleConfigurationRequest putBucketLifecycleConfigurationRequest) {
        if (putBucketLifecycleConfigurationRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)putBucketLifecycleConfigurationRequest, "S3Client");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/{Bucket}?lifecycle";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParametersToRequest((Request)request, (String)uriResourcePath);
        uriResourcePath = PathMarshaller.NON_GREEDY.marshall(uriResourcePath, "Bucket", putBucketLifecycleConfigurationRequest.bucket());
        request.setResourcePath(uriResourcePath);
        try {
            StringWriter stringWriter = null;
            BucketLifecycleConfiguration lifecycleConfiguration = putBucketLifecycleConfigurationRequest.lifecycleConfiguration();
            if (lifecycleConfiguration != null) {
                stringWriter = new StringWriter();
                XmlWriter xmlWriter = new XmlWriter((Writer)stringWriter, "http://s3.amazonaws.com/doc/2006-03-01/");
                xmlWriter.startElement("LifecycleConfiguration");
                List<LifecycleRule> bucketLifecycleConfigurationRulesList = lifecycleConfiguration.rules();
                if (!bucketLifecycleConfigurationRulesList.isEmpty() || !(bucketLifecycleConfigurationRulesList instanceof SdkAutoConstructList)) {
                    for (LifecycleRule bucketLifecycleConfigurationRulesListValue : bucketLifecycleConfigurationRulesList) {
                        AbortIncompleteMultipartUpload abortIncompleteMultipartUpload;
                        NoncurrentVersionExpiration noncurrentVersionExpiration;
                        List<NoncurrentVersionTransition> lifecycleRuleNoncurrentVersionTransitionsList;
                        List<Transition> lifecycleRuleTransitionsList;
                        Object and;
                        LifecycleRuleFilter filter;
                        xmlWriter.startElement("Rule");
                        LifecycleExpiration expiration = bucketLifecycleConfigurationRulesListValue.expiration();
                        if (expiration != null) {
                            xmlWriter.startElement("Expiration");
                            if (expiration.date() != null) {
                                xmlWriter.startElement("Date").value((Object)expiration.date()).endElement();
                            }
                            if (expiration.days() != null) {
                                xmlWriter.startElement("Days").value((Object)expiration.days()).endElement();
                            }
                            if (expiration.expiredObjectDeleteMarker() != null) {
                                xmlWriter.startElement("ExpiredObjectDeleteMarker").value((Object)expiration.expiredObjectDeleteMarker()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (bucketLifecycleConfigurationRulesListValue.id() != null) {
                            xmlWriter.startElement("ID").value(bucketLifecycleConfigurationRulesListValue.id()).endElement();
                        }
                        if (bucketLifecycleConfigurationRulesListValue.prefix() != null) {
                            xmlWriter.startElement("Prefix").value(bucketLifecycleConfigurationRulesListValue.prefix()).endElement();
                        }
                        if ((filter = bucketLifecycleConfigurationRulesListValue.filter()) != null) {
                            Tag tag;
                            xmlWriter.startElement("Filter");
                            if (filter.prefix() != null) {
                                xmlWriter.startElement("Prefix").value(filter.prefix()).endElement();
                            }
                            if ((tag = filter.tag()) != null) {
                                xmlWriter.startElement("Tag");
                                if (tag.key() != null) {
                                    xmlWriter.startElement("Key").value(tag.key()).endElement();
                                }
                                if (tag.value() != null) {
                                    xmlWriter.startElement("Value").value(tag.value()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                            if ((and = filter.and()) != null) {
                                List<Tag> lifecycleRuleAndOperatorTagsList;
                                xmlWriter.startElement("And");
                                if (((LifecycleRuleAndOperator)and).prefix() != null) {
                                    xmlWriter.startElement("Prefix").value(((LifecycleRuleAndOperator)and).prefix()).endElement();
                                }
                                if (!(lifecycleRuleAndOperatorTagsList = ((LifecycleRuleAndOperator)and).tags()).isEmpty() || !(lifecycleRuleAndOperatorTagsList instanceof SdkAutoConstructList)) {
                                    for (Tag lifecycleRuleAndOperatorTagsListValue : lifecycleRuleAndOperatorTagsList) {
                                        xmlWriter.startElement("Tag");
                                        if (lifecycleRuleAndOperatorTagsListValue.key() != null) {
                                            xmlWriter.startElement("Key").value(lifecycleRuleAndOperatorTagsListValue.key()).endElement();
                                        }
                                        if (lifecycleRuleAndOperatorTagsListValue.value() != null) {
                                            xmlWriter.startElement("Value").value(lifecycleRuleAndOperatorTagsListValue.value()).endElement();
                                        }
                                        xmlWriter.endElement();
                                    }
                                }
                                xmlWriter.endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if (bucketLifecycleConfigurationRulesListValue.statusAsString() != null) {
                            xmlWriter.startElement("Status").value(bucketLifecycleConfigurationRulesListValue.statusAsString()).endElement();
                        }
                        if (!(lifecycleRuleTransitionsList = bucketLifecycleConfigurationRulesListValue.transitions()).isEmpty() || !(lifecycleRuleTransitionsList instanceof SdkAutoConstructList)) {
                            and = lifecycleRuleTransitionsList.iterator();
                            while (and.hasNext()) {
                                Transition lifecycleRuleTransitionsListValue = (Transition)and.next();
                                xmlWriter.startElement("Transition");
                                if (lifecycleRuleTransitionsListValue.date() != null) {
                                    xmlWriter.startElement("Date").value((Object)lifecycleRuleTransitionsListValue.date()).endElement();
                                }
                                if (lifecycleRuleTransitionsListValue.days() != null) {
                                    xmlWriter.startElement("Days").value((Object)lifecycleRuleTransitionsListValue.days()).endElement();
                                }
                                if (lifecycleRuleTransitionsListValue.storageClassAsString() != null) {
                                    xmlWriter.startElement("StorageClass").value(lifecycleRuleTransitionsListValue.storageClassAsString()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                        }
                        if (!(lifecycleRuleNoncurrentVersionTransitionsList = bucketLifecycleConfigurationRulesListValue.noncurrentVersionTransitions()).isEmpty() || !(lifecycleRuleNoncurrentVersionTransitionsList instanceof SdkAutoConstructList)) {
                            for (NoncurrentVersionTransition lifecycleRuleNoncurrentVersionTransitionsListValue : lifecycleRuleNoncurrentVersionTransitionsList) {
                                xmlWriter.startElement("NoncurrentVersionTransition");
                                if (lifecycleRuleNoncurrentVersionTransitionsListValue.noncurrentDays() != null) {
                                    xmlWriter.startElement("NoncurrentDays").value((Object)lifecycleRuleNoncurrentVersionTransitionsListValue.noncurrentDays()).endElement();
                                }
                                if (lifecycleRuleNoncurrentVersionTransitionsListValue.storageClassAsString() != null) {
                                    xmlWriter.startElement("StorageClass").value(lifecycleRuleNoncurrentVersionTransitionsListValue.storageClassAsString()).endElement();
                                }
                                xmlWriter.endElement();
                            }
                        }
                        if ((noncurrentVersionExpiration = bucketLifecycleConfigurationRulesListValue.noncurrentVersionExpiration()) != null) {
                            xmlWriter.startElement("NoncurrentVersionExpiration");
                            if (noncurrentVersionExpiration.noncurrentDays() != null) {
                                xmlWriter.startElement("NoncurrentDays").value((Object)noncurrentVersionExpiration.noncurrentDays()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        if ((abortIncompleteMultipartUpload = bucketLifecycleConfigurationRulesListValue.abortIncompleteMultipartUpload()) != null) {
                            xmlWriter.startElement("AbortIncompleteMultipartUpload");
                            if (abortIncompleteMultipartUpload.daysAfterInitiation() != null) {
                                xmlWriter.startElement("DaysAfterInitiation").value((Object)abortIncompleteMultipartUpload.daysAfterInitiation()).endElement();
                            }
                            xmlWriter.endElement();
                        }
                        xmlWriter.endElement();
                    }
                }
                xmlWriter.endElement();
            }
            if (stringWriter != null) {
                if (!request.getHeaders().containsKey("Content-MD5")) {
                    request.addHeader("Content-MD5", Md5Utils.md5AsBase64((byte[])stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8)));
                }
                request.setContent((InputStream)new StringInputStream(stringWriter.getBuffer().toString()));
                request.addHeader("Content-Length", Integer.toString(stringWriter.getBuffer().toString().getBytes(StandardCharsets.UTF_8).length));
            }
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", "application/xml");
            }
        }
        catch (Throwable t) {
            throw SdkClientException.builder().message("Unable to marshall request to XML: " + t.getMessage()).cause(t).build();
        }
        return request;
    }
}

