/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto.convert;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import jetbrains.exodus.crypto.convert.EncryptListener;
import jetbrains.exodus.crypto.convert.FileHeader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/crypto/convert/DirectoryEncryptListenerFactory;", "Lmu/KLogging;", "()V", "newListener", "Ljetbrains/exodus/crypto/convert/EncryptListener;", "folder", "Ljava/io/File;", "xodus-crypto"})
public final class DirectoryEncryptListenerFactory
extends KLogging {
    public static final DirectoryEncryptListenerFactory INSTANCE;

    @NotNull
    public final EncryptListener newListener(@NotNull File folder) {
        Intrinsics.checkParameterIsNotNull((Object)folder, (String)"folder");
        return new EncryptListener(folder){
            @NotNull
            private File currentFolder;
            @Nullable
            private OutputStream fileOut;
            final /* synthetic */ File $folder;

            @NotNull
            public final File getCurrentFolder() {
                return this.currentFolder;
            }

            public final void setCurrentFolder(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull((Object)file, (String)"<set-?>");
                this.currentFolder = file;
            }

            @Nullable
            public final OutputStream getFileOut() {
                return this.fileOut;
            }

            public final void setFileOut(@Nullable OutputStream outputStream) {
                this.fileOut = outputStream;
            }

            public void onFile(@NotNull FileHeader header) {
                Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                CharSequence charSequence = header.getPath();
                boolean bl = false;
                if (charSequence.length() > 0) {
                    this.currentFolder = new File(this.$folder, header.getPath());
                    this.currentFolder.mkdirs();
                } else {
                    this.currentFolder = this.$folder;
                }
                this.fileOut = new FileOutputStream(new File(this.currentFolder, header.getName()));
            }

            public void onFileEnd(@NotNull FileHeader header) {
                Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                OutputStream outputStream = this.fileOut;
                if (outputStream == null) {
                    throw (Throwable)new IllegalStateException("No file in progress");
                }
                outputStream.close();
            }

            public void onData(@NotNull FileHeader header, int size, @NotNull byte[] data) {
                Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
                Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
                OutputStream outputStream = this.fileOut;
                if (outputStream == null) {
                    throw (Throwable)new IllegalStateException("No file in progress");
                }
                outputStream.write(data, 0, size);
            }
            {
                this.$folder = $captured_local_variable$0;
                this.currentFolder = $captured_local_variable$0;
            }
        };
    }

    private DirectoryEncryptListenerFactory() {
    }

    static {
        DirectoryEncryptListenerFactory directoryEncryptListenerFactory;
        INSTANCE = directoryEncryptListenerFactory = new DirectoryEncryptListenerFactory();
    }
}

