/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto.convert;

import java.io.Closeable;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import jetbrains.exodus.crypto.EnvKryptKt;
import jetbrains.exodus.crypto.StreamCipher;
import jetbrains.exodus.crypto.StreamCipherProvider;
import jetbrains.exodus.crypto.convert.EncryptListener;
import jetbrains.exodus.crypto.convert.EncryptMessage;
import jetbrains.exodus.crypto.convert.EndChunk;
import jetbrains.exodus.crypto.convert.FileChunk;
import jetbrains.exodus.crypto.convert.FileHeader;
import jetbrains.exodus.crypto.convert.ScytaleEngine;
import jetbrains.exodus.util.ByteArraySpinAllocator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006*\u0001$\u0018\u0000 -2\u00020\u0001:\u0001-BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010&\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020(J\b\u0010)\u001a\u00020(H\u0016J\u000e\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020\u001fJ\u0006\u0010,\u001a\u00020(R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010%\u00a8\u0006."}, d2={"Ljetbrains/exodus/crypto/convert/ScytaleEngine;", "Ljava/io/Closeable;", "listener", "Ljetbrains/exodus/crypto/convert/EncryptListener;", "cipherProvider", "Ljetbrains/exodus/crypto/StreamCipherProvider;", "key", "", "basicIV", "", "blockAlignment", "", "bufferSize", "inputQueueSize", "outputQueueSize", "(Ljetbrains/exodus/crypto/convert/EncryptListener;Ljetbrains/exodus/crypto/StreamCipherProvider;[BJIIII)V", "bufferAllocator", "Ljetbrains/exodus/util/ByteArraySpinAllocator;", "cancelled", "", "consumer", "Ljava/lang/Thread;", "consumerFinished", "error", "", "getError", "()Ljava/lang/Throwable;", "setError", "(Ljava/lang/Throwable;)V", "inputQueue", "Ljava/util/concurrent/ArrayBlockingQueue;", "Ljetbrains/exodus/crypto/convert/EncryptMessage;", "outputQueue", "producer", "producerFinished", "statefulProducer", "jetbrains/exodus/crypto/convert/ScytaleEngine$statefulProducer$1", "Ljetbrains/exodus/crypto/convert/ScytaleEngine$statefulProducer$1;", "alloc", "cancel", "", "close", "put", "e", "start", "Companion", "xodus-crypto"})
public final class ScytaleEngine
implements Closeable {
    private final ArrayBlockingQueue<EncryptMessage> inputQueue;
    private final ArrayBlockingQueue<EncryptMessage> outputQueue;
    private final ByteArraySpinAllocator bufferAllocator;
    private volatile boolean producerFinished;
    private volatile boolean consumerFinished;
    private volatile boolean cancelled;
    @Nullable
    private volatile Throwable error;
    private final statefulProducer.1 statefulProducer;
    private final Thread producer;
    private final Thread consumer;
    private final EncryptListener listener;
    private final StreamCipherProvider cipherProvider;
    private final byte[] key;
    private final long basicIV;
    private final int blockAlignment;
    private static final long timeout = 200L;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Throwable getError() {
        return this.error;
    }

    public final void setError(@Nullable Throwable throwable) {
        this.error = throwable;
    }

    public final void start() {
        this.producer.start();
        this.consumer.start();
    }

    @NotNull
    public final byte[] alloc() {
        Object object = this.bufferAllocator.alloc();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"bufferAllocator.alloc()");
        return (byte[])object;
    }

    public final void put(@NotNull EncryptMessage e) {
        Intrinsics.checkParameterIsNotNull((Object)e, (String)"e");
        while (!this.inputQueue.offer(e, timeout, TimeUnit.MILLISECONDS)) {
            if (this.error == null) continue;
            throw (Throwable)new RuntimeException(this.error);
        }
    }

    public final void cancel() {
        this.cancelled = true;
    }

    @Override
    public void close() {
        this.producerFinished = true;
        this.producer.join();
        this.consumerFinished = true;
        this.consumer.join();
        Throwable throwable = this.error;
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl = false;
            boolean bl2 = false;
            Throwable it = throwable2;
            boolean bl3 = false;
            throw (Throwable)new RuntimeException(it);
        }
    }

    public ScytaleEngine(@NotNull EncryptListener listener, @NotNull StreamCipherProvider cipherProvider, @NotNull byte[] key, long basicIV, int blockAlignment, int bufferSize, int inputQueueSize, int outputQueueSize) {
        Intrinsics.checkParameterIsNotNull((Object)listener, (String)"listener");
        Intrinsics.checkParameterIsNotNull((Object)cipherProvider, (String)"cipherProvider");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.listener = listener;
        this.cipherProvider = cipherProvider;
        this.key = key;
        this.basicIV = basicIV;
        this.blockAlignment = blockAlignment;
        this.inputQueue = new ArrayBlockingQueue(inputQueueSize);
        this.outputQueue = new ArrayBlockingQueue(outputQueueSize);
        this.bufferAllocator = new ByteArraySpinAllocator(bufferSize, inputQueueSize + outputQueueSize + 4);
        this.statefulProducer = new Runnable(this){
            private final StreamCipher cipher;
            private int offset;
            private long iv;
            final /* synthetic */ ScytaleEngine this$0;

            public void run() {
                try {
                    while (!ScytaleEngine.access$getCancelled$p(this.this$0) && this.this$0.getError() == null) {
                        if ((EncryptMessage)ScytaleEngine.access$getInputQueue$p(this.this$0).poll(ScytaleEngine.Companion.getTimeout(), TimeUnit.MILLISECONDS) != null) {
                            EncryptMessage encryptMessage;
                            boolean bl = false;
                            boolean bl2 = false;
                            EncryptMessage it = encryptMessage;
                            boolean bl3 = false;
                            EncryptMessage encryptMessage2 = it;
                            if (encryptMessage2 instanceof FileHeader) {
                                this.offset = 0;
                                this.iv = ScytaleEngine.access$getBasicIV$p(this.this$0) + (((FileHeader)it).getChunkedIV() ? ((FileHeader)it).getHandle() / (long)ScytaleEngine.access$getBlockAlignment$p(this.this$0) : ((FileHeader)it).getHandle());
                                this.cipher.init(ScytaleEngine.access$getKey$p(this.this$0), EnvKryptKt.asHashedIV((long)this.iv));
                            } else if (encryptMessage2 instanceof FileChunk) {
                                this.encryptChunk((FileChunk)it);
                            } else if (!(encryptMessage2 instanceof EndChunk)) {
                                throw (Throwable)new IllegalArgumentException();
                            }
                            while (!ScytaleEngine.access$getOutputQueue$p(this.this$0).offer(it, ScytaleEngine.Companion.getTimeout(), TimeUnit.MILLISECONDS)) {
                                if (!ScytaleEngine.access$getCancelled$p(this.this$0) && this.this$0.getError() == null) continue;
                                return;
                            }
                            continue;
                        }
                        if (!ScytaleEngine.access$getProducerFinished$p(this.this$0)) continue;
                        return;
                    }
                }
                catch (Throwable t) {
                    ScytaleEngine.access$setProducerFinished$p(this.this$0, true);
                    this.this$0.setError(t);
                }
            }

            private final void encryptChunk(FileChunk it) {
                if (it.getHeader().getCanBeEncrypted()) {
                    byte[] data = it.getData();
                    if (it.getHeader().getChunkedIV()) {
                        this.blockEncrypt(it.getSize(), data);
                    } else {
                        this.encrypt(it.getSize(), data);
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void encrypt(int size, byte[] data) {
                int n = 0;
                int n2 = size;
                while (n < n2) {
                    void i;
                    data[i] = this.cipher.crypt(data[i]);
                    ++i;
                }
            }

            /*
             * WARNING - void declaration
             */
            private final void blockEncrypt(int size, byte[] data) {
                int n = 0;
                int n2 = size;
                while (n < n2) {
                    void i;
                    data[i] = this.cipher.crypt(data[i]);
                    statefulProducer.1 v0 = this;
                    ++v0.offset;
                    if (v0.offset == ScytaleEngine.access$getBlockAlignment$p(this.this$0)) {
                        this.offset = 0;
                        statefulProducer.1 v1 = this;
                        ++v1.iv;
                        this.cipher.init(ScytaleEngine.access$getKey$p(this.this$0), EnvKryptKt.asHashedIV((long)v1.iv));
                    }
                    ++i;
                }
            }
            {
                this.this$0 = $outer;
                StreamCipher streamCipher = ScytaleEngine.access$getCipherProvider$p($outer).newCipher();
                Intrinsics.checkExpressionValueIsNotNull((Object)streamCipher, (String)"cipherProvider.newCipher()");
                this.cipher = streamCipher;
            }
        };
        this.producer = new Thread((Runnable)this.statefulProducer, "xodus encrypt " + this.hashCode());
        this.consumer = new Thread(new Runnable(this){
            final /* synthetic */ ScytaleEngine this$0;

            public final void run() {
                try {
                    FileHeader currentFile = null;
                    while (!ScytaleEngine.access$getCancelled$p(this.this$0) && this.this$0.getError() == null) {
                        EncryptMessage encryptMessage = (EncryptMessage)ScytaleEngine.access$getOutputQueue$p(this.this$0).poll(ScytaleEngine.Companion.getTimeout(), TimeUnit.MILLISECONDS);
                        if (encryptMessage != null) {
                            Object object;
                            FileHeader it;
                            FileHeader fileHeader;
                            boolean bl;
                            boolean bl2;
                            EncryptMessage encryptMessage2 = encryptMessage;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            EncryptMessage it2 = encryptMessage2;
                            boolean bl5 = false;
                            EncryptMessage encryptMessage3 = it2;
                            if (encryptMessage3 instanceof FileHeader) {
                                if (currentFile != null) {
                                    bl2 = false;
                                    bl = false;
                                    it = fileHeader;
                                    boolean bl6 = false;
                                    ScytaleEngine.access$getListener$p(this.this$0).onFileEnd(it);
                                }
                                currentFile = (FileHeader)it2;
                                ScytaleEngine.access$getListener$p(this.this$0).onFile((FileHeader)it2);
                                object = Unit.INSTANCE;
                            } else if (encryptMessage3 instanceof FileChunk) {
                                FileHeader current = currentFile;
                                if (current != null && Intrinsics.areEqual((Object)current, (Object)((FileChunk)it2).getHeader()) ^ true) {
                                    throw new Throwable("Invalid chunk with header " + ((FileChunk)it2).getHeader().getPath());
                                }
                                ScytaleEngine.access$getListener$p(this.this$0).onData(((FileChunk)it2).getHeader(), ((FileChunk)it2).getSize(), ((FileChunk)it2).getData());
                                object = ScytaleEngine.access$getBufferAllocator$p(this.this$0).dispose((Object)((FileChunk)it2).getData());
                            } else if (encryptMessage3 instanceof EndChunk) {
                                if (currentFile != null) {
                                    bl2 = false;
                                    bl = false;
                                    it = fileHeader;
                                    boolean bl7 = false;
                                    ScytaleEngine.access$getListener$p(this.this$0).onFileEnd(it);
                                    object = Unit.INSTANCE;
                                } else {
                                    object = null;
                                }
                            } else {
                                throw (Throwable)new IllegalArgumentException();
                            }
                            encryptMessage = object;
                            if (object != null) continue;
                        }
                        if (ScytaleEngine.access$getConsumerFinished$p(this.this$0)) {
                            return;
                        }
                        encryptMessage = Unit.INSTANCE;
                    }
                }
                catch (Throwable t) {
                    ScytaleEngine.access$setConsumerFinished$p(this.this$0, true);
                    this.this$0.setError(t);
                }
            }
            {
                this.this$0 = scytaleEngine;
            }
        }, "xodus write " + this.hashCode());
    }

    public /* synthetic */ ScytaleEngine(EncryptListener encryptListener, StreamCipherProvider streamCipherProvider, byte[] byArray, long l, int n, int n2, int n3, int n4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 0x10) != 0) {
            n = 1024;
        }
        if ((n5 & 0x20) != 0) {
            n2 = 0x100000;
        }
        if ((n5 & 0x40) != 0) {
            n3 = 40;
        }
        if ((n5 & 0x80) != 0) {
            n4 = 40;
        }
        this(encryptListener, streamCipherProvider, byArray, l, n, n2, n3, n4);
    }

    static {
        timeout = 200L;
    }

    public static final /* synthetic */ boolean access$getCancelled$p(ScytaleEngine $this) {
        return $this.cancelled;
    }

    public static final /* synthetic */ void access$setCancelled$p(ScytaleEngine $this, boolean bl) {
        $this.cancelled = bl;
    }

    public static final /* synthetic */ ArrayBlockingQueue access$getInputQueue$p(ScytaleEngine $this) {
        return $this.inputQueue;
    }

    public static final /* synthetic */ long access$getBasicIV$p(ScytaleEngine $this) {
        return $this.basicIV;
    }

    public static final /* synthetic */ int access$getBlockAlignment$p(ScytaleEngine $this) {
        return $this.blockAlignment;
    }

    public static final /* synthetic */ byte[] access$getKey$p(ScytaleEngine $this) {
        return $this.key;
    }

    public static final /* synthetic */ ArrayBlockingQueue access$getOutputQueue$p(ScytaleEngine $this) {
        return $this.outputQueue;
    }

    public static final /* synthetic */ boolean access$getProducerFinished$p(ScytaleEngine $this) {
        return $this.producerFinished;
    }

    public static final /* synthetic */ void access$setProducerFinished$p(ScytaleEngine $this, boolean bl) {
        $this.producerFinished = bl;
    }

    public static final /* synthetic */ StreamCipherProvider access$getCipherProvider$p(ScytaleEngine $this) {
        return $this.cipherProvider;
    }

    public static final /* synthetic */ EncryptListener access$getListener$p(ScytaleEngine $this) {
        return $this.listener;
    }

    public static final /* synthetic */ ByteArraySpinAllocator access$getBufferAllocator$p(ScytaleEngine $this) {
        return $this.bufferAllocator;
    }

    public static final /* synthetic */ boolean access$getConsumerFinished$p(ScytaleEngine $this) {
        return $this.consumerFinished;
    }

    public static final /* synthetic */ void access$setConsumerFinished$p(ScytaleEngine $this, boolean bl) {
        $this.consumerFinished = bl;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/crypto/convert/ScytaleEngine$Companion;", "Lmu/KLogging;", "()V", "timeout", "", "getTimeout", "()J", "xodus-crypto"})
    public static final class Companion
    extends KLogging {
        public final long getTimeout() {
            return timeout;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

