/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.crypto.convert;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jetbrains.exodus.ExodusException;
import jetbrains.exodus.backup.BackupStrategy;
import jetbrains.exodus.backup.Backupable;
import jetbrains.exodus.backup.VirtualFileDescriptor;
import jetbrains.exodus.crypto.convert.EndChunk;
import jetbrains.exodus.crypto.convert.FileChunk;
import jetbrains.exodus.crypto.convert.FileHeader;
import jetbrains.exodus.crypto.convert.ScytaleEngine;
import jetbrains.exodus.log.LogUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u001a\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0006\u0010\b\u001a\u00020\t\u001a\u0012\u0010\f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u0005*\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"NO_IV", "Lkotlin/Pair;", "", "", "appendFile", "", "out", "Ljetbrains/exodus/crypto/convert/ScytaleEngine;", "fd", "Ljetbrains/exodus/backup/VirtualFileDescriptor;", "fileSize", "getFileIV", "encryptBackupable", "source", "Ljetbrains/exodus/backup/Backupable;", "encryptFiles", "strategy", "Ljetbrains/exodus/backup/BackupStrategy;", "xodus-crypto"})
public final class UtilKt {
    private static final Pair<Long, Boolean> NO_IV = TuplesKt.to((Object)0L, (Object)false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void encryptBackupable(@NotNull ScytaleEngine $this$encryptBackupable, @NotNull Backupable source) {
        Intrinsics.checkParameterIsNotNull((Object)$this$encryptBackupable, (String)"$this$encryptBackupable");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        BackupStrategy backupStrategy = source.getBackupStrategy();
        Intrinsics.checkExpressionValueIsNotNull((Object)backupStrategy, (String)"source.backupStrategy");
        BackupStrategy strategy = backupStrategy;
        strategy.beforeBackup();
        try {
            UtilKt.encryptFiles($this$encryptBackupable, strategy);
        }
        catch (Throwable t) {
            strategy.onError(t);
            RuntimeException runtimeException = ExodusException.toExodusException((Throwable)t, (String)"Encrypted backup failed");
            Intrinsics.checkExpressionValueIsNotNull((Object)runtimeException, (String)"ExodusException.toExodus\u2026Encrypted backup failed\")");
            throw (Throwable)runtimeException;
        }
        finally {
            strategy.afterBackup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void encryptFiles(@NotNull ScytaleEngine $this$encryptFiles, @NotNull BackupStrategy strategy) {
        Intrinsics.checkParameterIsNotNull((Object)$this$encryptFiles, (String)"$this$encryptFiles");
        Intrinsics.checkParameterIsNotNull((Object)strategy, (String)"strategy");
        $this$encryptFiles.start();
        Closeable closeable = $this$encryptFiles;
        boolean bl = false;
        Throwable throwable = null;
        try {
            ScytaleEngine it = (ScytaleEngine)closeable;
            boolean bl2 = false;
            for (VirtualFileDescriptor descriptor : strategy.getContents()) {
                if (strategy.isInterrupted()) break;
                if (!descriptor.hasContent()) continue;
                VirtualFileDescriptor virtualFileDescriptor = descriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileDescriptor, (String)"descriptor");
                long l = virtualFileDescriptor.getFileSize();
                long l2 = strategy.acceptFile(descriptor);
                boolean bl3 = false;
                long fileSize = Math.min(l, l2);
                if (fileSize <= 0L) continue;
                UtilKt.appendFile(it, descriptor, fileSize);
            }
            it.put(EndChunk.INSTANCE);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Pair<Long, Boolean> getFileIV(@NotNull VirtualFileDescriptor fd) {
        int blobExtensionStart;
        Intrinsics.checkParameterIsNotNull((Object)fd, (String)"fd");
        String string = fd.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fd.name");
        String name = string;
        if (StringsKt.endsWith$default((String)name, (String)".xd", (boolean)false, (int)2, null)) {
            return TuplesKt.to((Object)LogUtil.getAddress((String)name), (Object)true);
        }
        String string2 = fd.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fd.path");
        String path = string2;
        int blobsLocation = StringsKt.indexOf$default((CharSequence)path, (String)"blobs", (int)0, (boolean)false, (int)6, null);
        if (blobsLocation >= 0 && ((blobExtensionStart = StringsKt.indexOf$default((CharSequence)name, (String)".", (int)0, (boolean)false, (int)6, null)) == 2 || blobExtensionStart == 1)) {
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = StringsKt.split$default((CharSequence)StringsKt.substring((String)path, (IntRange)RangesKt.until((int)(blobsLocation + 5), (int)path.length())), (String[])new String[]{"\\", "/"}, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$filter2 = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                CharSequence charSequence = it;
                boolean bl2 = false;
                if (!(charSequence.length() > 0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List tokens = CollectionsKt.asReversed((List)((List)destination$iv$iv2));
            try {
                String $i$f$filter2 = name;
                int $this$filterTo$iv$iv2 = 0;
                boolean destination$iv$iv2 = false;
                String string3 = $i$f$filter2;
                if (string3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring($this$filterTo$iv$iv2, blobExtensionStart);
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String string5 = string4;
                long result = Integer.parseInt(string5, 16);
                int shift = 0;
                Iterable $this$forEach$iv = tokens;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String it = (String)element$iv;
                    boolean bl = false;
                    result += (long)Integer.parseInt(it, 16) << (shift += 8);
                }
                return TuplesKt.to((Object)(-result), (Object)false);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw (Throwable)new IllegalArgumentException("Bad virtual file descriptor " + fd.getPath() + ' ' + fd.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void appendFile(ScytaleEngine out, VirtualFileDescriptor fd, long fileSize) {
        if (!fd.hasContent()) {
            throw (Throwable)new IllegalArgumentException("Provided source is not a file: " + fd.getPath());
        }
        boolean canBeEncrypted = fd.canBeEncrypted();
        Pair<Long, Boolean> iv = canBeEncrypted ? UtilKt.getFileIV(fd) : NO_IV;
        String string = fd.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"fd.path");
        String string2 = fd.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"fd.name");
        FileHeader header = new FileHeader(string, string2, fileSize, fd.getTimeStamp(), ((Number)iv.getFirst()).longValue(), (Boolean)iv.getSecond(), canBeEncrypted);
        out.put(header);
        InputStream inputStream = fd.getInputStream();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"fd.inputStream");
        InputStream input = inputStream;
        try {
            long totalRead = 0L;
            while (totalRead < fileSize) {
                byte[] buffer = out.alloc();
                int read = input.read(buffer);
                if (read < 0) {
                    break;
                }
                if (read <= 0) continue;
                long l = fileSize - totalRead;
                long l2 = read;
                boolean bl = false;
                read = (int)Math.min(l, l2);
                out.put(new FileChunk(header, read, buffer));
                totalRead += (long)read;
            }
        }
        finally {
            if (fd.shouldCloseStream()) {
                input.close();
            }
        }
    }
}

