/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import org.jetbrains.annotations.NotNull;

public enum EntityIterableType {
    EMPTY("Empty iterable", 0),
    ALL_ENTITIES("All entities of specific type", 1),
    SINGLE_ENTITY("Single entity", 2),
    ENTITY_FROM_LINKS("Outgoing links from an entity", 3),
    ENTITY_TO_LINKS("Incoming links to an entity", 4),
    ENTITIES_WITH_LINK("Entities with link", 5),
    ENTITIES_WITH_PROPERTY("Entities with property", 6){

        @Override
        public boolean isPropertyIndex() {
            return true;
        }
    }
    ,
    ENTITIES_WITH_PROPERTY_SORTED_BY_VALUE("Entities with property sorted by its value", 7){

        @Override
        public boolean isPropertyIndex() {
            return true;
        }
    }
    ,
    ENTITIES_BY_PROP_VALUE("Entities with specified property value", 8){

        @Override
        public boolean isPropertyIndex() {
            return true;
        }
    }
    ,
    ENTITIES_BY_PROP_VALUE_IN_RANGE("Entities with a property value in range", 9){

        @Override
        public boolean isPropertyIndex() {
            return true;
        }
    }
    ,
    ENTITIES_WITH_BLOB("Entities with blob", 10),
    INTERSECT("Intersection", 11),
    UNION("Union", 12),
    MINUS("Minus", 13),
    CONCAT("Concatenation", 14),
    REVERSE("Reversed iterable", 15),
    SORTING("Sorting iterable", 16),
    SORTING_LINKS("Sorting links iterable", 17),
    MERGE_SORTED("Merge sorted iterables", 18),
    DISTINCT("Distinct iterable", 19),
    SELECT_DISTINCT("Select distinct iterable", 20),
    SELECTMANY_DISTINCT("SelectMany distinct iterable", 21),
    SKIP("Skip iterable", 22),
    TAKE("Take iterable", 23),
    SEARCH_RESULTS("Search results iterable", 24),
    ENTITY_FROM_LINKS_SET("Outgoing links of a set from an entity", 25),
    ADD_NULL("Left operand appended with null if it's present in the right, but not left one", 26),
    EXCLUDE_NULL("Exclude null", 27),
    FILTER_ENTITY_TYPE("Filter source iterable by entity type", 28),
    FILTER_LINKS("Filter source iterable by links set", 29),
    ENTITIES_WITH_CERTAIN_LINK("All entities of specified type with certain link", 30),
    ALL_ENTITIES_RANGE("Entities of specific type within id range", 31);

    private final String description;
    private final int type;

    private EntityIterableType(String description, int type) {
        this.description = description;
        this.type = type;
    }

    @NotNull
    public String getDescription() {
        return this.description;
    }

    public int getType() {
        return this.type;
    }

    public boolean isPropertyIndex() {
        return false;
    }
}

