/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.ComparableValueType;
import jetbrains.exodus.bindings.DoubleBinding;
import jetbrains.exodus.bindings.FloatBinding;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.core.dataStructures.hash.IntHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.core.dataStructures.hash.LongHashSet;
import jetbrains.exodus.core.dataStructures.hash.LongIterator;
import jetbrains.exodus.core.dataStructures.hash.LongSet;
import jetbrains.exodus.core.dataStructures.hash.PackedLongHashSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLong23TreeSet;
import jetbrains.exodus.core.dataStructures.persistent.PersistentLongSet;
import jetbrains.exodus.entitystore.BlobVault;
import jetbrains.exodus.entitystore.BlobVaultItem;
import jetbrains.exodus.entitystore.DiskBasedBlobVault;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.FileSystemBlobVaultOld;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.Settings;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.entitystore.StoreTransactionalComputable;
import jetbrains.exodus.entitystore.StoreTransactionalExecutable;
import jetbrains.exodus.entitystore.tables.BlobsTable;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.LinksTable;
import jetbrains.exodus.entitystore.tables.PropertiesTable;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.exodus.env.Store;
import jetbrains.exodus.env.StoreConfig;
import jetbrains.exodus.env.Transaction;
import jetbrains.exodus.env.TransactionalExecutable;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0006J\u0006\u0010\b\u001a\u00020\u0006J\u0006\u0010\t\u001a\u00020\u0006J\u0006\u0010\n\u001a\u00020\u0006J\u0006\u0010\u000b\u001a\u00020\u0006J\u0006\u0010\f\u001a\u00020\u0006J\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fJ\u0006\u0010\u0012\u001a\u00020\u0006J\u0006\u0010\u0013\u001a\u00020\u0006J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ljetbrains/exodus/entitystore/PersistentEntityStoreRefactorings;", "", "store", "Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;", "(Ljetbrains/exodus/entitystore/PersistentEntityStoreImpl;)V", "refactorBlobFileLengths", "", "refactorCreateNullBlobIndices", "refactorCreateNullLinkIndices", "refactorCreateNullPropertyIndices", "refactorDeleteRedundantBlobs", "refactorDropEmptyPrimaryLinkTables", "refactorEntitiesTables", "refactorFixNegativeFloatAndDoubleProps", "settings", "Ljetbrains/exodus/env/Store;", "refactorMakeLinkTablesConsistent", "internalSettings", "refactorMakePropTablesConsistent", "refactorRemoveHistoryStores", "safeExclusiveExecuteRefactoringForEntityType", "entityType", "", "executable", "Ljetbrains/exodus/entitystore/StoreTransactionalExecutable;", "safeExecuteRefactoringForEntityType", "transactionalCopyAndRemoveEntitiesStore", "sourceName", "targetName", "Companion", "xodus-entity-store"})
public final class PersistentEntityStoreRefactorings {
    private final PersistentEntityStoreImpl store;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void refactorDeleteRedundantBlobs() {
        BlobVault blobVault = this.store.getBlobVault();
        Intrinsics.checkExpressionValueIsNotNull((Object)blobVault, (String)"store.blobVault");
        BlobVault blobVault2 = blobVault;
        if (blobVault2 instanceof FileSystemBlobVaultOld) {
            PersistentEntityStoreRefactorings.Companion.logInfo("Deleting redundant blobs...");
            Long nextBlobHandle2 = (Long)this.store.computeInReadonlyTransaction((StoreTransactionalComputable)new StoreTransactionalComputable<Long>(blobVault2){
                final /* synthetic */ BlobVault $blobVault;

                public final long compute(@NotNull StoreTransaction tx) {
                    Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                    PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                    return this.$blobVault.nextHandle(txn.getEnvironmentTransaction());
                }
                {
                    this.$blobVault = blobVault;
                }
            });
            int n = 0;
            int n2 = 9999;
            while (n <= n2) {
                BlobVaultItem item;
                void i;
                Intrinsics.checkExpressionValueIsNotNull((Object)blobVault2.getBlob(nextBlobHandle2 + (long)i), (String)"blobVault.getBlob(nextBlobHandle + i)");
                if (item.exists()) {
                    if (blobVault2.delete(item.getHandle())) {
                        PersistentEntityStoreRefactorings.Companion.logInfo("Deleted " + item);
                    } else {
                        Companion.getLogger().error("Failed to delete " + item);
                    }
                }
                ++i;
            }
        }
    }

    public final void refactorEntitiesTables() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;

            public final void execute(@NotNull StoreTransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (String entityType : PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes(txn)) {
                    String sourceName;
                    PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0);
                    String string = entityType;
                    if (string == null) {
                        Intrinsics.throwNpe();
                    }
                    int entityTypeId = persistentEntityStoreImpl.getEntityTypeId(txn, string, false);
                    Intrinsics.checkExpressionValueIsNotNull((Object)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getNamingRules().getEntitiesTableName(entityTypeId), (String)"store.namingRules.getEnt\u2026esTableName(entityTypeId)");
                    String targetName = sourceName + "_temp";
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Refactoring " + sourceName + " to key-prefixed store.");
                    PersistentEntityStoreRefactorings.access$transactionalCopyAndRemoveEntitiesStore(this.this$0, sourceName, targetName);
                    PersistentEntityStoreRefactorings.access$transactionalCopyAndRemoveEntitiesStore(this.this$0, targetName, sourceName);
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
            }
        });
    }

    public final void refactorCreateNullPropertyIndices() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;

            public final void execute(@NotNull StoreTransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (String entityType : PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes(txn)) {
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Refactoring creating null-value property indices for [" + entityType + ']');
                    String string = entityType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entityType");
                    PersistentEntityStoreRefactorings.access$safeExecuteRefactoringForEntityType(this.this$0, string, new StoreTransactionalExecutable(this, entityType){
                        final /* synthetic */ refactorCreateNullPropertyIndices.1 this$0;
                        final /* synthetic */ String $entityType;

                        public final void execute(@NotNull StoreTransaction tx) {
                            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                            int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntityTypeId(txn, this.$entityType, false);
                            PropertiesTable propertiesTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getPropertiesTable(txn, entityTypeId);
                            Intrinsics.checkExpressionValueIsNotNull((Object)propertiesTable, (String)"store.getPropertiesTable(txn, entityTypeId)");
                            PropertiesTable props = propertiesTable;
                            Store allPropsIndex = props.getAllPropsIndex();
                            Cursor cursor = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getPrimaryPropertyIndexCursor(txn, entityTypeId);
                            Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"store.getPrimaryProperty\u2026Cursor(txn, entityTypeId)");
                            Cursor cursor2 = cursor;
                            Transaction transaction = txn.getEnvironmentTransaction();
                            Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"txn.environmentTransaction");
                            Transaction envTxn = transaction;
                            while (cursor2.getNext()) {
                                PropertyKey propertyKey;
                                PropertyKey propertyKey2 = propertyKey = PropertyKey.entryToPropertyKey(cursor2.getKey());
                                Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey2, (String)"propertyKey");
                                allPropsIndex.put(envTxn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)propertyKey2.getPropertyId()), (ByteIterable)LongBinding.longToCompressedEntry((long)propertyKey.getEntityLocalId()));
                            }
                            cursor2.close();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$entityType = string;
                        }
                    });
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
            }
        });
    }

    public final void refactorCreateNullBlobIndices() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;

            public final void execute(@NotNull StoreTransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (String entityType : PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes(txn)) {
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Refactoring creating null-value blob indices for [" + entityType + ']');
                    String string = entityType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entityType");
                    PersistentEntityStoreRefactorings.access$safeExecuteRefactoringForEntityType(this.this$0, string, new StoreTransactionalExecutable(this, entityType){
                        final /* synthetic */ refactorCreateNullBlobIndices.1 this$0;
                        final /* synthetic */ String $entityType;

                        public final void execute(@NotNull StoreTransaction tx) {
                            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                            int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntityTypeId(txn, this.$entityType, false);
                            BlobsTable blobsTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getBlobsTable(txn, entityTypeId);
                            Intrinsics.checkExpressionValueIsNotNull((Object)blobsTable, (String)"store.getBlobsTable(txn, entityTypeId)");
                            BlobsTable blobs = blobsTable;
                            Store allBlobsIndex = blobs.getAllBlobsIndex();
                            Transaction transaction = txn.getEnvironmentTransaction();
                            Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"txn.environmentTransaction");
                            Transaction envTxn = transaction;
                            Cursor cursor = blobs.getPrimaryIndex().openCursor(envTxn);
                            while (true) {
                                PropertyKey propertyKey;
                                Cursor cursor2 = cursor;
                                Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                                if (!cursor2.getNext()) break;
                                PropertyKey propertyKey2 = propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey2, (String)"propertyKey");
                                allBlobsIndex.put(envTxn, (ByteIterable)IntegerBinding.intToCompressedEntry((int)propertyKey2.getPropertyId()), (ByteIterable)LongBinding.longToCompressedEntry((long)propertyKey.getEntityLocalId()));
                            }
                            cursor.close();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$entityType = string;
                        }
                    });
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
            }
        });
    }

    public final void refactorBlobFileLengths() {
        BlobVault blobVault = this.store.getBlobVault();
        Intrinsics.checkExpressionValueIsNotNull((Object)blobVault, (String)"store.blobVault");
        BlobVault blobVault2 = blobVault;
        if (blobVault2 instanceof DiskBasedBlobVault) {
            DiskBasedBlobVault diskVault = (DiskBasedBlobVault)blobVault2;
            this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this, diskVault){
                final /* synthetic */ PersistentEntityStoreRefactorings this$0;
                final /* synthetic */ DiskBasedBlobVault $diskVault;

                public final void execute(@NotNull StoreTransaction tx) {
                    Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                    PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                    for (String entityType : PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes(txn)) {
                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Refactoring blob lengths table for [" + entityType + ']');
                        String string = entityType;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entityType");
                        PersistentEntityStoreRefactorings.access$safeExecuteRefactoringForEntityType(this.this$0, string, new StoreTransactionalExecutable(this, entityType){
                            final /* synthetic */ refactorBlobFileLengths.1 this$0;
                            final /* synthetic */ String $entityType;

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public final void execute(@NotNull StoreTransaction tx) {
                                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntityTypeId(txn, this.$entityType, false);
                                BlobsTable blobsTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getBlobsTable(txn, entityTypeId);
                                Intrinsics.checkExpressionValueIsNotNull((Object)blobsTable, (String)"store.getBlobsTable(txn, entityTypeId)");
                                BlobsTable blobs = blobsTable;
                                Transaction transaction = txn.getEnvironmentTransaction();
                                Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"txn.environmentTransaction");
                                Transaction envTxn = transaction;
                                Closeable closeable = (Closeable)blobs.getPrimaryIndex().openCursor(envTxn);
                                boolean bl = false;
                                Throwable throwable = null;
                                try {
                                    Cursor cursor = (Cursor)closeable;
                                    boolean bl2 = false;
                                    while (true) {
                                        Cursor cursor2 = cursor;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                                        if (!cursor2.getNext()) break;
                                        long blobHandle = LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue());
                                        if (PersistentEntityStoreImpl.isEmptyOrInPlaceBlobHandle(blobHandle)) continue;
                                        PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).setBlobFileLength(txn, blobHandle, this.this$0.$diskVault.getBlobLocation(blobHandle).length());
                                    }
                                    Unit unit = Unit.INSTANCE;
                                }
                                catch (Throwable throwable2) {
                                    throwable = throwable2;
                                    throw throwable2;
                                }
                                finally {
                                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$entityType = string;
                            }
                        });
                    }
                }
                {
                    this.this$0 = persistentEntityStoreRefactorings;
                    this.$diskVault = diskBasedBlobVault;
                }
            });
        }
    }

    public final void refactorCreateNullLinkIndices() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;

            public final void execute(@NotNull StoreTransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (String entityType : PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes(txn)) {
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Refactoring creating null-value link indices for [" + entityType + ']');
                    String string = entityType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entityType");
                    PersistentEntityStoreRefactorings.access$safeExclusiveExecuteRefactoringForEntityType(this.this$0, string, new StoreTransactionalExecutable(this, entityType){
                        final /* synthetic */ refactorCreateNullLinkIndices.1 this$0;
                        final /* synthetic */ String $entityType;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void execute(@NotNull StoreTransaction tx) {
                            Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                            int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntityTypeId(txn, this.$entityType, false);
                            LinksTable linksTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getLinksTable(txn, entityTypeId);
                            Intrinsics.checkExpressionValueIsNotNull((Object)linksTable, (String)"store.getLinksTable(txn, entityTypeId)");
                            LinksTable links = linksTable;
                            Store allLinksIndex = links.getAllLinksIndex();
                            Transaction transaction = txn.getEnvironmentTransaction();
                            Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"txn.environmentTransaction");
                            Transaction envTxn = transaction;
                            if (allLinksIndex.count(envTxn) > 0L) {
                                PersistentEntityStoreRefactorings.Companion.getLogger().warn("Refactoring creating null-value link indices looped for [" + this.$entityType + ']');
                                Environment environment = envTxn.getEnvironment();
                                Store store = allLinksIndex;
                                Intrinsics.checkExpressionValueIsNotNull((Object)store, (String)"allLinksIndex");
                                environment.truncateStore(store.getName(), envTxn);
                                PersistentEntityStoreRefactorings.access$getStore$p((PersistentEntityStoreRefactorings)this.this$0.this$0).linksTables.remove(entityTypeId);
                                LinksTable linksTable2 = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getLinksTable(txn, entityTypeId);
                                Intrinsics.checkExpressionValueIsNotNull((Object)linksTable2, (String)"store.getLinksTable(txn, entityTypeId)");
                                links = linksTable2;
                                allLinksIndex = links.getAllLinksIndex();
                            }
                            Transaction readonlySnapshot = envTxn.getReadonlySnapshot();
                            try {
                                Cursor cursor = links.getSecondIndexCursor(readonlySnapshot);
                                Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"links.getSecondIndexCursor(readonlySnapshot)");
                                Cursor cursor2 = cursor;
                                long total = links.getSecondaryCount(readonlySnapshot);
                                long done = 0L;
                                int prevLinkId = -1;
                                PersistentLongSet.MutableSet idSet2 = new PersistentLong23TreeSet().beginWrite();
                                String format = "done %4.1f%% for " + this.$entityType;
                                while (cursor2.getNext()) {
                                    PropertyKey linkKey;
                                    PropertyKey propertyKey = linkKey = PropertyKey.entryToPropertyKey(cursor2.getValue());
                                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey, (String)"linkKey");
                                    int linkId = propertyKey.getPropertyId();
                                    long entityLocalId = linkKey.getEntityLocalId();
                                    if (prevLinkId != linkId) {
                                        if (prevLinkId == -1) {
                                            prevLinkId = linkId;
                                        } else {
                                            if (linkId < prevLinkId) {
                                                throw (Throwable)new IllegalStateException("Unsorted index");
                                            }
                                            Store store = allLinksIndex;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)store, (String)"allLinksIndex");
                                            double d = total;
                                            PersistentLongSet.MutableSet mutableSet = idSet2;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)mutableSet, (String)"idSet");
                                            done = this.dumpSetAndFlush(format, store, txn, d, done, prevLinkId, mutableSet);
                                            prevLinkId = linkId;
                                        }
                                    }
                                    idSet2.add(entityLocalId);
                                }
                                if (prevLinkId != -1) {
                                    Store store = allLinksIndex;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)store, (String)"allLinksIndex");
                                    double d = total;
                                    PersistentLongSet.MutableSet mutableSet = idSet2;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)mutableSet, (String)"idSet");
                                    this.dumpSetAndFlush(format, store, txn, d, done, prevLinkId, mutableSet);
                                }
                                cursor2.close();
                            }
                            finally {
                                readonlySnapshot.abort();
                            }
                        }

                        private final long dumpSetAndFlush(String format, Store allLinksIndex, PersistentStoreTransaction txn, double total, long done, int prevLinkId, PersistentLongSet.MutableSet idSet2) {
                            long done2 = done;
                            LongIterator itr = idSet2.longIterator();
                            while (itr.hasNext()) {
                                Transaction transaction = txn.getEnvironmentTransaction();
                                ByteIterable byteIterable = (ByteIterable)IntegerBinding.intToCompressedEntry((int)prevLinkId);
                                Object object = itr.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"itr.next()");
                                allLinksIndex.putRight(transaction, byteIterable, (ByteIterable)LongBinding.longToCompressedEntry((long)((Number)object).longValue()));
                                long l = done2;
                                done2 = l + 1L;
                                if (done2 % (long)10000 == 0L) {
                                    String string;
                                    StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                                    Object[] objectArray = new Object[]{(double)done2 * (double)100 / total};
                                    Companion companion = PersistentEntityStoreRefactorings.Companion;
                                    boolean bl = false;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)String.format(format, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(format, *args)");
                                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(companion, string);
                                }
                                if (done2 % (long)100000 != 0L || txn.flush()) continue;
                                throw (Throwable)new IllegalStateException("cannot flush");
                            }
                            idSet2.clear();
                            return done2;
                        }
                        {
                            this.this$0 = $outer;
                            this.$entityType = $captured_local_variable$1;
                        }
                    });
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
            }
        });
    }

    public final void refactorDropEmptyPrimaryLinkTables() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;

            public final void execute(@NotNull StoreTransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                Iterator<String> iterator = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes(txn).iterator();
                while (iterator.hasNext()) {
                    String entityType;
                    String string = entityType = iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entityType");
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$runReadonlyTransactionSafeForEntityType(PersistentEntityStoreRefactorings.Companion, string, new Runnable(this, txn, entityType){
                        final /* synthetic */ refactorDropEmptyPrimaryLinkTables.1 this$0;
                        final /* synthetic */ PersistentStoreTransaction $txn;
                        final /* synthetic */ String $entityType;

                        public final void run() {
                            Transaction transaction = this.$txn.getEnvironmentTransaction();
                            Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"txn.environmentTransaction");
                            Transaction envTxn = transaction;
                            int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntityTypeId(this.$txn, this.$entityType, false);
                            LinksTable linksTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getLinksTable(this.$txn, entityTypeId);
                            Intrinsics.checkExpressionValueIsNotNull((Object)linksTable, (String)"store.getLinksTable(txn, entityTypeId)");
                            LinksTable linksTable2 = linksTable;
                            long primaryCount = linksTable2.getPrimaryCount(envTxn);
                            if (primaryCount != 0L && linksTable2.getSecondaryCount(envTxn) == 0L) {
                                PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEnvironment().executeInTransaction(new TransactionalExecutable(linksTable2){
                                    final /* synthetic */ LinksTable $linksTable;

                                    public final void execute(@NotNull Transaction txn) {
                                        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                                        this.$linksTable.truncateFirst(txn);
                                    }
                                    {
                                        this.$linksTable = linksTable;
                                    }
                                });
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Drop links' tables when primary index is empty for [" + this.$entityType + ']');
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$txn = persistentStoreTransaction;
                            this.$entityType = string;
                        }
                    });
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
            }
        });
    }

    public final void refactorMakeLinkTablesConsistent(@Nullable Store internalSettings) {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this, internalSettings){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;
            final /* synthetic */ Store $internalSettings;

            public final void execute(@NotNull StoreTransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (String entityType : PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes(txn)) {
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Refactoring making links' tables consistent for [" + entityType + ']');
                    String string = entityType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entityType");
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$runReadonlyTransactionSafeForEntityType(PersistentEntityStoreRefactorings.Companion, string, new Runnable(this, txn, entityType){
                        final /* synthetic */ refactorMakeLinkTablesConsistent.1 this$0;
                        final /* synthetic */ PersistentStoreTransaction $txn;
                        final /* synthetic */ String $entityType;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public final void run() {
                            Object cursor4;
                            boolean bl;
                            Object cursor22;
                            Collection redundantLinks = new ArrayList<E>();
                            Collection deleteLinks = new ArrayList<E>();
                            int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntityTypeId(this.$txn, this.$entityType, false);
                            LinksTable linksTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getLinksTable(this.$txn, entityTypeId);
                            Intrinsics.checkExpressionValueIsNotNull((Object)linksTable, (String)"store.getLinksTable(txn, entityTypeId)");
                            LinksTable linksTable2 = linksTable;
                            Transaction transaction = this.$txn.getEnvironmentTransaction();
                            Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"txn.environmentTransaction");
                            Transaction envTxn = transaction;
                            LongSet all = (LongSet)new PackedLongHashSet(null, 0.0f, 3, null);
                            LongSet linkFilter = (LongSet)new PackedLongHashSet(null, 0.0f, 3, null);
                            Closeable closeable = (Closeable)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntitiesIndexCursor(this.$txn, entityTypeId);
                            boolean bl2 = false;
                            Throwable throwable = null;
                            try {
                                cursor22 = (Cursor)closeable;
                                bl = false;
                                while (true) {
                                    Cursor cursor3 = cursor22;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor3, (String)"cursor");
                                    if (!cursor3.getNext()) break;
                                    all.add(LongBinding.compressedEntryToLong((ByteIterable)cursor22.getKey()));
                                }
                                cursor22 = Unit.INSTANCE;
                            }
                            catch (Throwable cursor22) {
                                throwable = cursor22;
                                throw cursor22;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                            }
                            IntHashSet redundantLinkTypes = new IntHashSet();
                            IntHashSet deletedLinkTypes = new IntHashSet();
                            IntHashSet deletedLinkIds = new IntHashSet();
                            cursor22 = (Closeable)linksTable2.getFirstIndexCursor(envTxn);
                            bl = false;
                            Throwable throwable2 = null;
                            try {
                                cursor4 = cursor22;
                                boolean bl3 = false;
                                while (true) {
                                    EntityId targetEntityId;
                                    ByteIterable second;
                                    ByteIterable first;
                                    Object object = cursor4;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"cursor");
                                    if (!object.getNext()) break;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor4.getKey(), (String)"cursor.key");
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor4.getValue(), (String)"cursor.value");
                                    LinkValue linkValue = null;
                                    long localId = LongBinding.compressedEntryToLong((ByteIterable)first);
                                    if (!all.contains(localId)) {
                                        try {
                                            LinkValue linkValue2 = linkValue = LinkValue.entryToLinkValue(second);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)linkValue2, (String)"linkValue");
                                            EntityId entityId = linkValue2.getEntityId();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)entityId, (String)"linkValue.entityId");
                                            deletedLinkTypes.add(entityId.getTypeId());
                                            deletedLinkIds.add(linkValue.getLinkId());
                                        }
                                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                            // empty catch block
                                        }
                                        do {
                                            deleteLinks.add(new Pair((Object)first, (Object)second));
                                        } while (cursor4.getNextDup());
                                        continue;
                                    }
                                    linkFilter.add(((long)first.hashCode() << 31) + (long)second.hashCode());
                                    try {
                                        linkValue = LinkValue.entryToLinkValue(second);
                                    }
                                    catch (ArrayIndexOutOfBoundsException ignore) {
                                        deleteLinks.add(new Pair((Object)first, (Object)second));
                                    }
                                    if (linkValue == null) continue;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)linkValue.getEntityId(), (String)"linkValue.entityId");
                                    if (PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getLastVersion(this.$txn, targetEntityId) < 0) {
                                        deletedLinkTypes.add(targetEntityId.getTypeId());
                                        deletedLinkIds.add(linkValue.getLinkId());
                                        deleteLinks.add(new Pair((Object)first, (Object)second));
                                        continue;
                                    }
                                    linkFilter.add(((long)first.hashCode() << 31) + (long)second.hashCode());
                                    if (linksTable2.contains2(envTxn, first, second)) continue;
                                    redundantLinkTypes.add(targetEntityId.getTypeId());
                                    redundantLinks.add(new Pair((Object)first, (Object)second));
                                }
                                cursor4 = Unit.INSTANCE;
                            }
                            catch (Throwable cursor4) {
                                throwable2 = cursor4;
                                throw cursor4;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)cursor22, (Throwable)throwable2);
                            }
                            if (!redundantLinks.isEmpty()) {
                                PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEnvironment().executeInTransaction(new TransactionalExecutable(redundantLinks, linksTable2){
                                    final /* synthetic */ Collection $redundantLinks;
                                    final /* synthetic */ LinksTable $linksTable;

                                    public final void execute(@NotNull Transaction txn) {
                                        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                                        for (Pair badLink : this.$redundantLinks) {
                                            this.$linksTable.put(txn, (ByteIterable)badLink.getFirst(), (ByteIterable)badLink.getSecond());
                                        }
                                    }
                                    {
                                        this.$redundantLinks = collection;
                                        this.$linksTable = linksTable;
                                    }
                                });
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, String.valueOf(redundantLinks.size()) + " missing links found for [" + this.$entityType + ']');
                                redundantLinks.clear();
                            }
                            cursor22 = (Closeable)linksTable2.getSecondIndexCursor(envTxn);
                            bl = false;
                            throwable2 = null;
                            try {
                                cursor4 = cursor22;
                                boolean bl4 = false;
                                while (true) {
                                    ByteIterable second;
                                    ByteIterable first;
                                    Object object = cursor4;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"cursor");
                                    if (!object.getNext()) break;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor4.getKey(), (String)"cursor.key");
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor4.getValue(), (String)"cursor.value");
                                    if (linkFilter.contains(((long)first.hashCode() << 31) + (long)second.hashCode()) || linksTable2.contains(envTxn, first, second)) continue;
                                    redundantLinks.add(new Pair((Object)first, (Object)second));
                                }
                                cursor4 = Unit.INSTANCE;
                            }
                            catch (Throwable cursor5) {
                                throwable2 = cursor5;
                                throw cursor5;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)cursor22, (Throwable)throwable2);
                            }
                            int redundantLinksSize = redundantLinks.size();
                            int deleteLinksSize = deleteLinks.size();
                            if (redundantLinksSize > 0 || deleteLinksSize > 0) {
                                PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEnvironment().executeInTransaction(new TransactionalExecutable(redundantLinks, linksTable2, deleteLinks){
                                    final /* synthetic */ Collection $redundantLinks;
                                    final /* synthetic */ LinksTable $linksTable;
                                    final /* synthetic */ Collection $deleteLinks;

                                    public final void execute(@NotNull Transaction txn) {
                                        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                                        for (Pair redundantLink : this.$redundantLinks) {
                                            Cursor cursor = this.$linksTable.getSecondIndexCursor(txn);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"linksTable.getSecondIndexCursor(txn)");
                                            jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$deletePair(PersistentEntityStoreRefactorings.Companion, cursor, (ByteIterable)redundantLink.getFirst(), (ByteIterable)redundantLink.getSecond());
                                        }
                                        for (Pair deleteLink : this.$deleteLinks) {
                                            Cursor cursor = this.$linksTable.getFirstIndexCursor(txn);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"linksTable.getFirstIndexCursor(txn)");
                                            jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$deletePair(PersistentEntityStoreRefactorings.Companion, cursor, (ByteIterable)deleteLink.getFirst(), (ByteIterable)deleteLink.getSecond());
                                            Cursor cursor2 = this.$linksTable.getSecondIndexCursor(txn);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"linksTable.getSecondIndexCursor(txn)");
                                            jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$deletePair(PersistentEntityStoreRefactorings.Companion, cursor2, (ByteIterable)deleteLink.getSecond(), (ByteIterable)deleteLink.getFirst());
                                        }
                                    }
                                    {
                                        this.$redundantLinks = collection;
                                        this.$linksTable = linksTable;
                                        this.$deleteLinks = collection2;
                                    }
                                });
                                if (PersistentEntityStoreRefactorings.Companion.getLogger().isInfoEnabled()) {
                                    if (redundantLinksSize > 0) {
                                        ArrayList<String> redundantLinkTypeNames = new ArrayList<String>(redundantLinkTypes.size());
                                        for (Integer typeId : redundantLinkTypes) {
                                            PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0);
                                            Integer n = typeId;
                                            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"typeId");
                                            redundantLinkTypeNames.add(persistentEntityStoreImpl.getEntityType(this.$txn, (int)n));
                                        }
                                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, redundantLinksSize + " redundant links found and fixed for [" + this.$entityType + "] and targets: " + redundantLinkTypeNames);
                                    }
                                    if (deleteLinksSize > 0) {
                                        ArrayList<String> deletedLinkTypeNames = new ArrayList<String>(deletedLinkTypes.size());
                                        for (Integer typeId : deletedLinkTypes) {
                                            try {
                                                String entityTypeName;
                                                PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0);
                                                Integer n = typeId;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"typeId");
                                                Intrinsics.checkExpressionValueIsNotNull((Object)persistentEntityStoreImpl.getEntityType(this.$txn, (int)n), (String)"store.getEntityType(txn, typeId)");
                                                deletedLinkTypeNames.add(entityTypeName);
                                            }
                                            catch (Throwable throwable3) {}
                                        }
                                        ArrayList<String> deletedLinkIdsNames = new ArrayList<String>(deletedLinkIds.size());
                                        for (Integer typeId : deletedLinkIds) {
                                            try {
                                                String string;
                                                PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0);
                                                Integer n = typeId;
                                                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"typeId");
                                                String linkName = persistentEntityStoreImpl.getLinkName(this.$txn, n);
                                                if (linkName == null) continue;
                                                boolean bl5 = false;
                                                boolean bl6 = false;
                                                String it = string;
                                                boolean bl7 = false;
                                                deletedLinkIdsNames.add(linkName);
                                            }
                                            catch (Throwable throwable4) {}
                                        }
                                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, deleteLinksSize + " phantom links found and fixed for [" + this.$entityType + "] and targets: " + deletedLinkTypeNames);
                                        jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Link types: " + deletedLinkIdsNames);
                                    }
                                }
                            }
                            Store store = this.this$0.$internalSettings;
                            if (store == null) {
                                Intrinsics.throwNpe();
                            }
                            Settings.delete(store, "Link null-indices present");
                        }
                        {
                            this.this$0 = var1_1;
                            this.$txn = persistentStoreTransaction;
                            this.$entityType = string;
                        }
                    });
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
                this.$internalSettings = store;
            }
        });
    }

    public final void refactorMakePropTablesConsistent() {
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;

            public final void execute(@NotNull StoreTransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                for (String entityType : PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes(txn)) {
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Refactoring making props' tables consistent for [" + entityType + ']');
                    String string = entityType;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"entityType");
                    jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$runReadonlyTransactionSafeForEntityType(PersistentEntityStoreRefactorings.Companion, string, new Runnable(this, txn, entityType){
                        final /* synthetic */ refactorMakePropTablesConsistent.1 this$0;
                        final /* synthetic */ PersistentStoreTransaction $txn;
                        final /* synthetic */ String $entityType;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void run() {
                            Map.Entry<Integer, Store> localIdSet;
                            Object valueCursor;
                            Object propId;
                            Object cursor322;
                            int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntityTypeId(this.$txn, this.$entityType, false);
                            PropertiesTable propertiesTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getPropertiesTable(this.$txn, entityTypeId);
                            Intrinsics.checkExpressionValueIsNotNull((Object)propertiesTable, (String)"store.getPropertiesTable(txn, entityTypeId)");
                            PropertiesTable propTable = propertiesTable;
                            Transaction transaction = this.$txn.getEnvironmentTransaction();
                            Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"txn.environmentTransaction");
                            Transaction envTxn = transaction;
                            IntHashMap props = new IntHashMap();
                            LongSet all = (LongSet)new PackedLongHashSet(null, 0.0f, 3, null);
                            Closeable closeable = (Closeable)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntitiesIndexCursor(this.$txn, entityTypeId);
                            boolean bl = false;
                            Object object = null;
                            try {
                                Cursor cursor = (Cursor)closeable;
                                boolean bl2 = false;
                                while (true) {
                                    Cursor cursor2 = cursor;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                                    if (!cursor2.getNext()) break;
                                    all.add(LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey()));
                                }
                                cursor = Unit.INSTANCE;
                            }
                            catch (Throwable cursor) {
                                object = cursor;
                                throw cursor;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                            }
                            PropertyTypes propertyTypes = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getPropertyTypes();
                            Intrinsics.checkExpressionValueIsNotNull((Object)propertyTypes, (String)"store.propertyTypes");
                            PropertyTypes propertyTypes2 = propertyTypes;
                            LongSet entitiesToDelete = (LongSet)new LongHashSet();
                            object = (Closeable)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getPrimaryPropertyIndexCursor(this.$txn, propTable);
                            boolean cursor = false;
                            Throwable bl2 = null;
                            try {
                                cursor322 = (Cursor)object;
                                boolean bl3 = false;
                                while (true) {
                                    PropertyKey propKey;
                                    Cursor cursor4 = cursor322;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor4, (String)"cursor");
                                    if (!cursor4.getNext()) break;
                                    PropertyKey propertyKey = propKey = PropertyKey.entryToPropertyKey(cursor322.getKey());
                                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey, (String)"propKey");
                                    long localId = propertyKey.getEntityLocalId();
                                    if (!all.contains(localId)) {
                                        entitiesToDelete.add(localId);
                                        continue;
                                    }
                                    PropertyValue propValue = propertyTypes2.entryToPropertyValue(cursor322.getValue());
                                    int propId2 = propKey.getPropertyId();
                                    LongHashMap entitiesToValues = (LongHashMap)props.get(propId2);
                                    if (entitiesToValues == null) {
                                        entitiesToValues = new LongHashMap();
                                        ((Map)props).put(propId2, entitiesToValues);
                                    }
                                    ((Map)entitiesToValues).put(localId, propValue);
                                }
                                cursor322 = Unit.INSTANCE;
                            }
                            catch (Throwable cursor322) {
                                bl2 = cursor322;
                                throw cursor322;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)bl2);
                            }
                            if (!entitiesToDelete.isEmpty()) {
                                PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).executeInTransaction(new StoreTransactionalExecutable(this, entitiesToDelete, entityTypeId){
                                    final /* synthetic */ refactorMakePropTablesConsistent.1 this$0;
                                    final /* synthetic */ LongSet $entitiesToDelete;
                                    final /* synthetic */ int $entityTypeId;

                                    public final void execute(@NotNull StoreTransaction tx) {
                                        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        for (Long localId : this.$entitiesToDelete) {
                                            PersistentEntityStoreImpl persistentEntityStoreImpl = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0.this$0);
                                            PersistentEntityStoreImpl persistentEntityStoreImpl2 = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0.this$0);
                                            Long l = localId;
                                            if (l == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            persistentEntityStoreImpl.deleteEntity(txn, new PersistentEntity(persistentEntityStoreImpl2, new PersistentEntityId(this.$entityTypeId, l)));
                                        }
                                    }
                                    {
                                        this.this$0 = var1_1;
                                        this.$entitiesToDelete = longSet;
                                        this.$entityTypeId = n;
                                    }
                                });
                            }
                            List missingPairs = new ArrayList<E>();
                            IntHashMap allPropsMap = new IntHashMap();
                            cursor322 = props.keySet().iterator();
                            while (cursor322.hasNext()) {
                                Long[] localIds;
                                Store valueIndex22;
                                Object object2 = propId = (Integer)cursor322.next();
                                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"propId");
                                Store store = valueIndex22 = propTable.getValueIndex(this.$txn, (Integer)object2, false);
                                valueCursor = store != null ? store.openCursor(envTxn) : null;
                                LongHashMap entitiesToValues = (LongHashMap)props.get(((Integer)propId).intValue());
                                Intrinsics.checkExpressionValueIsNotNull((Object)entitiesToValues.keySet(), (String)"entitiesToValues.keys");
                                TreeSet<E> sortedLocalIdSet = new TreeSet<E>((Collection)((Object)localIdSet));
                                ((Map)allPropsMap).put(propId, sortedLocalIdSet);
                                Long[] $this$toTypedArray$iv = (Long[])sortedLocalIdSet;
                                int $i$f$toTypedArray = 0;
                                Long[] thisCollection$iv = $this$toTypedArray$iv;
                                if (thisCollection$iv.toArray(new Long[0]) == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                                }
                                thisCollection$iv = localIds;
                                int n = thisCollection$iv.length;
                                for ($i$f$toTypedArray = 0; $i$f$toTypedArray < n; ++$i$f$toTypedArray) {
                                    Long localId;
                                    Long l = localId = thisCollection$iv[$i$f$toTypedArray];
                                    Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"localId");
                                    PropertyValue propValue = (PropertyValue)entitiesToValues.get(l.longValue());
                                    ByteIterable byteIterable = (ByteIterable)PropertyTypes.propertyValueToEntry(propValue);
                                    PropertyValue propertyValue = propValue;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyValue, (String)"propValue");
                                    for (ByteIterable secondaryKey : PropertiesTable.createSecondaryKeys(propertyTypes2, byteIterable, propertyValue.getType())) {
                                        ArrayByteIterable arrayByteIterable = LongBinding.longToCompressedEntry((long)localId);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)arrayByteIterable, (String)"LongBinding.longToCompressedEntry(localId)");
                                        ByteIterable secondaryValue = (ByteIterable)arrayByteIterable;
                                        if (valueCursor != null && valueCursor.getSearchBoth(secondaryKey, secondaryValue)) continue;
                                        missingPairs.add(new Pair(propId, (Object)new Pair((Object)secondaryKey, (Object)secondaryValue)));
                                    }
                                }
                                Object object3 = valueCursor;
                                if (object3 == null) continue;
                                object3.close();
                            }
                            propId = missingPairs;
                            boolean cursor322 = false;
                            if (!propId.isEmpty()) {
                                PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).executeInTransaction(new StoreTransactionalExecutable(missingPairs, propTable){
                                    final /* synthetic */ List $missingPairs;
                                    final /* synthetic */ PropertiesTable $propTable;

                                    public final void execute(@NotNull StoreTransaction tx) {
                                        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        for (Pair pair : this.$missingPairs) {
                                            Store valueIndex = this.$propTable.getValueIndex(txn, ((Number)pair.getFirst()).intValue(), true);
                                            Pair missing = (Pair)pair.getSecond();
                                            if (valueIndex == null) {
                                                throw (Throwable)new NullPointerException("Can't be");
                                            }
                                            valueIndex.put(txn.getEnvironmentTransaction(), (ByteIterable)missing.getFirst(), (ByteIterable)missing.getSecond());
                                        }
                                    }
                                    {
                                        this.$missingPairs = list;
                                        this.$propTable = propertiesTable;
                                    }
                                });
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, missingPairs.size() + " missing secondary keys found and fixed for [" + this.$entityType + ']');
                            }
                            List phantomPairs = new ArrayList<E>();
                            Iterator<Map.Entry<Integer, Store>> valueIndex22 = propTable.getValueIndices().iterator();
                            while (valueIndex22.hasNext()) {
                                void propId3;
                                localIdSet = cursor322 = valueIndex22.next();
                                boolean sortedLocalIdSet = false;
                                valueCursor = localIdSet.getKey();
                                localIdSet = cursor322;
                                sortedLocalIdSet = false;
                                Store value1 = localIdSet.getValue();
                                void v13 = propId3;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v13, (String)"propId");
                                LongHashMap entitiesToValues = (LongHashMap)props.get(v13.intValue());
                                Cursor c = value1.openCursor(envTxn);
                                while (true) {
                                    ByteIterable keyEntry;
                                    ByteIterable valueEntry;
                                    Cursor cursor5 = c;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor5, (String)"c");
                                    if (!cursor5.getNext()) break;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)c.getKey(), (String)"c.key");
                                    Intrinsics.checkExpressionValueIsNotNull((Object)c.getValue(), (String)"c.value");
                                    PropertyValue propValue = (PropertyValue)entitiesToValues.get(LongBinding.compressedEntryToLong((ByteIterable)valueEntry));
                                    if (propValue != null) {
                                        Comparable data;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)propValue.getData(), (String)"propValue.data");
                                        ComparableValueType comparableValueType = propValue.getType();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)comparableValueType, (String)"propValue.type");
                                        int typeId = comparableValueType.getTypeId();
                                        Class dataClass = null;
                                        ComparableBinding objectBinding = null;
                                        if (typeId == 8) {
                                            Comparable comparable = data;
                                            if (comparable == null) {
                                                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.bindings.ComparableSet<kotlin.Comparable<kotlin.Any>>");
                                            }
                                            dataClass = ((ComparableSet)comparable).getItemClass();
                                            if (dataClass == null) {
                                                phantomPairs.add(new Pair((Object)propId3, (Object)new Pair((Object)keyEntry, (Object)valueEntry)));
                                                continue;
                                            }
                                            ComparableValueType comparableValueType2 = propertyTypes2.getPropertyType(dataClass);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)comparableValueType2, (String)"propertyTypes.getPropertyType(dataClass)");
                                            ComparableBinding comparableBinding = comparableValueType2.getBinding();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)comparableBinding, (String)"propertyTypes.getPropertyType(dataClass).binding");
                                            objectBinding = comparableBinding;
                                        } else {
                                            dataClass = data.getClass();
                                            ComparableBinding comparableBinding = propValue.getBinding();
                                            Intrinsics.checkExpressionValueIsNotNull((Object)comparableBinding, (String)"propValue.binding");
                                            objectBinding = comparableBinding;
                                        }
                                        try {
                                            Comparable value = objectBinding.entryToObject(keyEntry);
                                            if (Intrinsics.areEqual((Object)dataClass, value.getClass())) {
                                                if (typeId == 8) {
                                                    Comparable comparable = data;
                                                    if (comparable == null) {
                                                        throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.bindings.ComparableSet<*>");
                                                    }
                                                    if (((ComparableSet)comparable).containsItem((Object)value)) {
                                                        continue;
                                                    }
                                                } else if (PropertyTypes.toLowerCase(data).compareTo(value) == 0) {
                                                    continue;
                                                }
                                            }
                                        }
                                        catch (Throwable t) {
                                            PersistentEntityStoreRefactorings.Companion.getLogger().error("Error reading property value index ", t);
                                            jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$throwJVMError(PersistentEntityStoreRefactorings.Companion, t);
                                        }
                                    }
                                    phantomPairs.add(new Pair((Object)propId3, (Object)new Pair((Object)keyEntry, (Object)valueEntry)));
                                }
                                c.close();
                            }
                            Collection cursor322 = phantomPairs;
                            boolean valueIndex22 = false;
                            if (!cursor322.isEmpty()) {
                                PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).executeInTransaction(new StoreTransactionalExecutable(phantomPairs, propTable){
                                    final /* synthetic */ List $phantomPairs;
                                    final /* synthetic */ PropertiesTable $propTable;

                                    public final void execute(@NotNull StoreTransaction tx) {
                                        Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                                        PersistentStoreTransaction txn = (PersistentStoreTransaction)tx;
                                        Transaction transaction = txn.getEnvironmentTransaction();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"txn.environmentTransaction");
                                        Transaction envTxn = transaction;
                                        for (Pair pair : this.$phantomPairs) {
                                            Store valueIndex = this.$propTable.getValueIndex(txn, ((Number)pair.getFirst()).intValue(), true);
                                            Pair phantom = (Pair)pair.getSecond();
                                            if (valueIndex == null) {
                                                throw (Throwable)new NullPointerException("Can't be");
                                            }
                                            Cursor cursor = valueIndex.openCursor(envTxn);
                                            Intrinsics.checkExpressionValueIsNotNull((Object)cursor, (String)"valueIndex.openCursor(envTxn)");
                                            jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$deletePair(PersistentEntityStoreRefactorings.Companion, cursor, (ByteIterable)phantom.getFirst(), (ByteIterable)phantom.getSecond());
                                        }
                                    }
                                    {
                                        this.$phantomPairs = list;
                                        this.$propTable = propertiesTable;
                                    }
                                });
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, phantomPairs.size() + " phantom secondary keys found and fixed for [" + this.$entityType + ']');
                            }
                            List phantomIds = new ArrayList<E>();
                            Cursor c = propTable.getAllPropsIndex().openCursor(envTxn);
                            while (true) {
                                Cursor cursor6 = c;
                                Intrinsics.checkExpressionValueIsNotNull((Object)cursor6, (String)"c");
                                if (!cursor6.getNext()) break;
                                int propId4 = IntegerBinding.compressedEntryToInt((ByteIterable)c.getKey());
                                long localId = LongBinding.compressedEntryToLong((ByteIterable)c.getValue());
                                Set localIds = (Set)allPropsMap.get(propId4);
                                if (localIds == null || !localIds.remove(localId)) {
                                    phantomIds.add(new Pair((Object)propId4, (Object)localId));
                                    continue;
                                }
                                if (!localIds.isEmpty()) continue;
                                allPropsMap.remove(propId4);
                            }
                            c.close();
                            if (!allPropsMap.isEmpty()) {
                                Integer added2 = (Integer)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).computeInTransaction((StoreTransactionalComputable)new StoreTransactionalComputable<Integer>(propTable, allPropsMap){
                                    final /* synthetic */ PropertiesTable $propTable;
                                    final /* synthetic */ IntHashMap $allPropsMap;

                                    /*
                                     * WARNING - void declaration
                                     */
                                    public final int compute(@NotNull StoreTransaction txn) {
                                        void var2_2;
                                        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                                        int count = 0;
                                        Store allPropsIndex = this.$propTable.getAllPropsIndex();
                                        Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"(txn as PersistentStoreT\u2026n).environmentTransaction");
                                        Transaction envTxn = transaction;
                                        Object object = (Map)this.$allPropsMap;
                                        boolean bl = false;
                                        Iterator<Map.Entry<K, V>> iterator = object.entrySet().iterator();
                                        while (iterator.hasNext()) {
                                            void key;
                                            Map.Entry<K, V> entry;
                                            Map.Entry<K, V> entry2 = entry = iterator.next();
                                            boolean bl2 = false;
                                            object = (Integer)entry2.getKey();
                                            entry2 = entry;
                                            bl2 = false;
                                            Set value = (Set)entry2.getValue();
                                            void v1 = key;
                                            if (v1 == null) {
                                                Intrinsics.throwNpe();
                                            }
                                            ArrayByteIterable keyEntry = IntegerBinding.intToCompressedEntry((int)v1.intValue());
                                            Iterator<E> iterator2 = value.iterator();
                                            while (iterator2.hasNext()) {
                                                long localId = ((Number)iterator2.next()).longValue();
                                                allPropsIndex.put(envTxn, (ByteIterable)keyEntry, (ByteIterable)LongBinding.longToCompressedEntry((long)localId));
                                                ++count;
                                            }
                                        }
                                        return (int)var2_2;
                                    }
                                    {
                                        this.$propTable = propertiesTable;
                                        this.$allPropsMap = intHashMap;
                                    }
                                });
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, added2 + " missing id pairs found and fixed for [" + this.$entityType + ']');
                            }
                            Collection collection = phantomIds;
                            boolean bl4 = false;
                            if (!collection.isEmpty()) {
                                PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).executeInTransaction(new StoreTransactionalExecutable(propTable, phantomIds){
                                    final /* synthetic */ PropertiesTable $propTable;
                                    final /* synthetic */ List $phantomIds;

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public final void execute(@NotNull StoreTransaction txn) {
                                        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                                        Store allPropsIndex = this.$propTable.getAllPropsIndex();
                                        Transaction transaction = ((PersistentStoreTransaction)txn).getEnvironmentTransaction();
                                        Intrinsics.checkExpressionValueIsNotNull((Object)transaction, (String)"(txn as PersistentStoreT\u2026n).environmentTransaction");
                                        Transaction envTxn = transaction;
                                        Closeable closeable = (Closeable)allPropsIndex.openCursor(envTxn);
                                        boolean bl = false;
                                        Throwable throwable = null;
                                        try {
                                            Cursor c = (Cursor)closeable;
                                            boolean bl2 = false;
                                            for (Pair phantom : this.$phantomIds) {
                                                if (!c.getSearchBoth((ByteIterable)IntegerBinding.intToCompressedEntry((int)((Number)phantom.getFirst()).intValue()), (ByteIterable)LongBinding.longToCompressedEntry((long)((Number)phantom.getSecond()).longValue()))) continue;
                                                c.deleteCurrent();
                                            }
                                            Unit unit = Unit.INSTANCE;
                                        }
                                        catch (Throwable throwable2) {
                                            throwable = throwable2;
                                            throw throwable2;
                                        }
                                        finally {
                                            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                                        }
                                    }
                                    {
                                        this.$propTable = propertiesTable;
                                        this.$phantomIds = list;
                                    }
                                });
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, phantomIds.size() + " phantom id pairs found and fixed for [" + this.$entityType + ']');
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$txn = persistentStoreTransaction;
                            this.$entityType = string;
                        }
                    });
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
            }
        });
    }

    public final void refactorFixNegativeFloatAndDoubleProps(@NotNull Store settings) {
        Intrinsics.checkParameterIsNotNull((Object)settings, (String)"settings");
        this.store.executeInReadonlyTransaction(new StoreTransactionalExecutable(this, settings){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;
            final /* synthetic */ Store $settings;

            public final void execute(@NotNull StoreTransaction tx) {
                Intrinsics.checkParameterIsNotNull((Object)tx, (String)"tx");
                List<String> list = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getEntityTypes((PersistentStoreTransaction)tx);
                Intrinsics.checkExpressionValueIsNotNull(list, (String)"store.getEntityTypes(tx \u2026rsistentStoreTransaction)");
                for (String entityType : CollectionsKt.toList((Iterable)list)) {
                    PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).executeInTransaction(new StoreTransactionalExecutable(this, entityType){
                        final /* synthetic */ refactorFixNegativeFloatAndDoubleProps.1 this$0;
                        final /* synthetic */ String $entityType;

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * WARNING - void declaration
                         */
                        public final void execute(@NotNull StoreTransaction t) {
                            boolean bl;
                            Intrinsics.checkParameterIsNotNull((Object)t, (String)"t");
                            PersistentStoreTransaction txn = (PersistentStoreTransaction)t;
                            if (Intrinsics.areEqual((Object)Settings.get(txn.getEnvironmentTransaction(), this.this$0.$settings, "refactorFixNegativeFloatAndDoubleProps(" + this.$entityType + ") applied"), (Object)"y")) {
                                return;
                            }
                            jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, "Refactoring fixing negative float & double props for [" + this.$entityType + ']');
                            int entityTypeId = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getEntityTypeId(txn, this.$entityType, false);
                            PropertiesTable propertiesTable = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getPropertiesTable(txn, entityTypeId);
                            Intrinsics.checkExpressionValueIsNotNull((Object)propertiesTable, (String)"store.getPropertiesTable(txn, entityTypeId)");
                            PropertiesTable propTable = propertiesTable;
                            HashMap<K, V> props = new HashMap<K, V>();
                            PropertyTypes propertyTypes = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getPropertyTypes();
                            Intrinsics.checkExpressionValueIsNotNull((Object)propertyTypes, (String)"store.propertyTypes");
                            PropertyTypes propertyTypes2 = propertyTypes;
                            Object object = (Closeable)PersistentEntityStoreRefactorings.access$getStore$p(this.this$0.this$0).getPrimaryPropertyIndexCursor(txn, propTable);
                            boolean bl2 = false;
                            Iterator<T> iterator = null;
                            try {
                                Cursor cursor = (Cursor)object;
                                boolean bl3 = false;
                                while (true) {
                                    Cursor cursor2 = cursor;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                                    if (!cursor2.getNext()) break;
                                    try {
                                        ComparableValueType propertyType;
                                        ArrayByteIterable arrayByteIterable = new ArrayByteIterable(cursor.getValue());
                                        boolean bl4 = false;
                                        bl = false;
                                        ArrayByteIterable it = arrayByteIterable;
                                        boolean bl5 = false;
                                        byte by = it.iterator().next();
                                        byte by2 = (byte)128;
                                        PropertyTypes propertyTypes3 = propertyTypes2;
                                        boolean bl6 = false;
                                        byte by3 = (byte)(by ^ by2);
                                        Intrinsics.checkExpressionValueIsNotNull((Object)propertyTypes3.getPropertyType(by3), (String)"propertyTypes.getPropert\u2026(0x80).toByte()).toInt())");
                                        switch (propertyType.getTypeId()) {
                                            case 7: {
                                                Map map = props;
                                                PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                                Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey, (String)"PropertyKey.entryToPropertyKey(cursor.key)");
                                                map.put(propertyKey, TuplesKt.to((Object)propertyTypes2.entryToPropertyValue((ByteIterable)it, (ComparableBinding)FloatBinding.BINDING), (Object)it));
                                                break;
                                            }
                                            case 3: {
                                                Map map = props;
                                                PropertyKey propertyKey = PropertyKey.entryToPropertyKey(cursor.getKey());
                                                Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey, (String)"PropertyKey.entryToPropertyKey(cursor.key)");
                                                map.put(propertyKey, TuplesKt.to((Object)propertyTypes2.entryToPropertyValue((ByteIterable)it, (ComparableBinding)DoubleBinding.BINDING), (Object)it));
                                                break;
                                            }
                                        }
                                    }
                                    catch (Throwable throwable) {}
                                }
                                cursor = Unit.INSTANCE;
                            }
                            catch (Throwable cursor) {
                                iterator = cursor;
                                throw cursor;
                            }
                            finally {
                                CloseableKt.closeFinally((Closeable)object, (Throwable)((Object)iterator));
                            }
                            object = props;
                            bl2 = false;
                            if (!object.isEmpty()) {
                                Set<K> set = props.keySet();
                                Intrinsics.checkExpressionValueIsNotNull(set, (String)"props.keys");
                                Iterable $this$sortedBy$iv = set;
                                boolean $i$f$sortedBy = false;
                                iterator = $this$sortedBy$iv;
                                boolean cursor = false;
                                Comparator bl3 = new Comparator<T>(){

                                    public final int compare(T a, T b) {
                                        boolean bl = false;
                                        PropertyKey it = (PropertyKey)a;
                                        boolean bl2 = false;
                                        PropertyKey propertyKey = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey, (String)"it");
                                        it = (PropertyKey)b;
                                        Comparable comparable = Long.valueOf(propertyKey.getEntityLocalId());
                                        bl2 = false;
                                        PropertyKey propertyKey2 = it;
                                        Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey2, (String)"it");
                                        Long l = propertyKey2.getEntityLocalId();
                                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)l);
                                    }
                                };
                                Iterable $this$forEach$iv = CollectionsKt.sortedWith((Iterable)((Object)iterator), (Comparator)bl3);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    void propValue;
                                    Pair pair;
                                    PropertyKey key = (PropertyKey)element$iv;
                                    boolean bl7 = false;
                                    if ((Pair)props.get(key) == null) continue;
                                    bl = false;
                                    boolean bl8 = false;
                                    Pair $dstr$propValue$it = pair;
                                    boolean bl9 = false;
                                    PropertyValue propertyValue = (PropertyValue)$dstr$propValue$it.component1();
                                    ByteIterable it = (ByteIterable)$dstr$propValue$it.component2();
                                    PropertyKey propertyKey = key;
                                    Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey, (String)"key");
                                    propTable.put(txn, propertyKey.getEntityLocalId(), (ByteIterable)PropertyTypes.propertyValueToEntry((PropertyValue)propValue), it, key.getPropertyId(), propValue.getType());
                                }
                                jetbrains.exodus.entitystore.PersistentEntityStoreRefactorings$Companion.access$logInfo(PersistentEntityStoreRefactorings.Companion, props.size() + " negative float & double props fixed.");
                            }
                            Settings.set(txn.getEnvironmentTransaction(), this.this$0.$settings, "refactorFixNegativeFloatAndDoubleProps(" + this.$entityType + ") applied", "y");
                        }
                        {
                            this.this$0 = var1_1;
                            this.$entityType = string;
                        }
                    });
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
                this.$settings = store;
            }
        });
    }

    public final void refactorRemoveHistoryStores() {
        Environment environment = this.store.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"store.environment");
        Environment environment2 = environment;
        environment2.executeInReadonlyTransaction(new TransactionalExecutable(this, environment2){
            final /* synthetic */ PersistentEntityStoreRefactorings this$0;
            final /* synthetic */ Environment $environment;

            public final void execute(@NotNull Transaction txn) {
                Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                String string = PersistentEntityStoreRefactorings.access$getStore$p(this.this$0).getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"store.name");
                String persistentStoreName = string;
                Iterator<E> iterator = this.$environment.getAllStoreNames(txn).iterator();
                while (iterator.hasNext()) {
                    String storeName;
                    String string2 = storeName = (String)iterator.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"storeName");
                    if (!StringsKt.startsWith$default((String)string2, (String)persistentStoreName, (boolean)false, (int)2, null) || !StringsKt.endsWith$default((String)storeName, (String)"#history", (boolean)false, (int)2, null)) continue;
                    this.$environment.executeInTransaction(new TransactionalExecutable(this, storeName){
                        final /* synthetic */ refactorRemoveHistoryStores.1 this$0;
                        final /* synthetic */ String $storeName;

                        public final void execute(@NotNull Transaction txn) {
                            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                            this.this$0.$environment.removeStore(this.$storeName, txn);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$storeName = string;
                        }
                    });
                }
            }
            {
                this.this$0 = persistentEntityStoreRefactorings;
                this.$environment = environment;
            }
        });
    }

    private final void safeExecuteRefactoringForEntityType(String entityType, StoreTransactionalExecutable executable) {
        try {
            this.store.executeInTransaction(executable);
        }
        catch (Throwable t) {
            Companion.getLogger().error("Failed to execute refactoring for entity type: " + entityType, t);
            PersistentEntityStoreRefactorings.Companion.throwJVMError(t);
        }
    }

    private final void safeExclusiveExecuteRefactoringForEntityType(String entityType, StoreTransactionalExecutable executable) {
        try {
            this.store.executeInTransaction(executable);
        }
        catch (Throwable t) {
            Companion.getLogger().error("Failed to execute refactoring for entity type: " + entityType, t);
            PersistentEntityStoreRefactorings.Companion.throwJVMError(t);
        }
    }

    private final void transactionalCopyAndRemoveEntitiesStore(String sourceName, String targetName) {
        Environment environment = this.store.getEnvironment();
        Intrinsics.checkExpressionValueIsNotNull((Object)environment, (String)"store.environment");
        Environment env = environment;
        env.executeInTransaction(new TransactionalExecutable(env, sourceName, targetName){
            final /* synthetic */ Environment $env;
            final /* synthetic */ String $sourceName;
            final /* synthetic */ String $targetName;

            public final void execute(@NotNull Transaction txn) {
                Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
                Store store = this.$env.openStore(this.$sourceName, StoreConfig.USE_EXISTING, txn);
                Intrinsics.checkExpressionValueIsNotNull((Object)store, (String)"env.openStore(sourceName\u2026Config.USE_EXISTING, txn)");
                Store store2 = store;
                Store store3 = this.$env.openStore(this.$targetName, StoreConfig.WITHOUT_DUPLICATES_WITH_PREFIXING, txn);
                Intrinsics.checkExpressionValueIsNotNull((Object)store3, (String)"env.openStore(targetName\u2026ATES_WITH_PREFIXING, txn)");
                Store storeCopy = store3;
                Cursor cursor = store2.openCursor(txn);
                ArrayByteIterable lastKey = null;
                while (true) {
                    Cursor cursor2 = cursor;
                    Intrinsics.checkExpressionValueIsNotNull((Object)cursor2, (String)"cursor");
                    if (!cursor2.getNext()) break;
                    ArrayByteIterable key = new ArrayByteIterable(cursor.getKey());
                    if (lastKey != null && lastKey.compareTo((ByteIterable)key) >= 0) {
                        throw (Throwable)new IllegalStateException("Invalid key order");
                    }
                    storeCopy.putRight(txn, (ByteIterable)key, (ByteIterable)new ArrayByteIterable(cursor.getValue()));
                    lastKey = key;
                }
                cursor.close();
                this.$env.removeStore(this.$sourceName, txn);
            }
            {
                this.$env = environment;
                this.$sourceName = string;
                this.$targetName = string2;
            }
        });
    }

    public PersistentEntityStoreRefactorings(@NotNull PersistentEntityStoreImpl store) {
        Intrinsics.checkParameterIsNotNull((Object)store, (String)"store");
        this.store = store;
    }

    public static final /* synthetic */ PersistentEntityStoreImpl access$getStore$p(PersistentEntityStoreRefactorings $this) {
        return $this.store;
    }

    public static final /* synthetic */ void access$transactionalCopyAndRemoveEntitiesStore(PersistentEntityStoreRefactorings $this, String sourceName, String targetName) {
        $this.transactionalCopyAndRemoveEntitiesStore(sourceName, targetName);
    }

    public static final /* synthetic */ void access$safeExecuteRefactoringForEntityType(PersistentEntityStoreRefactorings $this, String entityType, StoreTransactionalExecutable executable) {
        $this.safeExecuteRefactoringForEntityType(entityType, executable);
    }

    public static final /* synthetic */ void access$safeExclusiveExecuteRefactoringForEntityType(PersistentEntityStoreRefactorings $this, String entityType, StoreTransactionalExecutable executable) {
        $this.safeExclusiveExecuteRefactoringForEntityType(entityType, executable);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Ljetbrains/exodus/entitystore/PersistentEntityStoreRefactorings$Companion;", "Lmu/KLogging;", "()V", "deletePair", "", "c", "Ljetbrains/exodus/env/Cursor;", "key", "Ljetbrains/exodus/ByteIterable;", "value", "logInfo", "message", "", "runReadonlyTransactionSafeForEntityType", "entityType", "runnable", "Ljava/lang/Runnable;", "throwJVMError", "t", "", "xodus-entity-store"})
    public static final class Companion
    extends KLogging {
        private final void runReadonlyTransactionSafeForEntityType(String entityType, Runnable runnable) {
            try {
                runnable.run();
            }
            catch (ReadonlyTransactionException readonlyTransactionException) {
            }
            catch (Throwable t) {
                this.getLogger().error("Failed to execute refactoring for entity type: " + entityType, t);
                this.throwJVMError(t);
            }
        }

        private final void deletePair(Cursor c, ByteIterable key, ByteIterable value) {
            if (c.getSearchBoth(key, value)) {
                c.deleteCurrent();
            }
            c.close();
        }

        private final void throwJVMError(Throwable t) {
            if (t instanceof VirtualMachineError) {
                throw (Throwable)new EntityStoreException(t);
            }
        }

        private final void logInfo(String message) {
            if (this.getLogger().isInfoEnabled()) {
                this.getLogger().info(message);
            }
        }

        private Companion() {
        }

        public static final /* synthetic */ void access$runReadonlyTransactionSafeForEntityType(Companion $this, String entityType, Runnable runnable) {
            $this.runReadonlyTransactionSafeForEntityType(entityType, runnable);
        }

        public static final /* synthetic */ void access$deletePair(Companion $this, Cursor c, ByteIterable key, ByteIterable value) {
            $this.deletePair(c, key, value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

