/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DistinctIterable
extends EntityIterableDecoratorBase {
    public DistinctIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source) {
        super(txn, source);
    }

    public static EntityIterableType getType() {
        return EntityIterableType.DISTINCT;
    }

    @Override
    public boolean isSortedById() {
        return this.source.isSortedById();
    }

    @Override
    @NotNull
    public EntityIterable distinct() {
        return this;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorFixingDecorator(this, this.isSortedById() ? new DistinctSortedIterator(this, this.source) : new DistinctUnsortedIterator(this, this.source));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), DistinctIterable.getType(), this.source.getHandle()){

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
            }
        };
    }

    static {
        DistinctIterable.registerType(DistinctIterable.getType(), (txn, store, parameters) -> new DistinctIterable(txn, (EntityIterableBase)parameters[0]));
    }

    private static final class DistinctUnsortedIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final EntityIterator source;
        @NotNull
        private EntityIdSet iterated;
        @Nullable
        private EntityId nextId;

        private DistinctUnsortedIterator(@NotNull DistinctIterable iterable, @NotNull EntityIterable source) {
            super(iterable);
            this.source = source.iterator();
            this.iterated = EntityIdSetFactory.newSet();
        }

        @Override
        protected boolean hasNextImpl() {
            while (this.source.hasNext()) {
                EntityId id = this.source.nextId();
                if (this.iterated.contains(id)) continue;
                this.nextId = id;
                this.iterated = this.iterated.add(id);
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }

        @Override
        @Nullable
        protected EntityIdSet toSet() {
            return this.iterated;
        }
    }

    private static final class DistinctSortedIterator
    extends NonDisposableEntityIterator {
        @NotNull
        private final EntityIterator source;
        @Nullable
        private EntityId nextId;

        private DistinctSortedIterator(@NotNull DistinctIterable iterable, @NotNull EntityIterable source) {
            super(iterable);
            this.source = source.iterator();
        }

        @Override
        protected boolean hasNextImpl() {
            while (this.source.hasNext()) {
                EntityId id = this.source.nextId();
                if (this.nextId == null) {
                    if (id == null) continue;
                    this.nextId = id;
                    return true;
                }
                if (id != null && id.equals(this.nextId)) continue;
                this.nextId = id;
                return true;
            }
            return false;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            return this.nextId;
        }
    }
}

