/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;

public class EntitiesWithBlobIterable
extends EntityIterableBase {
    private final int entityTypeId;
    private final int blobId;

    public EntitiesWithBlobIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int blobId) {
        super(txn);
        this.entityTypeId = entityTypeId;
        this.blobId = blobId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ENTITIES_WITH_BLOB;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    @Override
    @NotNull
    public EntityIterator getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new BlobsIterator(this.getStore().getEntityWithBlobCursor(txn, this.entityTypeId));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntitiesWithBlobIterableHandle();
    }

    static {
        EntitiesWithBlobIterable.registerType(EntitiesWithBlobIterable.getType(), (txn, store, parameters) -> new EntitiesWithBlobIterable(txn, Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1])));
    }

    public final class BlobsIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        public BlobsIterator(Cursor cursor) {
            super(EntitiesWithBlobIterable.this);
            this.setCursor(cursor);
            this.hasNext = cursor.getSearchKey((ByteIterable)IntegerBinding.intToCompressedEntry((int)EntitiesWithBlobIterable.this.blobId)) != null;
        }

        @Override
        protected boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        protected EntityId nextIdImpl() {
            if (this.hasNext) {
                EntitiesWithBlobIterable.this.explain(EntitiesWithBlobIterable.getType());
                Cursor cursor = this.getCursor();
                long localId = LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue());
                PersistentEntityId result = new PersistentEntityId(EntitiesWithBlobIterable.this.entityTypeId, localId);
                this.hasNext = cursor.getNextDup();
                return result;
            }
            return null;
        }
    }

    private final class EntitiesWithBlobIterableHandle
    extends ConstantEntityIterableHandle {
        private EntitiesWithBlobIterableHandle() {
            super(EntitiesWithBlobIterable.this.getStore(), EntitiesWithBlobIterable.getType());
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            super.toString(builder);
            builder.append(EntitiesWithBlobIterable.this.entityTypeId);
            builder.append('-');
            builder.append(EntitiesWithBlobIterable.this.blobId);
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            hash.apply(EntitiesWithBlobIterable.this.entityTypeId);
            hash.applyDelimiter();
            hash.apply(EntitiesWithBlobIterable.this.blobId);
        }

        @Override
        public int getEntityTypeId() {
            return EntitiesWithBlobIterable.this.entityTypeId;
        }
    }
}

