/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.IntegerBinding;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntitiesWithLinkIterable
extends EntityIterableBase {
    private final int entityTypeId;
    private final int linkId;

    public EntitiesWithLinkIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int linkId) {
        super(txn);
        this.entityTypeId = entityTypeId;
        this.linkId = linkId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ENTITIES_WITH_LINK;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    public boolean isSortedById() {
        return true;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new LinksIterator(this.openCursor(txn));
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntitiesWithLinkIterableHandle();
    }

    private Cursor openCursor(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getEntityWithLinkCursor(txn, this.entityTypeId);
    }

    static {
        EntitiesWithLinkIterable.registerType(EntitiesWithLinkIterable.getType(), (txn, store, parameters) -> new EntitiesWithLinkIterable(txn, Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1])));
    }

    protected class EntitiesWithLinkIterableHandle
    extends ConstantEntityIterableHandle {
        public EntitiesWithLinkIterableHandle() {
            super(EntitiesWithLinkIterable.this.getStore(), EntitiesWithLinkIterable.getType());
        }

        @Override
        @NotNull
        public int[] getLinkIds() {
            return new int[]{EntitiesWithLinkIterable.this.linkId};
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            super.toString(builder);
            builder.append(EntitiesWithLinkIterable.this.entityTypeId);
            builder.append('-');
            builder.append(EntitiesWithLinkIterable.this.linkId);
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            hash.apply(EntitiesWithLinkIterable.this.entityTypeId);
            hash.applyDelimiter();
            hash.apply(EntitiesWithLinkIterable.this.linkId);
        }

        @Override
        public int getEntityTypeId() {
            return EntitiesWithLinkIterable.this.entityTypeId;
        }

        @Override
        public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
            return EntitiesWithLinkIterable.this.entityTypeId == source.getTypeId();
        }

        @Override
        public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
            return EntitiesWithLinkIterable.this.entityTypeId == source.getTypeId();
        }
    }

    private final class LinksIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        private LinksIterator(Cursor index2) {
            super(EntitiesWithLinkIterable.this);
            this.setCursor(index2);
            ArrayByteIterable key = IntegerBinding.intToCompressedEntry((int)EntitiesWithLinkIterable.this.linkId);
            this.hasNext = index2.getSearchKey((ByteIterable)key) != null;
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                EntitiesWithLinkIterable.this.explain(EntitiesWithLinkIterable.getType());
                Cursor cursor = this.getCursor();
                long localId = LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue());
                PersistentEntityId result = new PersistentEntityId(EntitiesWithLinkIterable.this.entityTypeId, localId);
                this.hasNext = cursor.getNextDup();
                return result;
            }
            return null;
        }
    }
}

