/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EntityIterableHandleDecorator
extends EntityIterableHandleBase {
    @NotNull
    protected final EntityIterableHandleBase decorated;

    protected EntityIterableHandleDecorator(@Nullable PersistentEntityStore store, @NotNull EntityIterableType type, @NotNull EntityIterableHandle decorated) {
        super(store, type);
        this.decorated = (EntityIterableHandleBase)decorated;
    }

    @Override
    @NotNull
    public int[] getLinkIds() {
        return this.decorated.getLinkIds();
    }

    @Override
    @NotNull
    public int[] getPropertyIds() {
        return this.decorated.getPropertyIds();
    }

    @Override
    @NotNull
    public int[] getTypeIdsAffectingCreation() {
        return this.decorated.getTypeIdsAffectingCreation();
    }

    @Override
    public boolean isMatchedEntityAdded(@NotNull EntityId added2) {
        return this.decorated.isMatchedEntityAdded(added2);
    }

    @Override
    public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
        return this.decorated.isMatchedEntityDeleted(deleted);
    }

    @Override
    public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
        return this.decorated.isMatchedLinkAdded(source, target, linkId);
    }

    @Override
    public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
        return this.decorated.isMatchedLinkDeleted(source, target, linkId);
    }

    @Override
    public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
        return this.decorated.isMatchedPropertyChanged(id, propertyId, oldValue, newValue);
    }

    @Override
    public boolean isConsistent() {
        return this.decorated.isConsistent();
    }

    @Override
    public boolean isExpired() {
        return this.decorated.isExpired();
    }

    @Override
    public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
        hash.apply(this.decorated);
    }

    protected void applyDecoratedToBuilder(@NotNull StringBuilder builder) {
        this.decorated.toString(builder);
    }
}

