/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntity;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityLinksIterableBase;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorCounter;
import jetbrains.exodus.entitystore.iterate.SingleKeyCursorIsEmptyChecker;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.env.Cursor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityToLinksIterable
extends EntityLinksIterableBase {
    private final int entityTypeId;
    private final int linkId;

    public EntityToLinksIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityId entityId, int entityTypeId, int linkId) {
        super(txn, entityId);
        this.entityTypeId = entityTypeId;
        this.linkId = linkId;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.ENTITY_TO_LINKS;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new LinksIterator(this.openCursor(txn));
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new ConstantEntityIterableHandle(this.getStore(), EntityToLinksIterable.getType()){

            @Override
            @NotNull
            public int[] getLinkIds() {
                return new int[]{EntityToLinksIterable.this.linkId};
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                ((PersistentEntityId)EntityToLinksIterable.this.entityId).toString(builder);
                builder.append('-');
                builder.append(EntityToLinksIterable.this.entityTypeId);
                builder.append('-');
                builder.append(EntityToLinksIterable.this.linkId);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                ((PersistentEntityId)EntityToLinksIterable.this.entityId).toHash(hash);
                hash.applyDelimiter();
                hash.apply(EntityToLinksIterable.this.entityTypeId);
                hash.applyDelimiter();
                hash.apply(EntityToLinksIterable.this.linkId);
            }

            @Override
            public int getEntityTypeId() {
                return EntityToLinksIterable.this.entityTypeId;
            }

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return EntityToLinksIterable.this.entityTypeId == source.getTypeId() && EntityToLinksIterable.this.entityId.equals(target);
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return this.isMatchedLinkAdded(source, target, linkId);
            }
        };
    }

    @Override
    @Nullable
    public Entity getLast() {
        PersistentStoreTransaction txn = this.getStore().getAndCheckCurrentTransaction();
        try (Cursor cursor = this.openCursor(txn);){
            LinkValue key;
            if (cursor.getSearchKeyRange(this.getKey(new PersistentEntityId(this.entityId.getTypeId(), this.entityId.getLocalId() + 1L))) == null) {
                if (!cursor.getLast()) {
                    Entity entity = null;
                    return entity;
                }
            } else if (!cursor.getPrev()) {
                Entity entity = null;
                return entity;
            }
            if (!(key = LinkValue.entryToLinkValue(cursor.getKey())).getEntityId().equals(this.entityId) || key.getLinkId() != this.linkId) {
                Entity entity = null;
                return entity;
            }
            PersistentEntity persistentEntity = txn.getEntity(new PersistentEntityId(this.entityTypeId, PropertyKey.entryToPropertyKey(cursor.getValue()).getEntityLocalId()));
            return persistentEntity;
        }
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        return new SingleKeyCursorCounter(this.openCursor(txn), this.getFirstKey()).getCount();
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        return new SingleKeyCursorIsEmptyChecker(this.openCursor(txn), this.getFirstKey()).isEmpty();
    }

    private Cursor openCursor(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getLinksSecondIndexCursor(txn, this.entityTypeId);
    }

    private ByteIterable getFirstKey() {
        return this.getKey(this.entityId);
    }

    private ByteIterable getKey(EntityId entityId) {
        return LinkValue.linkValueToEntry(new LinkValue(entityId, this.linkId));
    }

    static {
        EntityToLinksIterable.registerType(EntityToLinksIterable.getType(), (txn, store, parameters) -> new EntityToLinksIterable(txn, new PersistentEntityId(Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1])), Integer.parseInt((String)parameters[2]), Integer.parseInt((String)parameters[3])));
    }

    private final class LinksIterator
    extends EntityIteratorBase {
        private boolean hasNext;

        private LinksIterator(Cursor index2) {
            super(EntityToLinksIterable.this);
            this.setCursor(index2);
            this.hasNext = index2.getSearchKey(EntityToLinksIterable.this.getFirstKey()) != null;
        }

        @Override
        public boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                EntityToLinksIterable.this.explain(EntityToLinksIterable.getType());
                Cursor cursor = this.getCursor();
                PersistentEntityId result = new PersistentEntityId(EntityToLinksIterable.this.entityTypeId, PropertyKey.entryToPropertyKey(cursor.getValue()).getEntityLocalId());
                this.hasNext = cursor.getNextDup();
                return result;
            }
            return null;
        }
    }
}

