/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.bindings.ComparableBinding;
import jetbrains.exodus.bindings.ComparableSet;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.CachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.ConstantEntityIterableHandle;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.PropertyChangedHandleChecker;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.exodus.entitystore.iterate.UpdatablePropertiesCachedInstanceIterable;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.tables.PropertyValue;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.Store;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesIterable
extends EntityIterableBase {
    private final int entityTypeId;
    private final int propertyId;

    private static EntityIterableType getType() {
        return EntityIterableType.ENTITIES_WITH_PROPERTY_SORTED_BY_VALUE;
    }

    @Override
    public int getEntityTypeId() {
        return this.entityTypeId;
    }

    public PropertiesIterable(@NotNull PersistentStoreTransaction txn, int entityTypeId, int propertyId) {
        super(txn);
        this.entityTypeId = entityTypeId;
        this.propertyId = propertyId;
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        PropertiesIterator result = this.getIterator(txn, true);
        if (result == null) {
            return EntityIteratorBase.EMPTY;
        }
        return result;
    }

    @Override
    public boolean nonCachedHasFastCountAndIsEmpty() {
        return true;
    }

    @Override
    @NotNull
    public EntityIterator getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        PropertiesIterator result = this.getIterator(txn, false);
        if (result == null) {
            return EntityIteratorBase.EMPTY;
        }
        return result;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new PropertiesIterableHandle();
    }

    @Override
    protected CachedInstanceIterable createCachedInstance(@NotNull PersistentStoreTransaction txn) {
        return UpdatablePropertiesCachedInstanceIterable.newInstance(txn, this.getIterator(txn, true), this);
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Store valueIndex = this.getStore().getPropertiesTable(txn, this.entityTypeId).getValueIndex(txn, this.propertyId, false);
        return valueIndex == null ? 0L : valueIndex.count(txn.getEnvironmentTransaction());
    }

    @Override
    public boolean isEmptyImpl(@NotNull PersistentStoreTransaction txn) {
        return this.countImpl(txn) == 0L;
    }

    private Cursor openCursor(@NotNull PersistentStoreTransaction txn) {
        return this.getStore().getPropertyValuesIndexCursor(txn, this.entityTypeId, this.propertyId);
    }

    private PropertiesIterator getIterator(@NotNull PersistentStoreTransaction txn, boolean ascending) {
        try (Cursor primaryIndex = this.getStore().getPrimaryPropertyIndexCursor(txn, this.entityTypeId);){
            Cursor valueIdx = this.openCursor(txn);
            if (valueIdx == null) {
                PropertiesIterator propertiesIterator = null;
                return propertiesIterator;
            }
            PropertiesIterator propertiesIterator = new PropertiesIterator(valueIdx, primaryIndex, ascending);
            return propertiesIterator;
        }
    }

    static {
        PropertiesIterable.registerType(PropertiesIterable.getType(), (txn, store, parameters) -> new PropertiesIterable(txn, Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1])));
    }

    private final class PropertiesIterator
    extends EntityIteratorBase
    implements PropertyValueIterator {
        private boolean hasNext;
        private final boolean ascending;
        private final ComparableBinding binding;
        @Nullable
        private ByteIterable currentCursorKey;
        @Nullable
        private Comparable currentValue;

        private PropertiesIterator(@NotNull Cursor secondaryIndex, Cursor primaryIndex, boolean ascending) {
            super(PropertiesIterable.this);
            this.setCursor(secondaryIndex);
            this.ascending = ascending;
            this.hasNext = this.getNext(secondaryIndex);
            if (this.hasNext) {
                long entityLocalId = LongBinding.compressedEntryToLong((ByteIterable)secondaryIndex.getValue());
                ByteIterable value = primaryIndex.getSearchKey((ByteIterable)PropertyKey.propertyKeyToEntry(new PropertyKey(entityLocalId, PropertiesIterable.this.propertyId)));
                this.hasNext = value != null;
                if (this.hasNext) {
                    PropertyValue propertyValue = this.getStore().getPropertyTypes().entryToPropertyValue(value);
                    if (propertyValue.getType().getTypeId() != 8) {
                        this.binding = propertyValue.getBinding();
                    } else {
                        Class itemClass = ((ComparableSet)propertyValue.getData()).getItemClass();
                        if (itemClass == null) {
                            throw new NullPointerException("Can't be: null item class for a non-empty ComparableSet");
                        }
                        this.binding = this.getStore().getPropertyTypes().getPropertyType(itemClass).getBinding();
                    }
                } else {
                    this.binding = null;
                }
            } else {
                this.binding = null;
            }
        }

        @Override
        public boolean hasNextImpl() {
            if (this.hasNext) {
                ByteIterable key = this.getCursor().getKey();
                if (key != this.currentCursorKey) {
                    this.currentValue = this.binding.entryToObject(key);
                    this.currentCursorKey = key;
                }
            } else {
                this.currentValue = null;
                this.currentCursorKey = null;
            }
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                PropertiesIterable.this.explain(PropertiesIterable.getType());
                Cursor cursor = this.getCursor();
                PersistentEntityId result = new PersistentEntityId(PropertiesIterable.this.entityTypeId, LongBinding.compressedEntryToLong((ByteIterable)cursor.getValue()));
                this.hasNext = this.getNext(cursor);
                return result;
            }
            return null;
        }

        @Override
        @Nullable
        public Comparable currentValue() {
            return this.currentValue;
        }

        private boolean getNext(@NotNull Cursor cursor) {
            return this.ascending ? cursor.getNext() : cursor.getPrev();
        }
    }

    private final class PropertiesIterableHandle
    extends ConstantEntityIterableHandle {
        public PropertiesIterableHandle() {
            super(PropertiesIterable.this.getStore(), PropertiesIterable.getType());
        }

        @Override
        @NotNull
        public int[] getPropertyIds() {
            return new int[]{PropertiesIterable.this.propertyId};
        }

        @Override
        public void toString(@NotNull StringBuilder builder) {
            super.toString(builder);
            builder.append(PropertiesIterable.this.entityTypeId);
            builder.append('-');
            builder.append(PropertiesIterable.this.propertyId);
        }

        @Override
        public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
            hash.apply(PropertiesIterable.this.entityTypeId);
            hash.applyDelimiter();
            hash.apply(PropertiesIterable.this.propertyId);
        }

        @Override
        public int getEntityTypeId() {
            return PropertiesIterable.this.entityTypeId;
        }

        @Override
        public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
            return PropertiesIterable.this.propertyId == propertyId && PropertiesIterable.this.entityTypeId == id.getTypeId();
        }

        @Override
        public boolean onPropertyChanged(@NotNull PropertyChangedHandleChecker handleChecker) {
            UpdatablePropertiesCachedInstanceIterable iterable = PersistentStoreTransaction.getUpdatable(handleChecker, this, UpdatablePropertiesCachedInstanceIterable.class);
            if (iterable != null) {
                Comparable oldValue = handleChecker.getOldValue();
                Comparable newValue = handleChecker.getNewValue();
                long localId = handleChecker.getLocalId();
                if (oldValue instanceof ComparableSet || newValue instanceof ComparableSet) {
                    ComparableSet oldSet = (ComparableSet)oldValue;
                    ComparableSet newSet = (ComparableSet)newValue;
                    if (oldSet != null) {
                        for (Comparable item : oldSet.minus(newSet)) {
                            iterable.update(PropertiesIterable.this.entityTypeId, localId, item, null);
                        }
                    }
                    if (newSet != null) {
                        for (Comparable item : newSet.minus(oldSet)) {
                            iterable.update(PropertiesIterable.this.entityTypeId, localId, null, item);
                        }
                    }
                } else {
                    iterable.update(PropertiesIterable.this.entityTypeId, localId, oldValue, newValue);
                }
                return true;
            }
            return false;
        }
    }
}

