/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Map;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.core.dataStructures.hash.IntHashMap;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIdSet;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.SelectManyIterable;
import jetbrains.exodus.entitystore.iterate.SourceMappingIterator;
import jetbrains.exodus.entitystore.tables.LinkValue;
import jetbrains.exodus.entitystore.tables.PropertyKey;
import jetbrains.exodus.entitystore.util.EntityIdSetFactory;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.util.LightOutputStream;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0014J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectManyIterable;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableDecoratorBase;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "source", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "linkId", "", "distinct", "", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;IZ)V", "canBeCached", "getHandleImpl", "Ljetbrains/exodus/entitystore/EntityIterableHandle;", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "Companion", "SelectManyDistinctIterator", "xodus-entity-store"})
public final class SelectManyIterable
extends EntityIterableDecoratorBase {
    private final int linkId;
    private final boolean distinct;
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean canBeCached() {
        return this.distinct;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return new SelectManyDistinctIterator(txn);
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        PersistentEntityStore persistentEntityStore = this.getStore();
        EntityIterableType entityIterableType = Companion.getType();
        EntityIterableBase entityIterableBase = this.source;
        Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableBase, (String)"source");
        return new EntityIterableHandleDecorator(this, persistentEntityStore, entityIterableType, entityIterableBase.getHandle()){
            private final int[] linkIds;
            final /* synthetic */ SelectManyIterable this$0;

            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            public void toString(@NotNull StringBuilder builder) {
                Intrinsics.checkParameterIsNotNull((Object)builder, (String)"builder");
                super.toString(builder);
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                builder.append(SelectManyIterable.access$getLinkId$p(this.this$0));
                builder.append('-');
                builder.append(SelectManyIterable.access$getDistinct$p(this.this$0));
            }

            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(SelectManyIterable.access$getLinkId$p(this.this$0));
                hash.applyDelimiter();
                hash.apply((byte)(SelectManyIterable.access$getDistinct$p(this.this$0) ? 1 : 0));
            }

            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                return linkId == SelectManyIterable.access$getLinkId$p(this.this$0) || this.decorated.isMatchedLinkAdded(source, target, linkId);
            }

            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
                return linkId == SelectManyIterable.access$getLinkId$p(this.this$0) || this.decorated.isMatchedLinkDeleted(source, target, linkId);
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1, $super_call_param$2, $super_call_param$3);
                int[] nArray = new int[]{SelectManyIterable.access$getLinkId$p($outer)};
                EntityIterableHandleBase entityIterableHandleBase = this.decorated;
                Intrinsics.checkExpressionValueIsNotNull((Object)entityIterableHandleBase, (String)"decorated");
                int[] nArray2 = EntityIterableHandleBase.mergeFieldIds(nArray, entityIterableHandleBase.getLinkIds());
                Intrinsics.checkExpressionValueIsNotNull((Object)nArray2, (String)"EntityIterableHandleBase\u2026nkId), decorated.linkIds)");
                this.linkIds = nArray2;
            }
        };
    }

    public SelectManyIterable(@NotNull PersistentStoreTransaction txn, @NotNull EntityIterableBase source, int linkId, boolean distinct) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        super(txn, source);
        this.linkId = linkId;
        this.distinct = distinct;
    }

    public /* synthetic */ SelectManyIterable(PersistentStoreTransaction persistentStoreTransaction, EntityIterableBase entityIterableBase, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            bl = true;
        }
        this(persistentStoreTransaction, entityIterableBase, n, bl);
    }

    static {
        EntityIterableBase.registerType(Companion.getType(), Companion.1.INSTANCE);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u000fH\u0016J\b\u0010\u0018\u001a\u00020\rH\u0016J\b\u0010\u0019\u001a\u00020\u000fH\u0014J\n\u0010\u001a\u001a\u0004\u0018\u00010\rH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectManyIterable$SelectManyDistinctIterator;", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "Ljetbrains/exodus/entitystore/iterate/SourceMappingIterator;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "(Ljetbrains/exodus/entitystore/iterate/SelectManyIterable;Ljetbrains/exodus/entitystore/PersistentStoreTransaction;)V", "auxArray", "", "auxStream", "Ljetbrains/exodus/util/LightOutputStream;", "ids", "Ljava/util/ArrayDeque;", "Lkotlin/Pair;", "Ljetbrains/exodus/entitystore/EntityId;", "idsCollected", "", "sourceIt", "srcId", "usedCursors", "Ljetbrains/exodus/core/dataStructures/hash/IntHashMap;", "Ljetbrains/exodus/env/Cursor;", "collectIds", "", "dispose", "getSourceId", "hasNextImpl", "nextIdImpl", "xodus-entity-store"})
    private final class SelectManyDistinctIterator
    extends EntityIteratorBase
    implements SourceMappingIterator {
        private final EntityIteratorBase sourceIt;
        private final IntHashMap<Cursor> usedCursors;
        private final ArrayDeque<Pair<EntityId, EntityId>> ids;
        private final LightOutputStream auxStream;
        private final int[] auxArray;
        private boolean idsCollected;
        private EntityId srcId;
        private final PersistentStoreTransaction txn;

        @Override
        protected boolean hasNextImpl() {
            if (!this.idsCollected) {
                this.idsCollected = true;
                this.collectIds();
            }
            return !this.ids.isEmpty();
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (this.hasNextImpl()) {
                Pair<EntityId, EntityId> pair = this.ids.poll();
                this.srcId = (EntityId)pair.getFirst();
                return (EntityId)pair.getSecond();
            }
            return null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean dispose() {
            this.sourceIt.disposeIfShouldBe();
            if (!super.dispose()) return false;
            Collection collection = this.usedCursors.values();
            Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"usedCursors.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Cursor it = (Cursor)element$iv;
                boolean bl = false;
                it.close();
            }
            Unit unit = Unit.INSTANCE;
            boolean bl = false;
            boolean bl2 = false;
            Unit it = unit;
            return true;
        }

        @Override
        @NotNull
        public EntityId getSourceId() {
            EntityId entityId = this.srcId;
            if (entityId == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"srcId");
            }
            return entityId;
        }

        private final void collectIds() {
            EntityIteratorBase sourceIt = this.sourceIt;
            int linkId = SelectManyIterable.this.linkId;
            if (linkId >= 0) {
                EntityIdSet usedIds;
                EntityIdSet entityIdSet = usedIds = SelectManyIterable.this.distinct ? EntityIdSetFactory.newSet() : EntityIdSetFactory.newImmutableSet();
                block0: while (sourceIt.hasNext()) {
                    EntityId sourceId;
                    if (sourceIt.nextId() == null) {
                        continue;
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)sourceId, (String)"sourceIt.nextId() ?: continue");
                    int typeId = sourceId.getTypeId();
                    Cursor cursor = (Cursor)this.usedCursors.get(typeId);
                    if (cursor == null) {
                        Cursor cursor2 = this.getStore().getLinksFirstIndexCursor(this.txn, typeId);
                        boolean bl = false;
                        boolean bl2 = false;
                        Cursor it = cursor2;
                        boolean bl3 = false;
                        ((Map)this.usedCursors).put(typeId, it);
                        Cursor cursor3 = cursor2;
                        cursor = cursor3;
                        Intrinsics.checkExpressionValueIsNotNull((Object)cursor3, (String)"store.getLinksFirstIndex\u2026sedCursors[typeId] = it }");
                    }
                    Cursor cursor4 = cursor;
                    long sourceLocalId = sourceId.getLocalId();
                    ByteIterable value = cursor4.getSearchKey((ByteIterable)PropertyKey.propertyKeyToEntry(this.auxStream, this.auxArray, sourceLocalId, linkId));
                    if (value == null) {
                        if (usedIds.contains(null)) continue;
                        Intrinsics.checkExpressionValueIsNotNull((Object)usedIds.add(null), (String)"usedIds.add(null)");
                        this.ids.add((Pair<EntityId, EntityId>)TuplesKt.to((Object)sourceId, null));
                        continue;
                    }
                    while (true) {
                        PropertyKey key;
                        EntityId nextId;
                        LinkValue linkValue;
                        ByteIterable byteIterable = value;
                        if (byteIterable == null) {
                            Intrinsics.throwNpe();
                        }
                        LinkValue linkValue2 = linkValue = LinkValue.entryToLinkValue(byteIterable);
                        Intrinsics.checkExpressionValueIsNotNull((Object)linkValue2, (String)"linkValue");
                        Intrinsics.checkExpressionValueIsNotNull((Object)linkValue2.getEntityId(), (String)"linkValue.entityId");
                        if (!usedIds.contains(nextId)) {
                            Intrinsics.checkExpressionValueIsNotNull((Object)usedIds.add(nextId), (String)"usedIds.add(nextId)");
                            this.ids.add((Pair<EntityId, EntityId>)TuplesKt.to((Object)sourceId, (Object)nextId));
                        }
                        if (!cursor4.getNext()) continue block0;
                        PropertyKey propertyKey = key = PropertyKey.entryToPropertyKey(cursor4.getKey());
                        Intrinsics.checkExpressionValueIsNotNull((Object)propertyKey, (String)"key");
                        if (propertyKey.getPropertyId() != linkId || key.getEntityLocalId() != sourceLocalId) continue block0;
                        value = cursor4.getValue();
                    }
                }
            }
        }

        public SelectManyDistinctIterator(PersistentStoreTransaction txn) {
            Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
            super(SelectManyIterable.this);
            this.txn = txn;
            EntityIterator entityIterator = SelectManyIterable.this.source.iterator();
            if (entityIterator == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.exodus.entitystore.iterate.EntityIteratorBase");
            }
            this.sourceIt = (EntityIteratorBase)entityIterator;
            this.usedCursors = new IntHashMap(6, 2.0f);
            this.ids = new ArrayDeque();
            this.auxStream = new LightOutputStream();
            this.auxArray = new int[8];
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/exodus/entitystore/iterate/SelectManyIterable$Companion;", "", "()V", "type", "Ljetbrains/exodus/entitystore/EntityIterableType;", "getType", "()Ljetbrains/exodus/entitystore/EntityIterableType;", "xodus-entity-store"})
    public static final class Companion {
        @NotNull
        public final EntityIterableType getType() {
            return EntityIterableType.SELECTMANY_DISTINCT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

