/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.IdFilter;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleEntityIterable
extends EntityIterableBase {
    @Nullable
    private final EntityId id;

    public SingleEntityIterable(@Nullable PersistentStoreTransaction txn, @Nullable EntityId id) {
        super(txn);
        this.id = id;
    }

    public static EntityIterableType getType() {
        return EntityIterableType.SINGLE_ENTITY;
    }

    @Override
    public long size() {
        return 1L;
    }

    @Override
    public long count() {
        return 1L;
    }

    @Override
    public long getRoughCount() {
        return 1L;
    }

    @Override
    public int indexOf(@NotNull Entity entity) {
        return this.indexOfImpl(entity.getId());
    }

    @Override
    public boolean canBeCached() {
        return false;
    }

    @Override
    protected int indexOfImpl(@NotNull EntityId entityId) {
        EntityId id = this.id;
        return id != null && id.equals(entityId) ? 0 : -1;
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new SingleEntityIterator(this);
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleBase(this.getStore(), SingleEntityIterable.getType()){

            @Override
            @NotNull
            public int[] getLinkIds() {
                return IdFilter.EMPTY_ID_ARRAY;
            }

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return false;
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                return false;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                EntityId id = SingleEntityIterable.this.id;
                if (id == null) {
                    builder.append("null");
                } else {
                    ((PersistentEntityId)id).toString(builder);
                }
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                EntityId id = SingleEntityIterable.this.id;
                if (id == null) {
                    hash.apply("null");
                } else {
                    ((PersistentEntityId)id).toHash(hash);
                }
            }
        };
    }

    static {
        SingleEntityIterable.registerType(SingleEntityIterable.getType(), (txn, store, parameters) -> new SingleEntityIterable(txn, new PersistentEntityId(Integer.parseInt((String)parameters[0]), Integer.parseInt((String)parameters[1]))));
    }

    private class SingleEntityIterator
    extends NonDisposableEntityIterator {
        private boolean hasNext;

        private SingleEntityIterator(EntityIterableBase iterable) {
            super(iterable);
            this.hasNext = true;
        }

        @Override
        protected boolean hasNextImpl() {
            return this.hasNext;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            EntityId id = this.hasNext ? SingleEntityIterable.this.id : null;
            this.hasNext = false;
            return id;
        }
    }
}

