/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.EntityIterator;
import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableDecoratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleDecorator;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorFixingDecorator;
import jetbrains.exodus.entitystore.iterate.FilterEntityTypeIterable;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SortIndirectIterable
extends EntityIterableDecoratorBase {
    @NotNull
    private final String entityType;
    @NotNull
    private final EntityIterableBase sortedLinks;
    @NotNull
    private final String linkName;
    private final int sourceTypeId;
    private final int linkId;
    @Nullable
    private final String oppositeEntityType;
    @Nullable
    private final String oppositeLinkName;

    public SortIndirectIterable(@NotNull PersistentStoreTransaction txn, @NotNull PersistentEntityStoreImpl store, @NotNull String entityType, @NotNull EntityIterableBase sortedLinks, @NotNull String linkName, @NotNull EntityIterableBase source, @Nullable String oppositeEntityType, @Nullable String oppositeLinkName) {
        super(txn, source);
        this.entityType = entityType;
        this.sortedLinks = sortedLinks;
        this.linkName = linkName;
        this.sourceTypeId = store.getEntityTypeId(txn, entityType, false);
        this.linkId = store.getLinkId(txn, linkName, false);
        this.oppositeEntityType = oppositeEntityType;
        this.oppositeLinkName = oppositeLinkName;
    }

    @Override
    public boolean setOrigin(Object origin) {
        if (super.setOrigin(origin)) {
            this.sortedLinks.setOrigin(origin);
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.source.isEmpty();
    }

    @Override
    public long size() {
        return this.source.size();
    }

    @Override
    public long count() {
        return this.source.count();
    }

    @Override
    public long getRoughCount() {
        return this.source.getRoughCount();
    }

    @Override
    public long getRoughSize() {
        return this.source.getRoughSize();
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        int count = 0;
        EntityIterator sorted = this.source.iterator();
        while (sorted.hasNext()) {
            EntityId entityId = sorted.nextId();
            if (entityId != null && this.sourceTypeId != entityId.getTypeId()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean canBeCached() {
        return super.canBeCached() && this.sortedLinks.canBeCached();
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        return new EntityIteratorFixingDecorator(this, new SortIndirectIterator(txn));
    }

    private static EntityIterableType getType() {
        return EntityIterableType.SORTING_LINKS;
    }

    @Override
    @NotNull
    protected EntityIterableHandle getHandleImpl() {
        return new EntityIterableHandleDecorator(this.getStore(), SortIndirectIterable.getType(), this.source.getHandle()){
            private final EntityIterableHandleBase sortedLinksHandle;
            @NotNull
            private final int[] linkIds;
            {
                this.sortedLinksHandle = (EntityIterableHandleBase)SortIndirectIterable.this.sortedLinks.getHandle();
                this.linkIds = 1.mergeFieldIds(new int[]{SortIndirectIterable.this.linkId}, 1.mergeFieldIds(this.decorated.getLinkIds(), this.sortedLinksHandle.getLinkIds()));
            }

            @Override
            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                builder.append(SortIndirectIterable.this.sourceTypeId);
                builder.append('-');
                builder.append(SortIndirectIterable.this.linkId);
                builder.append('-');
                this.applyDecoratedToBuilder(builder);
                builder.append('-');
                this.sortedLinksHandle.toString(builder);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                hash.apply(SortIndirectIterable.this.sourceTypeId);
                hash.applyDelimiter();
                hash.apply(SortIndirectIterable.this.linkId);
                hash.applyDelimiter();
                super.hashCode(hash);
                hash.applyDelimiter();
                hash.apply(this.sortedLinksHandle);
            }

            @Override
            public boolean isMatchedEntityAdded(@NotNull EntityId added2) {
                return this.decorated.isMatchedEntityAdded(added2) || this.sortedLinksHandle.isMatchedEntityAdded(added2);
            }

            @Override
            public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
                return this.decorated.isMatchedEntityDeleted(deleted) || this.sortedLinksHandle.isMatchedEntityDeleted(deleted);
            }

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                if (SortIndirectIterable.this.linkId == linkId) {
                    return true;
                }
                if (this.decorated.hasLinkId(linkId)) {
                    if (this.decorated.isMatchedLinkAdded(source, target, linkId)) {
                        return true;
                    }
                    if (!this.sortedLinksHandle.hasLinkId(linkId)) {
                        return false;
                    }
                }
                return this.sortedLinksHandle.isMatchedLinkAdded(source, target, linkId);
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                if (SortIndirectIterable.this.linkId == linkId) {
                    return true;
                }
                if (this.decorated.hasLinkId(linkId)) {
                    if (this.decorated.isMatchedLinkDeleted(source, target, linkId)) {
                        return true;
                    }
                    if (!this.sortedLinksHandle.hasLinkId(linkId)) {
                        return false;
                    }
                }
                return this.sortedLinksHandle.isMatchedLinkDeleted(source, target, linkId);
            }

            @Override
            public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
                return this.decorated.isMatchedPropertyChanged(id, propertyId, oldValue, newValue) || this.sortedLinksHandle.isMatchedPropertyChanged(id, propertyId, oldValue, newValue);
            }
        };
    }

    static {
        SortIndirectIterable.registerType(SortIndirectIterable.getType(), (txn, store, parameters) -> {
            int typeId = Integer.parseInt((String)parameters[0]);
            String typeName = null;
            for (String type : store.getEntityTypes(txn)) {
                if (typeId != store.getEntityTypeId(txn, type, false)) continue;
                typeName = type;
            }
            int linkId = Integer.parseInt((String)parameters[1]);
            String linkName = null;
            for (String name : store.getAllLinkNames(txn)) {
                if (linkId != store.getLinkId(txn, name, false)) continue;
                linkName = name;
            }
            return new SortIndirectIterable(txn, store, typeName, (EntityIterableBase)parameters[3], linkName, (EntityIterableBase)parameters[2], null, null);
        });
    }

    private final class SortIndirectIterator
    extends NonDisposableEntityIterator {
        private EntityIterator linksIterator;
        private EntityIterator foundLinksIterator;
        private EntityId nextId;
        private boolean nullIterated;
        private final PersistentStoreTransaction txn;

        SortIndirectIterator(PersistentStoreTransaction txn) {
            super(SortIndirectIterable.this);
            this.linksIterator = null;
            this.foundLinksIterator = null;
            this.nextId = null;
            this.nullIterated = false;
            this.txn = txn;
        }

        @Override
        protected boolean hasNextImpl() {
            this.checkInited();
            while (true) {
                Entity link;
                if (this.foundLinksIterator != null) {
                    if (!this.foundLinksIterator.hasNext()) {
                        this.foundLinksIterator = null;
                        continue;
                    }
                    this.nextId = this.foundLinksIterator.nextId();
                    return true;
                }
                if (!this.linksIterator.hasNext()) {
                    if (this.nullIterated) break;
                    this.nullIterated = true;
                    this.foundLinksIterator = new FilterEntityTypeIterable(this.txn, SortIndirectIterable.this.sourceTypeId, SortIndirectIterable.this.source).minus(SortIndirectIterable.this.oppositeEntityType == null ? this.txn.findWithLinks(SortIndirectIterable.this.entityType, SortIndirectIterable.this.linkName) : this.txn.findWithLinks(SortIndirectIterable.this.entityType, SortIndirectIterable.this.linkName, SortIndirectIterable.this.oppositeEntityType, SortIndirectIterable.this.oppositeLinkName)).iterator();
                    continue;
                }
                EntityId linkId = this.linksIterator.nextId();
                Entity entity = link = linkId == null ? null : SortIndirectIterable.this.getEntity(linkId);
                if (link == null) {
                    this.nullIterated = true;
                    this.foundLinksIterator = new FilterEntityTypeIterable(this.txn, SortIndirectIterable.this.sourceTypeId, SortIndirectIterable.this.source).minus(SortIndirectIterable.this.oppositeEntityType == null ? this.txn.findWithLinks(SortIndirectIterable.this.entityType, SortIndirectIterable.this.linkName) : this.txn.findWithLinks(SortIndirectIterable.this.entityType, SortIndirectIterable.this.linkName, SortIndirectIterable.this.oppositeEntityType, SortIndirectIterable.this.oppositeLinkName)).iterator();
                    continue;
                }
                this.foundLinksIterator = this.txn.findLinks(SortIndirectIterable.this.entityType, link, SortIndirectIterable.this.linkName).intersectSavingOrder((EntityIterable)SortIndirectIterable.this.source).iterator();
            }
            this.nextId = null;
            return false;
        }

        @Override
        public EntityId nextIdImpl() {
            return this.nextId;
        }

        private void checkInited() {
            if (this.linksIterator == null) {
                this.linksIterator = SortIndirectIterable.this.sortedLinks.iterator();
            }
        }
    }
}

