/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.core.dataStructures.persistent.AbstractPersistent23Tree;
import jetbrains.exodus.core.dataStructures.persistent.Persistent23Tree;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityStoreException;
import jetbrains.exodus.entitystore.PersistentEntityId;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIteratorBase;
import jetbrains.exodus.entitystore.iterate.NonDisposableEntityIterator;
import jetbrains.exodus.entitystore.iterate.PropertyValueIterator;
import jetbrains.exodus.entitystore.iterate.UpdatableCachedInstanceIterable;
import jetbrains.exodus.entitystore.iterate.UpdatablePropertiesCachedInstanceIterable;
import jetbrains.exodus.entitystore.tables.PropertyTypes;
import jetbrains.exodus.kotlin.KodusKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u000f\u0018\u0000 /2\u00020\u0001:\b/0123456B\u000f\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0000\u00a2\u0006\u0002\u0010\u0003BE\b\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0002\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0014\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\n\u0012\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0018\u001a\u00020\u0000H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0016J\b\u0010\u001d\u001a\u00020\bH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\"\u0010 \u001a\u00020\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0014\u0010#\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\nJ\u0014\u0010$\u001a\u00020\u001f2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\b\u0010*\u001a\u00020\u001aH\u0016J6\u0010+\u001a\u00020\u001c2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u001a2\u000e\u0010-\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b2\u000e\u0010.\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bR8\u0010\u0011\u001a&\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000f0\u000f \u0013*\u0012\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u000f0\u000f\u0018\u00010\u00120\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;", "Ljetbrains/exodus/entitystore/iterate/UpdatableCachedInstanceIterable;", "source", "(Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;)V", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "typeId", "", "valueClass", "Ljava/lang/Class;", "", "", "index", "Ljetbrains/exodus/core/dataStructures/persistent/Persistent23Tree;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntry;", "(Ljetbrains/exodus/entitystore/PersistentStoreTransaction;Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;ILjava/lang/Class;Ljetbrains/exodus/core/dataStructures/persistent/Persistent23Tree;)V", "currentTree", "Ljetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree;", "kotlin.jvm.PlatformType", "getCurrentTree", "()Ljetbrains/exodus/core/dataStructures/persistent/AbstractPersistent23Tree;", "mutableIndex", "Ljetbrains/exodus/core/dataStructures/persistent/Persistent23Tree$MutableTree;", "beginUpdate", "countImpl", "", "endUpdate", "", "getEntityTypeId", "getIteratorImpl", "Ljetbrains/exodus/entitystore/iterate/EntityIteratorBase;", "getPropertyRangeIterator", "min", "max", "getPropertyValueClass", "getPropertyValueIterator", "value", "getReverseIteratorImpl", "isMutated", "", "isSortedById", "size", "update", "localId", "oldValue", "newValue", "Companion", "IndexEntry", "IndexEntryNoDuplicates", "PropertiesCachedInstanceIterator", "PropertiesCachedInstanceIteratorBase", "PropertyRangeCachedInstanceIterator", "PropertyValueCachedInstanceIterator", "ReversePropertiesCachedInstanceIterator", "xodus-entity-store"})
public final class UpdatablePropertiesCachedInstanceIterable
extends UpdatableCachedInstanceIterable {
    private Persistent23Tree.MutableTree<IndexEntry> mutableIndex;
    private int typeId;
    private Class<Comparable<Object>> valueClass;
    private final Persistent23Tree<IndexEntry> index;
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    public int getEntityTypeId() {
        return this.typeId;
    }

    @Nullable
    public final Class<Comparable<Object>> getPropertyValueClass() {
        return this.valueClass;
    }

    @Override
    public boolean isSortedById() {
        return false;
    }

    @Override
    @NotNull
    public UpdatablePropertiesCachedInstanceIterable beginUpdate() {
        return new UpdatablePropertiesCachedInstanceIterable(this);
    }

    @Override
    public boolean isMutated() {
        return this.mutableIndex != null;
    }

    @Override
    public void endUpdate() {
        Persistent23Tree.MutableTree index2 = (Persistent23Tree.MutableTree)KodusKt.notNull(this.mutableIndex, (Function0)endUpdate.index.1.INSTANCE);
        index2.endWrite();
        this.mutableIndex = null;
    }

    public final void update(int typeId, long localId, @Nullable Comparable<Object> oldValue, @Nullable Comparable<Object> newValue) {
        IndexEntry newEntry;
        IndexEntry indexEntry;
        IndexEntry oldEntry;
        IndexEntry indexEntry2;
        if (this.typeId == -1) {
            this.typeId = typeId;
        }
        if (oldValue == null) {
            indexEntry2 = null;
        } else {
            Comparable comparable = PropertyTypes.toLowerCase(oldValue);
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"PropertyTypes.toLowerCase(oldValue)");
            indexEntry2 = oldEntry = new IndexEntry(comparable, localId);
        }
        if (newValue == null) {
            indexEntry = null;
        } else {
            Comparable comparable = PropertyTypes.toLowerCase(newValue);
            Intrinsics.checkExpressionValueIsNotNull((Object)comparable, (String)"PropertyTypes.toLowerCase(newValue)");
            indexEntry = newEntry = new IndexEntry(comparable, localId);
        }
        if (Intrinsics.areEqual((Object)oldEntry, (Object)newEntry)) {
            throw (Throwable)new IllegalStateException("Can't update in-memory index: both oldValue and newValue are null");
        }
        Persistent23Tree.MutableTree index2 = (Persistent23Tree.MutableTree)KodusKt.notNull(this.mutableIndex, (Function0)update.index.1.INSTANCE);
        if (oldEntry != null) {
            if (index2.contains((Comparable)oldEntry)) {
                index2.exclude((Comparable)oldEntry);
            } else if (newEntry != null && !index2.contains((Comparable)newEntry)) {
                logger.warn("In-memory index doesn't contain the value [" + oldValue + "]. New value [" + newValue + "]. Handle [" + this.getHandle() + ']');
            }
        }
        if (newEntry != null) {
            IndexEntryNoDuplicates entryNoDuplicates = new IndexEntryNoDuplicates(newEntry.getPropValue(), newEntry.getLocalId());
            if (!index2.contains((Comparable)entryNoDuplicates)) {
                newEntry.setPropValue(entryNoDuplicates.getPropValue());
                index2.add((Comparable)newEntry);
            }
            if (this.valueClass == null) {
                this.valueClass = newEntry.getPropValue().getClass();
            }
        }
    }

    @NotNull
    public final EntityIteratorBase getPropertyValueIterator(@NotNull Comparable<Object> value) {
        Intrinsics.checkParameterIsNotNull(value, (String)"value");
        return new PropertyValueCachedInstanceIterator(value);
    }

    @NotNull
    public final EntityIteratorBase getPropertyRangeIterator(@NotNull Comparable<Object> min, @NotNull Comparable<Object> max) {
        Intrinsics.checkParameterIsNotNull(min, (String)"min");
        Intrinsics.checkParameterIsNotNull(max, (String)"max");
        return new PropertyRangeCachedInstanceIterator(min, max);
    }

    @Override
    @NotNull
    public EntityIteratorBase getIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIteratorBase entityIteratorBase;
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        AbstractPersistent23Tree<IndexEntry> abstractPersistent23Tree = this.getCurrentTree();
        Intrinsics.checkExpressionValueIsNotNull(abstractPersistent23Tree, (String)"currentTree");
        if (abstractPersistent23Tree.isEmpty()) {
            EntityIteratorBase entityIteratorBase2 = EntityIteratorBase.EMPTY;
            entityIteratorBase = entityIteratorBase2;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIteratorBase2, (String)"EntityIteratorBase.EMPTY");
        } else {
            entityIteratorBase = new PropertiesCachedInstanceIterator();
        }
        return entityIteratorBase;
    }

    @Override
    @NotNull
    public EntityIteratorBase getReverseIteratorImpl(@NotNull PersistentStoreTransaction txn) {
        EntityIteratorBase entityIteratorBase;
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        AbstractPersistent23Tree<IndexEntry> abstractPersistent23Tree = this.getCurrentTree();
        Intrinsics.checkExpressionValueIsNotNull(abstractPersistent23Tree, (String)"currentTree");
        if (abstractPersistent23Tree.isEmpty()) {
            EntityIteratorBase entityIteratorBase2 = EntityIteratorBase.EMPTY;
            entityIteratorBase = entityIteratorBase2;
            Intrinsics.checkExpressionValueIsNotNull((Object)entityIteratorBase2, (String)"EntityIteratorBase.EMPTY");
        } else {
            entityIteratorBase = new ReversePropertiesCachedInstanceIterator();
        }
        return entityIteratorBase;
    }

    @Override
    public long size() {
        return this.getCurrentTree().size();
    }

    @Override
    protected long countImpl(@NotNull PersistentStoreTransaction txn) {
        Intrinsics.checkParameterIsNotNull((Object)txn, (String)"txn");
        return this.size();
    }

    private final AbstractPersistent23Tree<IndexEntry> getCurrentTree() {
        Persistent23Tree.MutableTree<IndexEntry> mutableTree = this.mutableIndex;
        return mutableTree != null ? (AbstractPersistent23Tree)mutableTree : (AbstractPersistent23Tree)this.index.beginRead();
    }

    private UpdatablePropertiesCachedInstanceIterable(PersistentStoreTransaction txn, EntityIterableBase source, int typeId, Class<Comparable<Object>> valueClass, Persistent23Tree<IndexEntry> index2) {
        super(txn, source);
        this.typeId = typeId;
        this.valueClass = valueClass;
        this.index = index2;
    }

    private UpdatablePropertiesCachedInstanceIterable(UpdatablePropertiesCachedInstanceIterable source) {
        PersistentStoreTransaction persistentStoreTransaction = source.getTransaction();
        EntityIterableBase entityIterableBase = source;
        int n = source.typeId;
        Class<Comparable<Object>> clazz = source.valueClass;
        Persistent23Tree persistent23Tree = source.index.getClone();
        Intrinsics.checkExpressionValueIsNotNull((Object)persistent23Tree, (String)"source.index.clone");
        this(persistentStoreTransaction, entityIterableBase, n, clazz, (Persistent23Tree<IndexEntry>)persistent23Tree);
        this.mutableIndex = this.index.beginWrite();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(UpdatablePropertiesCachedInstanceIterable.class);
    }

    public /* synthetic */ UpdatablePropertiesCachedInstanceIterable(PersistentStoreTransaction txn, EntityIterableBase source, int typeId, Class valueClass, Persistent23Tree index2, DefaultConstructorMarker $constructor_marker) {
        this(txn, source, typeId, valueClass, (Persistent23Tree<IndexEntry>)index2);
    }

    @JvmStatic
    @NotNull
    public static final UpdatablePropertiesCachedInstanceIterable newInstance(@Nullable PersistentStoreTransaction txn, @Nullable PropertyValueIterator it, @NotNull EntityIterableBase source) {
        return Companion.newInstance(txn, it, source);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0002\b\u0012\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0011\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0000H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00030\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntry;", "", "propValue", "", "localId", "", "(Ljava/lang/Comparable;J)V", "getLocalId", "()J", "getPropValue", "()Ljava/lang/Comparable;", "setPropValue", "(Ljava/lang/Comparable;)V", "compareTo", "", "other", "xodus-entity-store"})
    private static class IndexEntry
    implements Comparable<IndexEntry> {
        @NotNull
        private Comparable<Object> propValue;
        private final long localId;

        @Override
        public int compareTo(@NotNull IndexEntry other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            int result = this.propValue.compareTo(other.propValue);
            if (result == 0) {
                if (this.localId < other.localId) {
                    result = -1;
                } else if (this.localId > other.localId) {
                    result = 1;
                }
            }
            return result;
        }

        @NotNull
        public final Comparable<Object> getPropValue() {
            return this.propValue;
        }

        public final void setPropValue(@NotNull Comparable<Object> comparable) {
            Intrinsics.checkParameterIsNotNull(comparable, (String)"<set-?>");
            this.propValue = comparable;
        }

        public final long getLocalId() {
            return this.localId;
        }

        public IndexEntry(@NotNull Comparable<Object> propValue, long localId) {
            Intrinsics.checkParameterIsNotNull(propValue, (String)"propValue");
            this.propValue = propValue;
            this.localId = localId;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001H\u0096\u0002\u00a8\u0006\u000b"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntryNoDuplicates;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntry;", "propValue", "", "", "localId", "", "(Ljava/lang/Comparable;J)V", "compareTo", "", "other", "xodus-entity-store"})
    private static final class IndexEntryNoDuplicates
    extends IndexEntry {
        @Override
        public int compareTo(@NotNull IndexEntry other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            int result = this.getPropValue().compareTo(other.getPropValue());
            if (result == 0) {
                this.setPropValue(other.getPropValue());
                if (this.getLocalId() < other.getLocalId()) {
                    result = -1;
                } else if (this.getLocalId() > other.getLocalId()) {
                    result = 1;
                }
            }
            return result;
        }

        public IndexEntryNoDuplicates(@NotNull Comparable<Object> propValue, long localId) {
            Intrinsics.checkParameterIsNotNull(propValue, (String)"propValue");
            super(propValue, localId);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00a2\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u0014J\u0010\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015H\u0016J\b\u0010\u0017\u001a\u00020\bH\u0014J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001a"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$PropertiesCachedInstanceIteratorBase;", "Ljetbrains/exodus/entitystore/iterate/NonDisposableEntityIterator;", "Ljetbrains/exodus/entitystore/iterate/PropertyValueIterator;", "it", "", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntry;", "(Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;Ljava/util/Iterator;)V", "hasNextValid", "", "getHasNextValid", "()Z", "setHasNextValid", "(Z)V", "next", "getNext", "()Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntry;", "setNext", "(Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntry;)V", "checkIndexEntry", "entry", "currentValue", "", "", "hasNextImpl", "nextIdImpl", "Ljetbrains/exodus/entitystore/EntityId;", "xodus-entity-store"})
    private abstract class PropertiesCachedInstanceIteratorBase
    extends NonDisposableEntityIterator
    implements PropertyValueIterator {
        @Nullable
        private IndexEntry next;
        private boolean hasNextValid;
        private final Iterator<IndexEntry> it;

        @Nullable
        protected final IndexEntry getNext() {
            return this.next;
        }

        protected final void setNext(@Nullable IndexEntry indexEntry) {
            this.next = indexEntry;
        }

        protected final boolean getHasNextValid() {
            return this.hasNextValid;
        }

        protected final void setHasNextValid(boolean bl) {
            this.hasNextValid = bl;
        }

        @Override
        protected boolean hasNextImpl() {
            if (!this.hasNextValid) {
                if (!this.it.hasNext()) {
                    return false;
                }
                IndexEntry next = this.it.next();
                if (!this.checkIndexEntry(next)) {
                    return false;
                }
                this.next = next;
                this.hasNextValid = true;
            }
            return true;
        }

        @Override
        @Nullable
        public EntityId nextIdImpl() {
            if (!this.hasNextImpl()) {
                return null;
            }
            int n = UpdatablePropertiesCachedInstanceIterable.this.getEntityTypeId();
            IndexEntry indexEntry = this.next;
            if (indexEntry == null) {
                Intrinsics.throwNpe();
            }
            PersistentEntityId result = new PersistentEntityId(n, indexEntry.getLocalId());
            this.hasNextValid = false;
            return result;
        }

        @Override
        @Nullable
        public Comparable<Object> currentValue() {
            IndexEntry indexEntry = this.next;
            return indexEntry != null ? indexEntry.getPropValue() : null;
        }

        protected boolean checkIndexEntry(@Nullable IndexEntry entry) {
            return entry != null;
        }

        public PropertiesCachedInstanceIteratorBase(Iterator<? extends IndexEntry> it) {
            Intrinsics.checkParameterIsNotNull(it, (String)"it");
            super(UpdatablePropertiesCachedInstanceIterable.this);
            this.it = it;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$PropertiesCachedInstanceIterator;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$PropertiesCachedInstanceIteratorBase;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;", "(Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;)V", "xodus-entity-store"})
    private final class PropertiesCachedInstanceIterator
    extends PropertiesCachedInstanceIteratorBase {
        public PropertiesCachedInstanceIterator() {
            Iterator iterator = UpdatablePropertiesCachedInstanceIterable.this.getCurrentTree().iterator();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"currentTree.iterator()");
            super(iterator);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$ReversePropertiesCachedInstanceIterator;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$PropertiesCachedInstanceIteratorBase;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;", "(Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;)V", "xodus-entity-store"})
    private final class ReversePropertiesCachedInstanceIterator
    extends PropertiesCachedInstanceIteratorBase {
        public ReversePropertiesCachedInstanceIterator() {
            Iterator iterator = UpdatablePropertiesCachedInstanceIterable.this.getCurrentTree().reverseIterator();
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"currentTree.reverseIterator()");
            super(iterator);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$PropertyValueCachedInstanceIterator;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$PropertiesCachedInstanceIteratorBase;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;", "value", "", "", "(Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;Ljava/lang/Comparable;)V", "checkIndexEntry", "", "entry", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntry;", "xodus-entity-store"})
    private final class PropertyValueCachedInstanceIterator
    extends PropertiesCachedInstanceIteratorBase {
        private final Comparable<Object> value;

        @Override
        protected boolean checkIndexEntry(@Nullable IndexEntry entry) {
            return entry != null && Intrinsics.areEqual(entry.getPropValue(), this.value);
        }

        public PropertyValueCachedInstanceIterator(Comparable<Object> value) {
            Intrinsics.checkParameterIsNotNull(value, (String)"value");
            Iterator iterator = UpdatablePropertiesCachedInstanceIterable.this.getCurrentTree().tailIterator((Comparable)new IndexEntry(value, 0L));
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"currentTree.tailIterator(IndexEntry(value, 0))");
            super(iterator);
            this.value = value;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$PropertyRangeCachedInstanceIterator;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$PropertiesCachedInstanceIteratorBase;", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;", "min", "", "", "max", "(Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;Ljava/lang/Comparable;Ljava/lang/Comparable;)V", "checkIndexEntry", "", "entry", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$IndexEntry;", "xodus-entity-store"})
    private final class PropertyRangeCachedInstanceIterator
    extends PropertiesCachedInstanceIteratorBase {
        private final Comparable<Object> max;

        @Override
        protected boolean checkIndexEntry(@Nullable IndexEntry entry) {
            return entry != null && entry.getPropValue().compareTo(this.max) <= 0;
        }

        public PropertyRangeCachedInstanceIterator(@NotNull Comparable<Object> min, Comparable<Object> max) {
            Intrinsics.checkParameterIsNotNull(min, (String)"min");
            Intrinsics.checkParameterIsNotNull(max, (String)"max");
            Iterator iterator = UpdatablePropertiesCachedInstanceIterable.this.getCurrentTree().tailIterator((Comparable)new IndexEntry(min, 0L));
            Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"currentTree.tailIterator(IndexEntry(min, 0))");
            super(iterator);
            this.max = max;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u001d\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "currentValue", "", "Ljetbrains/exodus/entitystore/iterate/PropertyValueIterator;", "getCurrentValue", "(Ljetbrains/exodus/entitystore/iterate/PropertyValueIterator;)Ljava/lang/Comparable;", "nextId", "Ljetbrains/exodus/entitystore/EntityId;", "Lorg/jetbrains/annotations/Nullable;", "getNextId", "(Ljetbrains/exodus/entitystore/iterate/PropertyValueIterator;)Ljetbrains/exodus/entitystore/EntityId;", "newInstance", "Ljetbrains/exodus/entitystore/iterate/UpdatablePropertiesCachedInstanceIterable;", "txn", "Ljetbrains/exodus/entitystore/PersistentStoreTransaction;", "it", "source", "Ljetbrains/exodus/entitystore/iterate/EntityIterableBase;", "xodus-entity-store"})
    public static final class Companion {
        private final EntityId getNextId(@NotNull PropertyValueIterator $this$nextId) {
            Object object = KodusKt.getNotNull((Object)$this$nextId.nextId());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.nextId().notNull");
            return (EntityId)object;
        }

        private final Comparable<Object> getCurrentValue(@NotNull PropertyValueIterator $this$currentValue) {
            Object object = KodusKt.getNotNull((Object)$this$currentValue.currentValue());
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"this.currentValue().notNull");
            return (Comparable)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final UpdatablePropertiesCachedInstanceIterable newInstance(@Nullable PersistentStoreTransaction txn, @Nullable PropertyValueIterator it, @NotNull EntityIterableBase source) {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            try {
                if (it != null && it.hasNext()) {
                    Persistent23Tree index2 = new Persistent23Tree();
                    EntityId id = this.getNextId(it);
                    int typeId = id.getTypeId();
                    Comparable<Object> prevValue = this.getCurrentValue(it);
                    Class<?> valueClass = prevValue.getClass();
                    List tempList = CollectionsKt.mutableListOf((Object[])new IndexEntry[]{new IndexEntry(prevValue, id.getLocalId())});
                    while (it.hasNext()) {
                        long localId = this.getNextId(it).getLocalId();
                        Comparable<Object> currentValue = this.getCurrentValue(it);
                        if (Intrinsics.areEqual(prevValue, currentValue)) {
                            tempList.add(new IndexEntry(prevValue, localId));
                            continue;
                        }
                        tempList.add(new IndexEntry(currentValue, localId));
                        prevValue = currentValue;
                        if (!(Intrinsics.areEqual(valueClass, currentValue.getClass()) ^ true)) continue;
                        throw (Throwable)new EntityStoreException("Unexpected property value class");
                    }
                    Object object = index2.beginWrite();
                    boolean bl = false;
                    boolean bl2 = false;
                    Persistent23Tree.MutableTree $this$run = object;
                    boolean bl3 = false;
                    $this$run.addAll((Iterable)tempList, tempList.size());
                    $this$run.endWrite();
                    object = new UpdatablePropertiesCachedInstanceIterable(txn, source, typeId, valueClass, index2, null);
                    return object;
                }
                UpdatablePropertiesCachedInstanceIterable updatablePropertiesCachedInstanceIterable = new UpdatablePropertiesCachedInstanceIterable(txn, source, -1, null, new Persistent23Tree(), null);
                return updatablePropertiesCachedInstanceIterable;
            }
            finally {
                if (it instanceof EntityIteratorBase) {
                    ((EntityIteratorBase)((Object)it)).disposeIfShouldBe();
                }
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

