/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate.binop;

import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterableHandle;
import jetbrains.exodus.entitystore.EntityIterableType;
import jetbrains.exodus.entitystore.PersistentStoreTransaction;
import jetbrains.exodus.entitystore.iterate.EntityIterableBase;
import jetbrains.exodus.entitystore.iterate.EntityIterableHandleBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BinaryOperatorEntityIterable
extends EntityIterableBase {
    private static final int MAXIMUM_DEPTH_TO_ALLOW_CACHING = 200;
    private static final int COMMUTATIVE_FLAG = 0x40000000;
    protected static final int SORTED_BY_ID_FLAG = 0x20000000;
    private static final int CAN_BE_CACHED_FLAG = 0x10000000;
    private static final int DEPTH_MASK = 0xFFFFFFF;
    @NotNull
    protected final EntityIterableBase iterable1;
    @NotNull
    protected final EntityIterableBase iterable2;
    protected int depth;

    protected BinaryOperatorEntityIterable(@Nullable PersistentStoreTransaction txn, @NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2, boolean isCommutative) {
        super(txn);
        int depth1 = iterable1.depth();
        int depth2 = iterable2.depth();
        if (!isCommutative || depth1 <= depth2) {
            this.iterable1 = iterable1;
            this.iterable2 = iterable2;
        } else {
            this.iterable1 = iterable2;
            this.iterable2 = iterable1;
        }
        int n = this.depth = depth1 > depth2 ? depth1 + 1 : depth2 + 1;
        if (isCommutative) {
            this.depth += 0x40000000;
        }
        if (this.depth() < 200 && BinaryOperatorEntityIterable.shouldBinaryOperationBeCached(iterable1, iterable2)) {
            this.depth += 0x10000000;
        }
    }

    @Override
    public int getEntityTypeId() {
        return this.getHandleImpl().getEntityTypeId();
    }

    @NotNull
    public EntityIterableBase getLeft() {
        return this.iterable1;
    }

    @NotNull
    public EntityIterableBase getRight() {
        return this.iterable2;
    }

    @Override
    public boolean setOrigin(Object origin) {
        if (super.setOrigin(origin)) {
            this.iterable1.setOrigin(origin);
            this.iterable2.setOrigin(origin);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSortedById() {
        return (this.depth & 0x20000000) != 0;
    }

    @Override
    public int depth() {
        return this.depth & 0xFFFFFFF;
    }

    @Override
    public boolean canBeCached() {
        return (this.depth & 0x10000000) != 0;
    }

    protected final boolean isCommutative() {
        return (this.depth & 0x40000000) != 0;
    }

    protected abstract EntityIterableType getIterableType();

    @Override
    @NotNull
    protected EntityIterableHandleBase getHandleImpl() {
        return new EntityIterableHandleBase(this.getStore(), this.getIterableType()){
            private int entityTypeId;
            @NotNull
            private final int[] linkIds;
            @NotNull
            private final int[] propertyIds;
            @NotNull
            private final int[] typeIdsAffectingCreation;
            {
                this.entityTypeId = -1;
                this.linkIds = 1.mergeFieldIds(BinaryOperatorEntityIterable.this.iterable1.getHandle().getLinkIds(), BinaryOperatorEntityIterable.this.iterable2.getHandle().getLinkIds());
                this.propertyIds = 1.mergeFieldIds(BinaryOperatorEntityIterable.this.iterable1.getHandle().getPropertyIds(), BinaryOperatorEntityIterable.this.iterable2.getHandle().getPropertyIds());
                this.typeIdsAffectingCreation = 1.mergeFieldIds(BinaryOperatorEntityIterable.this.iterable1.getHandle().getTypeIdsAffectingCreation(), BinaryOperatorEntityIterable.this.iterable2.getHandle().getTypeIdsAffectingCreation());
            }

            @Override
            @NotNull
            public int[] getLinkIds() {
                return this.linkIds;
            }

            @Override
            @NotNull
            public int[] getPropertyIds() {
                return this.propertyIds;
            }

            @Override
            @NotNull
            public int[] getTypeIdsAffectingCreation() {
                return this.typeIdsAffectingCreation;
            }

            @Override
            public void toString(@NotNull StringBuilder builder) {
                super.toString(builder);
                ((EntityIterableHandleBase)BinaryOperatorEntityIterable.this.iterable1.getHandle()).toString(builder);
                builder.append('-');
                ((EntityIterableHandleBase)BinaryOperatorEntityIterable.this.iterable2.getHandle()).toString(builder);
            }

            @Override
            public void hashCode(@NotNull EntityIterableHandleBase.EntityIterableHandleHash hash) {
                EntityIterableHandle handle1 = BinaryOperatorEntityIterable.this.iterable1.getHandle();
                EntityIterableHandle handle2 = BinaryOperatorEntityIterable.this.iterable2.getHandle();
                if (!BinaryOperatorEntityIterable.this.isCommutative() || BinaryOperatorEntityIterable.isOrderOk(handle1, handle2)) {
                    hash.apply(handle1);
                    hash.applyDelimiter();
                    hash.apply(handle2);
                } else {
                    hash.apply(handle2);
                    hash.applyDelimiter();
                    hash.apply(handle1);
                }
            }

            @Override
            public int getEntityTypeId() {
                if (this.entityTypeId == -1) {
                    int entityTypeId2;
                    int entityTypeId1 = BinaryOperatorEntityIterable.this.iterable1.getHandle().getEntityTypeId();
                    this.entityTypeId = entityTypeId1 < 0 ? Integer.MIN_VALUE : (entityTypeId1 == (entityTypeId2 = BinaryOperatorEntityIterable.this.iterable2.getHandle().getEntityTypeId()) ? entityTypeId1 : Integer.MIN_VALUE);
                }
                return this.entityTypeId;
            }

            @Override
            public boolean isMatchedEntityAdded(@NotNull EntityId added2) {
                return BinaryOperatorEntityIterable.this.iterable1.getHandle().isMatchedEntityAdded(added2) || BinaryOperatorEntityIterable.this.iterable2.getHandle().isMatchedEntityAdded(added2);
            }

            @Override
            public boolean isMatchedEntityDeleted(@NotNull EntityId deleted) {
                return BinaryOperatorEntityIterable.this.iterable1.getHandle().isMatchedEntityDeleted(deleted) || BinaryOperatorEntityIterable.this.iterable2.getHandle().isMatchedEntityDeleted(deleted);
            }

            @Override
            public boolean isMatchedLinkAdded(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                EntityIterableHandle handle2;
                EntityIterableHandle handle1 = BinaryOperatorEntityIterable.this.iterable1.getHandle();
                if (handle1.hasLinkId(linkId)) {
                    if (handle1.isMatchedLinkAdded(source, target, linkId)) {
                        return true;
                    }
                    handle2 = BinaryOperatorEntityIterable.this.iterable2.getHandle();
                    if (!handle2.hasLinkId(linkId)) {
                        return false;
                    }
                } else {
                    handle2 = BinaryOperatorEntityIterable.this.iterable2.getHandle();
                }
                return handle2.isMatchedLinkAdded(source, target, linkId);
            }

            @Override
            public boolean isMatchedLinkDeleted(@NotNull EntityId source, @NotNull EntityId target, int linkId) {
                EntityIterableHandle handle2;
                EntityIterableHandle handle1 = BinaryOperatorEntityIterable.this.iterable1.getHandle();
                if (handle1.hasLinkId(linkId)) {
                    if (handle1.isMatchedLinkDeleted(source, target, linkId)) {
                        return true;
                    }
                    handle2 = BinaryOperatorEntityIterable.this.iterable2.getHandle();
                    if (!handle2.hasLinkId(linkId)) {
                        return false;
                    }
                } else {
                    handle2 = BinaryOperatorEntityIterable.this.iterable2.getHandle();
                }
                return handle2.isMatchedLinkDeleted(source, target, linkId);
            }

            @Override
            public boolean isMatchedPropertyChanged(@NotNull EntityId id, int propertyId, @Nullable Comparable oldValue, @Nullable Comparable newValue) {
                int entityTypeId = this.getEntityTypeId();
                return !(entityTypeId >= 0 && entityTypeId != id.getTypeId() || !BinaryOperatorEntityIterable.this.iterable1.getHandle().isMatchedPropertyChanged(id, propertyId, oldValue, newValue) && !BinaryOperatorEntityIterable.this.iterable2.getHandle().isMatchedPropertyChanged(id, propertyId, oldValue, newValue));
            }

            @Override
            public boolean isConsistent() {
                return BinaryOperatorEntityIterable.this.iterable1.getHandle().isConsistent() && BinaryOperatorEntityIterable.this.iterable2.getHandle().isConsistent();
            }

            @Override
            public boolean isExpired() {
                return BinaryOperatorEntityIterable.this.iterable1.getHandle().isExpired() || BinaryOperatorEntityIterable.this.iterable2.getHandle().isExpired();
            }
        };
    }

    private static boolean shouldBinaryOperationBeCached(@NotNull EntityIterableBase iterable1, @NotNull EntityIterableBase iterable2) {
        return !(!iterable1.getHandle().getType().isPropertyIndex() && !iterable1.canBeCached() || !iterable2.getHandle().getType().isPropertyIndex() && !iterable2.canBeCached());
    }

    private static boolean isOrderOk(@NotNull EntityIterableHandle handle1, @NotNull EntityIterableHandle handle2) {
        return handle1.hashCode() < handle2.hashCode();
    }
}

