/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.management;

import jetbrains.exodus.entitystore.PersistentEntityStoreImpl;
import jetbrains.exodus.entitystore.PersistentEntityStoreStatistics;
import jetbrains.exodus.entitystore.management.EntityStoreStatisticsMBean;
import jetbrains.exodus.management.MBeanBase;
import org.jetbrains.annotations.NotNull;

public class EntityStoreStatistics
extends MBeanBase
implements EntityStoreStatisticsMBean {
    @NotNull
    private final PersistentEntityStoreImpl store;

    public EntityStoreStatistics(@NotNull PersistentEntityStoreImpl store) {
        super(EntityStoreStatistics.getObjectName(store));
        this.store = store;
    }

    @Override
    public long getBlobsDiskUsage() {
        return this.store.getStatistics().getStatisticsItem((Enum)PersistentEntityStoreStatistics.Type.BLOBS_DISK_USAGE).getTotal();
    }

    @Override
    public long getNumberOfCachingJobs() {
        return this.store.getStatistics().getStatisticsItem((Enum)PersistentEntityStoreStatistics.Type.CACHING_JOBS).getTotal();
    }

    @Override
    public long getTotalCachingJobsEnqueued() {
        return this.store.getEntityIterableCache().getStats().getTotalJobsEnqueued();
    }

    @Override
    public long getTotalCachingJobsNotQueued() {
        return this.store.getEntityIterableCache().getStats().getTotalJobsNotQueued();
    }

    @Override
    public long getTotalCachingJobsStarted() {
        return this.store.getEntityIterableCache().getStats().getTotalJobsStarted();
    }

    @Override
    public long getTotalCachingJobsInterrupted() {
        return this.store.getEntityIterableCache().getStats().getTotalJobsInterrupted();
    }

    @Override
    public long getTotalCachingJobsNotStarted() {
        return this.store.getEntityIterableCache().getStats().getTotalJobsNotStarted();
    }

    @Override
    public long getTotalCachingCountJobsEnqueued() {
        return this.store.getEntityIterableCache().getStats().getTotalCountJobsEnqueued();
    }

    @Override
    public long getTotalEntityIterableCacheHits() {
        return this.store.getEntityIterableCache().getStats().getTotalHits();
    }

    @Override
    public long getTotalEntityIterableCacheMisses() {
        return this.store.getEntityIterableCache().getStats().getTotalMisses();
    }

    @Override
    public long getTotalEntityIterableCacheCountHits() {
        return this.store.getEntityIterableCache().getStats().getTotalCountHits();
    }

    @Override
    public long getTotalEntityIterableCacheCountMisses() {
        return this.store.getEntityIterableCache().getStats().getTotalCountMisses();
    }

    @Override
    public float getEntityIterableCacheHitRate() {
        return this.store.getEntityIterableCache().hitRate();
    }

    @Override
    public float getEntityIterableCacheCountHitRate() {
        return this.store.getEntityIterableCache().countsCacheHitRate();
    }

    @Override
    public float getBlobStringsCacheHitRate() {
        return this.store.getBlobVault().getStringContentCacheHitRate();
    }

    public static String getObjectName(@NotNull PersistentEntityStoreImpl store) {
        return "jetbrains.exodus.entitystore: type=EntityStoreStatistics, location=" + EntityStoreStatistics.escapeLocation((String)store.getLocation()) + ", name=" + store.getName();
    }
}

